/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.digest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.codehaus.plexus.digest.DigestUtils;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class ChecksumFile {
    private Digester digestSha1;
    private Digester digestMd5;

    public boolean isValidChecksum(File checksumFile) throws DigesterException, FileNotFoundException, IOException {
        if (!checksumFile.exists()) {
            throw new FileNotFoundException("Unable to find checksum file " + checksumFile.getAbsolutePath());
        }
        if (!checksumFile.isFile()) {
            throw new IOException("Unable to load checksum from non-file " + checksumFile.getAbsolutePath());
        }
        String path = checksumFile.getAbsolutePath();
        Digester digester = null;
        if (path.endsWith(this.digestMd5.getFilenameExtension())) {
            digester = this.digestMd5;
        } else if (path.endsWith(this.digestSha1.getFilenameExtension())) {
            digester = this.digestSha1;
        }
        if (digester == null) {
            throw new DigesterException("Unable to determine digester type from filename " + path);
        }
        File referenceFile = new File(path.substring(0, path.length() - digester.getFilenameExtension().length()));
        String rawChecksum = FileUtils.fileRead((File)checksumFile);
        String expectedChecksum = DigestUtils.cleanChecksum(rawChecksum, digester, referenceFile.getName());
        String actualChecksum = digester.calc(referenceFile);
        return StringUtils.equalsIgnoreCase((String)expectedChecksum, (String)actualChecksum);
    }

    public File createChecksum(File referenceFile, Digester digester) throws DigesterException, IOException {
        File checksumFile = new File(referenceFile.getAbsolutePath() + digester.getFilenameExtension());
        String checksum = digester.calc(referenceFile);
        FileUtils.fileWrite((String)checksumFile.getAbsolutePath(), (String)(checksum + "  " + referenceFile.getName()));
        return checksumFile;
    }
}

