/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.metadata.ExtractorConfiguration;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.metadata.merge.Merger;

public abstract class AbstractDescriptorMojo
extends AbstractMojo {
    protected static final String COMPILE_SCOPE = "compile";
    protected static final String TEST_SCOPE = "test";
    protected File generatedComponentDescriptor;
    protected File sourceComponentDescriptor;
    protected File intermediaryComponentDescriptor;
    private boolean containerDescriptor;
    protected MavenProject mavenProject;
    protected MavenProjectHelper mavenProjectHelper;
    protected MetadataGenerator metadataGenerator;
    private Merger merger;

    protected void generateDescriptor(String scope, File outputFile) throws MojoExecutionException {
        ExtractorConfiguration extractorConfiguration = new ExtractorConfiguration();
        try {
            if (scope.equals(COMPILE_SCOPE)) {
                extractorConfiguration.classpath = this.mavenProject.getCompileClasspathElements();
                extractorConfiguration.classesDirectory = new File(this.mavenProject.getBuild().getOutputDirectory());
                extractorConfiguration.sourceDirectories = this.mavenProject.getCompileSourceRoots();
            } else if (scope.equals(TEST_SCOPE)) {
                extractorConfiguration.classpath = this.mavenProject.getTestClasspathElements();
                extractorConfiguration.classesDirectory = new File(this.mavenProject.getBuild().getTestOutputDirectory());
                extractorConfiguration.sourceDirectories = this.mavenProject.getTestCompileSourceRoots();
            }
            if (this.sourceComponentDescriptor.exists()) {
                this.metadataGenerator.generateDescriptor(extractorConfiguration, this.intermediaryComponentDescriptor);
                ArrayList<File> componentDescriptors = new ArrayList<File>();
                componentDescriptors.add(this.sourceComponentDescriptor);
                if (this.intermediaryComponentDescriptor.exists()) {
                    componentDescriptors.add(this.intermediaryComponentDescriptor);
                }
                this.merger.mergeDescriptors(outputFile, componentDescriptors);
            } else {
                this.metadataGenerator.generateDescriptor(extractorConfiguration, this.generatedComponentDescriptor);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating metadata: ", e);
        }
    }
}

