/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.gleaner;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.metadata.gleaner.ClassComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.ComponentGleanerException;
import org.codehaus.plexus.metadata.gleaner.ComponentGleanerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationComponentGleaner
extends ComponentGleanerSupport
implements ClassComponentGleaner {
    @Override
    public ComponentDescriptor glean(Class clazz) throws ComponentGleanerException {
        assert (clazz != null);
        Class type = clazz;
        if (Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        Component anno = type.getAnnotation(Component.class);
        if (anno == null) {
            return null;
        }
        ComponentDescriptor component = new ComponentDescriptor();
        component.setRole(anno.role().getName());
        component.setRoleHint(this.filterEmptyAsNull(anno.hint()));
        component.setImplementation(type.getName());
        component.setVersion(this.filterEmptyAsNull(anno.version()));
        component.setComponentType(this.filterEmptyAsNull(anno.type()));
        component.setInstantiationStrategy(this.filterEmptyAsNull(anno.instantiationStrategy()));
        component.setLifecycleHandler(this.filterEmptyAsNull(anno.lifecycleHandler()));
        component.setComponentProfile(this.filterEmptyAsNull(anno.profile()));
        component.setComponentComposer(this.filterEmptyAsNull(anno.composer()));
        component.setComponentConfigurator(this.filterEmptyAsNull(anno.configurator()));
        component.setComponentFactory(this.filterEmptyAsNull(anno.factory()));
        component.setDescription(this.filterEmptyAsNull(anno.description()));
        component.setAlias(this.filterEmptyAsNull(anno.alias()));
        component.setIsolatedRealm(anno.isolatedRealm());
        for (Class t : this.getClasses(type)) {
            for (Field field : t.getDeclaredFields()) {
                PlexusConfiguration config;
                ComponentRequirement requirement = this.findRequirement(field);
                if (requirement != null) {
                    component.addRequirement(requirement);
                }
                if ((config = this.findConfiguration(field)) == null) continue;
                this.addChildConfiguration(component, config);
            }
        }
        return component;
    }

    private List<Class> getClasses(Class<?> type) {
        assert (type != null);
        ArrayList<Class> classes = new ArrayList<Class>();
        while (type != null) {
            classes.add(type);
            type = type.getSuperclass();
        }
        return classes;
    }

    private ComponentRequirement findRequirement(Field field) {
        ComponentRequirement requirement;
        assert (field != null);
        Requirement anno = field.getAnnotation(Requirement.class);
        if (anno == null) {
            return null;
        }
        Class<?> type = field.getType();
        if (this.isRequirementListType(type)) {
            requirement = new ComponentRequirementList();
            String[] hints = anno.hints();
            if (hints != null && hints.length > 0) {
                ((ComponentRequirementList)requirement).setRoleHints(Arrays.asList(hints));
            }
        } else {
            requirement = new ComponentRequirement();
            requirement.setRoleHint(this.filterEmptyAsNull(anno.hint()));
        }
        if (anno.role().isAssignableFrom(Object.class)) {
            requirement.setRole(type.getName());
        } else {
            requirement.setRole(anno.role().getName());
        }
        requirement.setFieldName(field.getName());
        requirement.setFieldMappingType(type.getName());
        return requirement;
    }

    private PlexusConfiguration findConfiguration(Field field) {
        assert (field != null);
        Configuration anno = field.getAnnotation(Configuration.class);
        if (anno == null) {
            return null;
        }
        String name = this.filterEmptyAsNull(anno.name());
        if (name == null) {
            name = field.getName();
        }
        name = this.deHump(name);
        XmlPlexusConfiguration config = new XmlPlexusConfiguration(name);
        String value = this.filterEmptyAsNull(anno.value());
        if (value != null) {
            config.setValue(value);
        }
        return config;
    }
}

