/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.metadata.ExtractorConfiguration;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.tools.cli.AbstractCli;

public class PlexusMetadataGeneratorCli
extends AbstractCli {
    public static final char DIRECTORY = 'd';
    public static final char OUTPUT = 'o';

    public static void main(String[] args) throws Exception {
        new PlexusMetadataGeneratorCli().execute(args);
    }

    public String getPomPropertiesPath() {
        return "META-INF/maven/org.codehaus.plexus/plexus-metadata-generator/pom.properties";
    }

    public Options buildCliOptions(Options options) {
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Project directory.");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output directory.");
        options.addOption(OptionBuilder.create((char)'o'));
        return options;
    }

    public void invokePlexusComponent(CommandLine cli, PlexusContainer plexus) throws Exception {
        MetadataGenerator mg = (MetadataGenerator)plexus.lookup(MetadataGenerator.class);
        File directory = new File(cli.getOptionValue('d'));
        ExtractorConfiguration ec = new ExtractorConfiguration();
        ec.outputDirectory = new File(directory, "target/classes");
        ec.classpath = Collections.EMPTY_LIST;
        ec.sourceDirectories = Arrays.asList(new File(directory, "src/main/java").getAbsolutePath());
        File output = new File(cli.getOptionValue('o'));
        mg.generateDescriptor(ec, output);
    }
}

