/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.metadata.ClassComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorWriter;
import org.codehaus.plexus.metadata.DefaultComponentDescriptorWriter;
import org.codehaus.plexus.metadata.ExtractorConfiguration;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.metadata.SourceComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.gleaner.AnnotationComponentGleaner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class DefaultMetadataGenerator
extends AbstractLogEnabled
implements MetadataGenerator {
    private ComponentDescriptor[] roleDefaults;
    private ComponentDescriptorExtractor[] extractors;
    private ComponentDescriptorWriter writer = new DefaultComponentDescriptorWriter();

    public void generateDescriptor(ExtractorConfiguration configuration, File outputFile) throws Exception {
        assert (outputFile != null);
        if (this.extractors == null || this.extractors.length == 0) {
            this.extractors = new ComponentDescriptorExtractor[]{new SourceComponentDescriptorExtractor(), new ClassComponentDescriptorExtractor(new AnnotationComponentGleaner())};
        }
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        for (int i = 0; i < this.extractors.length; ++i) {
            this.getLogger().debug("Using extractor: " + this.extractors[i]);
            try {
                List<ComponentDescriptor> list = this.extractors[i].extract(configuration, this.roleDefaults);
                if (list == null || list.isEmpty()) continue;
                descriptors.addAll(list);
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to extract descriptors", e);
            }
        }
        if (descriptors.size() == 0) {
            this.getLogger().debug("No components found");
        } else {
            this.getLogger().info("Discovered " + descriptors.size() + " component descriptors(s)");
            ComponentSetDescriptor set = new ComponentSetDescriptor();
            set.setComponents(descriptors);
            set.setDependencies(Collections.EMPTY_LIST);
            try {
                this.writeDescriptor(set, outputFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to write output file", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor(ComponentSetDescriptor desc, File outputFile) throws Exception {
        assert (desc != null);
        assert (outputFile != null);
        FileUtils.forceMkdir((File)outputFile.getParentFile());
        BufferedWriter output = new BufferedWriter(new FileWriter(outputFile));
        try {
            this.writer.writeDescriptorSet(output, desc, false);
            output.flush();
        }
        finally {
            IOUtil.close((Writer)output);
        }
        this.getLogger().debug("Wrote: " + outputFile);
    }
}

