/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.metadata.ExtractorConfiguration;
import org.codehaus.plexus.metadata.MetadataGenerator;

public abstract class AbstractDescriptorMojo
extends AbstractMojo {
    protected static final String COMPILE_SCOPE = "compile";
    protected static final String TEST_SCOPE = "test";
    protected String fileName;
    private boolean containerDescriptor;
    private MavenProject mavenProject;
    private MavenProjectHelper mavenProjectHelper;
    private MetadataGenerator metadataGenerator;

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected MavenProjectHelper getMavenProjectHelper() {
        return this.mavenProjectHelper;
    }

    protected void generateDescriptor(String scope, File outputFile) throws MojoExecutionException {
        ExtractorConfiguration ec = new ExtractorConfiguration();
        try {
            if (scope.equals(COMPILE_SCOPE)) {
                ec.classpath = this.mavenProject.getCompileClasspathElements();
                ec.outputDirectory = new File(this.mavenProject.getBuild().getOutputDirectory());
                ec.sourceDirectories = this.mavenProject.getCompileSourceRoots();
            } else if (scope.equals(TEST_SCOPE)) {
                ec.classpath = this.mavenProject.getTestClasspathElements();
                ec.outputDirectory = new File(this.mavenProject.getBuild().getTestOutputDirectory());
                ec.sourceDirectories = this.mavenProject.getTestCompileSourceRoots();
            }
            this.metadataGenerator.generateDescriptor(ec, outputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating metadata: ", e);
        }
    }
}

