/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.testing.PlexusTest;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@PlexusTest
public abstract class AbstractCompilerTest {
    private boolean compilerDebug = false;
    private boolean compilerDeprecationWarnings = false;
    private boolean forceJavacCompilerUse = false;
    @Inject
    private Map<String, Compiler> compilers;
    @Inject
    private ArtifactRepositoryLayout repositoryLayout;
    private ArtifactRepository localRepository;

    protected abstract String getRoleHint();

    @BeforeEach
    final void setUpLocalRepo() throws Exception {
        File settingsFile;
        String localRepo = System.getProperty("maven.repo.local");
        if (localRepo == null && (settingsFile = new File(System.getProperty("user.home"), ".m2/settings.xml")).exists()) {
            Settings settings = new SettingsXpp3Reader().read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            localRepo = settings.getLocalRepository();
        }
        if (localRepo == null) {
            localRepo = System.getProperty("user.home") + "/.m2/repository";
        }
        this.localRepository = new DefaultArtifactRepository("local", "file://" + localRepo, this.repositoryLayout);
    }

    protected void setCompilerDebug(boolean flag) {
        this.compilerDebug = flag;
    }

    protected void setCompilerDeprecationWarnings(boolean flag) {
        this.compilerDeprecationWarnings = flag;
    }

    public void setForceJavacCompilerUse(boolean forceJavacCompilerUse) {
        this.forceJavacCompilerUse = forceJavacCompilerUse;
    }

    protected final Compiler getCompiler() {
        return this.compilers.get(this.getRoleHint());
    }

    protected List<String> getClasspath() throws Exception {
        ArrayList<String> cp = new ArrayList<String>();
        File file = this.getLocalArtifactPath("commons-lang", "commons-lang", "2.0", "jar");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)file.canRead()).as("test prerequisite: commons-lang library must be available in local repository, expected " + file.getAbsolutePath(), new Object[0])).isTrue();
        cp.add(file.getAbsolutePath());
        return cp;
    }

    protected void configureCompilerConfig(CompilerConfiguration compilerConfig) {
    }

    @Test
    public void testCompilingSources() throws Exception {
        int expectedWarnings;
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        TreeSet<String> files = new TreeSet<String>();
        for (CompilerConfiguration compilerConfig : this.getCompilerConfigurations()) {
            File outputDir = new File(compilerConfig.getOutputLocation());
            messages.addAll(this.getCompiler().performCompile(compilerConfig).getCompilerMessages());
            if (!outputDir.isDirectory()) continue;
            files.addAll(this.normalizePaths(FileUtils.getFileNames((File)outputDir, null, null, (boolean)false)));
        }
        int numCompilerErrors = this.compilerErrorCount(messages);
        int numCompilerWarnings = messages.size() - numCompilerErrors;
        int expectedErrors = this.expectedErrors();
        if (expectedErrors != numCompilerErrors) {
            System.out.println(numCompilerErrors + " error(s) found:");
            ArrayList<String> errors = new ArrayList<String>();
            for (CompilerMessage error : messages) {
                if (!error.isError()) continue;
                System.out.println("----");
                System.out.println(error.getFile());
                System.out.println(error.getMessage());
                System.out.println("----");
                errors.add(error.getMessage());
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numCompilerErrors).as("Wrong number of compilation errors (" + numCompilerErrors + "/" + expectedErrors + ") : " + this.displayLines(errors), new Object[0])).isEqualTo(expectedErrors);
        }
        if ((expectedWarnings = this.expectedWarnings()) != numCompilerWarnings) {
            ArrayList<String> warnings = new ArrayList<String>();
            System.out.println(numCompilerWarnings + " warning(s) found:");
            for (CompilerMessage error : messages) {
                if (error.isError()) continue;
                System.out.println("----");
                System.out.println(error.getFile());
                System.out.println(error.getMessage());
                System.out.println("----");
                warnings.add(error.getMessage());
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numCompilerWarnings).as("Wrong number (" + numCompilerWarnings + "/" + expectedWarnings + ") of compilation warnings: " + this.displayLines(warnings), new Object[0])).isEqualTo(expectedWarnings);
        }
        Assertions.assertThat(files).isEqualTo(new TreeSet<String>(this.normalizePaths(this.expectedOutputFiles())));
    }

    protected String displayLines(List<String> warnings) {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        for (String warning : warnings) {
            sb.append('-').append(warning).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private List<CompilerConfiguration> getCompilerConfigurations() throws Exception {
        String sourceDir = "src/test-input/src/main";
        List filenames = FileUtils.getFileNames((File)new File(sourceDir), (String)"**/*.java", null, (boolean)false, (boolean)true);
        Collections.sort(filenames);
        ArrayList<CompilerConfiguration> compilerConfigurations = new ArrayList<CompilerConfiguration>();
        int index = 0;
        for (String filename : filenames) {
            String source;
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            compilerConfig.setDebug(this.compilerDebug);
            compilerConfig.setShowDeprecation(this.compilerDeprecationWarnings);
            compilerConfig.setClasspathEntries(this.getClasspath());
            compilerConfig.addSourceLocation(sourceDir);
            compilerConfig.setOutputLocation("target/" + this.getRoleHint() + "/classes-" + index);
            FileUtils.deleteDirectory((String)compilerConfig.getOutputLocation());
            compilerConfig.addInclude(filename);
            compilerConfig.setForceJavacCompilerUse(this.forceJavacCompilerUse);
            this.configureCompilerConfig(compilerConfig);
            String target = this.getTargetVersion();
            if (StringUtils.isNotEmpty((String)target)) {
                compilerConfig.setTargetVersion(target);
            }
            if (StringUtils.isNotEmpty((String)(source = this.getSourceVersion()))) {
                compilerConfig.setSourceVersion(source);
            }
            compilerConfigurations.add(compilerConfig);
            ++index;
        }
        return compilerConfigurations;
    }

    public String getTargetVersion() {
        return null;
    }

    public String getSourceVersion() {
        return null;
    }

    private List<String> normalizePaths(Collection<String> relativePaths) {
        ArrayList<String> normalizedPaths = new ArrayList<String>();
        for (String relativePath : relativePaths) {
            normalizedPaths.add(relativePath.replace(File.separatorChar, '/'));
        }
        return normalizedPaths;
    }

    protected int compilerErrorCount(List<CompilerMessage> messages) {
        int count = 0;
        for (CompilerMessage message : messages) {
            count += message.isError() ? 1 : 0;
        }
        return count;
    }

    protected int expectedErrors() {
        return 1;
    }

    protected int expectedWarnings() {
        return 0;
    }

    protected Collection<String> expectedOutputFiles() {
        return Collections.emptyList();
    }

    protected File getLocalArtifactPath(String groupId, String artifactId, String version, String type) {
        VersionRange versionRange = VersionRange.createFromVersion((String)version);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, "compile", type, null, (ArtifactHandler)new DefaultArtifactHandler(type));
        return this.getLocalArtifactPath((Artifact)artifact);
    }

    protected String getJavaVersion() {
        int lastDot;
        String javaVersion;
        String realJavaVersion = javaVersion = System.getProperty("java.version");
        int dotIdx = javaVersion.indexOf(".");
        if (dotIdx > -1 && (dotIdx = javaVersion.indexOf(".", (lastDot = dotIdx) + 1)) > lastDot) {
            javaVersion = javaVersion.substring(0, dotIdx);
        }
        System.out.println("java.version is: " + realJavaVersion + "\ntrimmed java version is: " + javaVersion + "\ncomparison: \"1.5\".compareTo( \"" + javaVersion + "\" ) == " + "1.5".compareTo(javaVersion) + "\n");
        return javaVersion;
    }

    protected File getLocalArtifactPath(Artifact artifact) {
        return new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
    }
}

