/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.InProcessCompiler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Named(value="javac")
@Singleton
public class JavacCompiler
extends AbstractCompiler {
    private static final Object LOCK = new Object();
    private static final String JAVAC_CLASSNAME = "com.sun.tools.javac.Main";
    private volatile Class<?> javacClass;
    private final Deque<Class<?>> javacClasses = new ConcurrentLinkedDeque();
    private static final Pattern JAVA_MAJOR_AND_MINOR_VERSION_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");
    private static final Map<String, String> VERSION_PER_EXECUTABLE = new ConcurrentHashMap<String, String>();
    @Inject
    private InProcessCompiler inProcessCompiler;
    private static final Pattern STACK_TRACE_FIRST_LINE = Pattern.compile("^(?:[\\w+.-]+\\.)[\\w$]*?(?:Exception|Error|Throwable|Failure|Result|Abort|Fault|ThreadDeath|Overflow|Warning|NotSupported|NotFound|BadArgs|BadClassFile|Illegal|Invalid|Unexpected|Unchecked|Unmatched\\w+).*$");
    private static final Pattern STACK_TRACE_OTHER_LINE = Pattern.compile("^(?:Caused by:\\s.*|\\s*at .*|\\s*\\.\\.\\.\\s\\d+\\smore)$");

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public String getCompilerId() {
        return "javac";
    }

    private String getInProcessJavacVersion() throws CompilerException {
        return System.getProperty("java.version");
    }

    private String getOutOfProcessJavacVersion(String executable) throws CompilerException {
        String version = VERSION_PER_EXECUTABLE.get(executable);
        if (version == null) {
            Commandline cli = new Commandline();
            cli.setExecutable(executable);
            cli.addArguments(new String[]{"-version"});
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            try {
                int exitCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)out);
                if (exitCode != 0) {
                    throw new CompilerException("Could not retrieve version from " + executable + ". Exit code " + exitCode + ", Output: " + out.getOutput());
                }
            }
            catch (CommandLineException e) {
                throw new CompilerException("Error while executing the external compiler " + executable, (Throwable)e);
            }
            version = JavacCompiler.extractMajorAndMinorVersion(out.getOutput());
            VERSION_PER_EXECUTABLE.put(executable, version);
        }
        return version;
    }

    static String extractMajorAndMinorVersion(String text) {
        Matcher matcher = JAVA_MAJOR_AND_MINOR_VERSION_PATTERN.matcher(text);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Could not extract version from \"" + text + "\"");
        }
        return matcher.group();
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String javacVersion;
        String executable;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        this.logCompiling(sourceFiles, config);
        if (config.isFork()) {
            executable = this.getJavacExecutable(config);
            javacVersion = this.getOutOfProcessJavacVersion(executable);
        } else {
            javacVersion = this.getInProcessJavacVersion();
            executable = null;
        }
        String[] args = JavacCompiler.buildCompilerArguments(config, sourceFiles, javacVersion);
        CompilerResult result = config.isFork() ? this.compileOutOfProcess(config, executable, args) : (JavacCompiler.hasJavaxToolProvider() && !config.isForceJavacCompilerUse() ? this.inProcessCompiler().compileInProcess(args, config, sourceFiles) : this.compileInProcess(args, config));
        return result;
    }

    protected InProcessCompiler inProcessCompiler() {
        return this.inProcessCompiler;
    }

    protected static boolean hasJavaxToolProvider() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.tools.ToolProvider");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        String javacVersion;
        if (config.isFork()) {
            String executable = this.getJavacExecutable(config);
            javacVersion = this.getOutOfProcessJavacVersion(executable);
        } else {
            javacVersion = this.getInProcessJavacVersion();
        }
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles((CompilerConfiguration)config), javacVersion);
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles, String javacVersion) {
        List sourceLocations;
        List modulepathEntries;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(JavacCompiler.getPathString((List)classpathEntries));
        }
        if ((modulepathEntries = config.getModulepathEntries()) != null && !modulepathEntries.isEmpty()) {
            args.add("--module-path");
            args.add(JavacCompiler.getPathString((List)modulepathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args.add("-sourcepath");
            args.add(JavacCompiler.getPathString((List)sourceLocations));
        }
        if (!JavacCompiler.hasJavaxToolProvider() || config.isForceJavacCompilerUse() || config.isFork()) {
            args.addAll(Arrays.asList(sourceFiles));
        }
        if (JavaVersion.JAVA_1_6.isOlderOrEqualTo(javacVersion)) {
            if (config.getGeneratedSourcesDirectory() != null) {
                config.getGeneratedSourcesDirectory().mkdirs();
                args.add("-s");
                args.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
            }
            if (config.getProc() != null) {
                args.add("-proc:" + config.getProc());
            }
            if (config.getAnnotationProcessors() != null) {
                args.add("-processor");
                String[] procs = config.getAnnotationProcessors();
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < procs.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs[i]);
                }
                args.add(buffer.toString());
            }
            if (config.getProcessorPathEntries() != null && !config.getProcessorPathEntries().isEmpty()) {
                args.add("-processorpath");
                args.add(JavacCompiler.getPathString((List)config.getProcessorPathEntries()));
            }
            if (config.getProcessorModulePathEntries() != null && !config.getProcessorModulePathEntries().isEmpty()) {
                args.add("--processor-module-path");
                args.add(JavacCompiler.getPathString((List)config.getProcessorModulePathEntries()));
            }
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty((String)config.getDebugLevel())) {
                args.add("-g:" + config.getDebugLevel());
            } else {
                args.add("-g");
            }
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (JavaVersion.JAVA_1_8.isOlderOrEqualTo(javacVersion) && config.isParameters()) {
            args.add("-parameters");
        }
        if (config.isEnablePreview()) {
            args.add("--enable-preview");
        }
        if (config.getImplicitOption() != null) {
            args.add("-implicit:" + config.getImplicitOption());
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        } else {
            String warnings = config.getWarnings();
            if (config.isShowLint()) {
                if (config.isShowWarnings() && StringUtils.isNotEmpty((String)warnings)) {
                    args.add("-Xlint:" + warnings);
                } else {
                    args.add("-Xlint");
                }
            }
        }
        if (config.isFailOnWarning()) {
            args.add("-Werror");
        }
        if (JavaVersion.JAVA_9.isOlderOrEqualTo(javacVersion) && !StringUtils.isEmpty((String)config.getReleaseVersion())) {
            args.add("--release");
            args.add(config.getReleaseVersion());
        } else {
            if (StringUtils.isEmpty((String)config.getTargetVersion())) {
                args.add("-target");
                args.add("1.1");
            } else {
                args.add("-target");
                args.add(config.getTargetVersion());
            }
            if (JavaVersion.JAVA_1_4.isOlderOrEqualTo(javacVersion) && StringUtils.isEmpty((String)config.getSourceVersion())) {
                args.add("-source");
                args.add("1.3");
            } else if (JavaVersion.JAVA_1_4.isOlderOrEqualTo(javacVersion)) {
                args.add("-source");
                args.add(config.getSourceVersion());
            }
        }
        if (JavaVersion.JAVA_1_4.isOlderOrEqualTo(javacVersion) && !StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!StringUtils.isEmpty((String)config.getModuleVersion())) {
            args.add("--module-version");
            args.add(config.getModuleVersion());
        }
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.startsWith("-J")) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        if (!config.isFork() && !args.contains("-XDuseUnsharedTable=false")) {
            args.add("-XDuseUnsharedTable=true");
        }
        return args.toArray(new String[0]);
    }

    protected CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        List<CompilerMessage> messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block12: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                File argumentsFile = this.createFileWithArguments(args, config.getBuildDirectory().getAbsolutePath());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
                for (String key : config.getCustomCompilerArgumentsAsMap().keySet()) {
                    if (!StringUtils.isNotEmpty((String)key) || !key.startsWith("-J")) continue;
                    cli.addArguments(new String[]{key});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            if (this.getLog().isDebugEnabled()) {
                String debugFileName = StringUtils.isEmpty((String)config.getDebugFileName()) ? "javac" : config.getDebugFileName();
                File commandLineFile = new File(config.getBuildDirectory(), StringUtils.trim((String)debugFileName) + "." + (Os.isFamily((String)"windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily((String)"windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (!this.getLog().isWarnEnabled()) break block12;
                    this.getLog().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
                }
            }
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)out);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Compiler output:{}{}", (Object)EOL, (Object)out.getOutput());
            }
            messages = JavacCompiler.parseModernStream(returnCode, new BufferedReader(new StringReader(out.getOutput())));
        }
        catch (IOException | CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", e);
        }
        boolean success = returnCode == 0;
        return new CompilerResult(success, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompilerResult compileInProcess(String[] args, CompilerConfiguration config) throws CompilerException {
        Class<?> javacClass = this.getJavacClass(config);
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(javacClass.getClassLoader());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("ttcl changed run compileInProcessWithProperClassloader");
        }
        try {
            CompilerResult compilerResult = this.compileInProcessWithProperClassloader(javacClass, args);
            return compilerResult;
        }
        finally {
            this.releaseJavaccClass(javacClass, config);
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected CompilerResult compileInProcessWithProperClassloader(Class<?> javacClass, String[] args) throws CompilerException {
        return this.compileInProcess0(javacClass, args);
    }

    private CompilerResult compileInProcess0(Class<?> javacClass, String[] args) throws CompilerException {
        List<CompilerMessage> messages;
        Integer ok;
        StringWriter out = new StringWriter();
        try {
            Method compile = javacClass.getMethod("compile", String[].class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args, new PrintWriter(out));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Compiler output:{}{}", (Object)EOL, (Object)out.toString());
            }
            messages = JavacCompiler.parseModernStream(ok, new BufferedReader(new StringReader(out.toString())));
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        boolean success = ok == 0;
        return new CompilerResult(success, messages);
    }

    static List<CompilerMessage> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        String line;
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        StringBuilder buffer = new StringBuilder();
        boolean hasPointer = false;
        int stackTraceLineCount = 0;
        while ((line = input.readLine()) != null) {
            stackTraceLineCount = stackTraceLineCount == 0 && STACK_TRACE_FIRST_LINE.matcher(line).matches() || STACK_TRACE_OTHER_LINE.matcher(line).matches() ? ++stackTraceLineCount : 0;
            if (!line.startsWith(" ") && hasPointer) {
                errors.add(JavacCompiler.parseModernError(exitCode, buffer.toString()));
                buffer = new StringBuilder();
                hasPointer = false;
            }
            if (buffer.length() == 0) {
                if (JavacCompiler.isError(line)) {
                    errors.add(new CompilerMessage(line, CompilerMessage.Kind.ERROR));
                } else if (JavacCompiler.isWarning(line)) {
                    errors.add(new CompilerMessage(line, CompilerMessage.Kind.WARNING));
                } else if (!JavacCompiler.isNote(line)) {
                    if (JavacCompiler.isMisc(line)) {
                        errors.add(new CompilerMessage(line, CompilerMessage.Kind.OTHER));
                    } else {
                        buffer.append(line).append(EOL);
                    }
                }
            } else {
                buffer.append(line).append(EOL);
            }
            if (!line.endsWith("^")) continue;
            hasPointer = true;
        }
        String bufferContent = buffer.toString();
        if (bufferContent.isEmpty()) {
            return errors;
        }
        String cleanedUpMessage = JavacCompiler.getJavacGenericError(bufferContent);
        if (cleanedUpMessage != null || (cleanedUpMessage = JavacCompiler.getBootLayerInitError(bufferContent)) != null || (cleanedUpMessage = JavacCompiler.getVMInitError(bufferContent)) != null || (cleanedUpMessage = JavacCompiler.getFileABugError(bufferContent)) != null || (cleanedUpMessage = JavacCompiler.getAnnotationProcessingError(bufferContent)) != null || (cleanedUpMessage = JavacCompiler.getSystemOutOfResourcesError(bufferContent)) != null || (cleanedUpMessage = JavacCompiler.getIOError(bufferContent)) != null || (cleanedUpMessage = JavacCompiler.getPluginError(bufferContent)) != null) {
            errors.add(new CompilerMessage(cleanedUpMessage, CompilerMessage.Kind.ERROR));
        } else if (hasPointer) {
            errors.add(JavacCompiler.parseModernError(exitCode, bufferContent));
        } else if (stackTraceLineCount > 0) {
            int firstLine;
            String[] lines = bufferContent.split("\\R");
            int linesTotal = lines.length;
            buffer = new StringBuilder();
            for (int i = firstLine = linesTotal - stackTraceLineCount; i < linesTotal; ++i) {
                buffer.append(lines[i]).append(EOL);
            }
            errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
        }
        return errors;
    }

    private static boolean isMisc(String message) {
        return JavacCompiler.startsWithPrefix(message, Messages.MISC_PREFIXES);
    }

    private static boolean isNote(String message) {
        return JavacCompiler.startsWithPrefix(message, Messages.NOTE_PREFIXES);
    }

    private static boolean isWarning(String message) {
        return JavacCompiler.startsWithPrefix(message, Messages.WARNING_PREFIXES);
    }

    private static boolean isError(String message) {
        return JavacCompiler.startsWithPrefix(message, Messages.ERROR_PREFIXES);
    }

    private static String getJavacGenericError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.JAVAC_GENERIC_ERROR_PREFIXES);
    }

    private static String getVMInitError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.VM_INIT_ERROR_HEADERS);
    }

    private static String getBootLayerInitError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.BOOT_LAYER_INIT_ERROR_HEADERS);
    }

    private static String getFileABugError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.FILE_A_BUG_ERROR_HEADERS);
    }

    private static String getAnnotationProcessingError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.ANNOTATION_PROCESSING_ERROR_HEADERS);
    }

    private static String getSystemOutOfResourcesError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.SYSTEM_OUT_OF_RESOURCES_ERROR_HEADERS);
    }

    private static String getIOError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.IO_ERROR_HEADERS);
    }

    private static String getPluginError(String message) {
        return JavacCompiler.getTextStartingWithPrefix(message, Messages.PLUGIN_ERROR_HEADERS);
    }

    private static boolean startsWithPrefix(String text, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static String getTextStartingWithPrefix(String text, String[] prefixes) {
        text = text.replaceAll("\\R", "\n");
        for (String prefix : prefixes) {
            CharSequence[] prefixParts = prefix.split("\\{\\d+\\}");
            for (int i = 0; i < prefixParts.length; ++i) {
                prefixParts[i] = "\\Q" + (String)prefixParts[i] + "\\E";
            }
            prefix = String.join((CharSequence)".*?", prefixParts);
            Matcher matcher = Pattern.compile("(?s).*(" + prefix + ".*)").matcher(text);
            if (!matcher.matches()) continue;
            return matcher.replaceFirst("$1").replaceAll("\n", EOL);
        }
        return null;
    }

    static CompilerMessage parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        CompilerMessage.Kind messageKind = exitCode == 0 ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            StringBuilder file = null;
            String currentToken = null;
            do {
                if (currentToken != null) {
                    if (file == null) {
                        file = new StringBuilder(currentToken);
                    } else {
                        file.append(':').append(currentToken);
                    }
                }
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String lineIndicator = currentToken;
            int startOfFileName = Objects.requireNonNull(file).toString().lastIndexOf(93);
            if (startOfFileName > -1) {
                file = new StringBuilder(file.substring(startOfFileName + 1 + EOL.length()));
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuilder msgBuffer = new StringBuilder();
            String msg = tokens.nextToken(EOL).substring(2);
            String prefix = JavacCompiler.getErrorPrefix(msg);
            if (prefix != null) {
                messageKind = CompilerMessage.Kind.ERROR;
                msg = msg.substring(prefix.length());
            } else {
                prefix = JavacCompiler.getWarningPrefix(msg);
                if (prefix != null) {
                    messageKind = CompilerMessage.Kind.WARNING;
                    msg = msg.substring(prefix.length());
                }
            }
            msgBuffer.append(msg).append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = null;
            do {
                String msgLine = tokens.nextToken(EOL);
                if (pointer != null) {
                    msgBuffer.append(msgLine);
                    msgBuffer.append(EOL);
                    continue;
                }
                if (msgLine.endsWith("^")) {
                    pointer = msgLine;
                    continue;
                }
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                context = msgLine;
            } while (tokens.hasMoreTokens());
            msgBuffer.append(EOL);
            String message = msgBuffer.toString();
            int startcolumn = Objects.requireNonNull(pointer).indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = Objects.requireNonNull(context).length();
            }
            return new CompilerMessage(file.toString(), messageKind, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerMessage("no more tokens - could not parse error message: " + error, messageKind);
        }
        catch (Exception e) {
            return new CompilerMessage("could not parse error message: " + error, messageKind);
        }
    }

    private static String getMessagePrefix(String message, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!message.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    private static String getWarningPrefix(String message) {
        return JavacCompiler.getMessagePrefix(message, Messages.WARNING_PREFIXES);
    }

    private static String getErrorPrefix(String message) {
        return JavacCompiler.getMessagePrefix(message, Messages.ERROR_PREFIXES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        try (PrintWriter writer = null;){
            File tempFile;
            if (this.getLog().isDebugEnabled()) {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (String arg : args) {
                String argValue = arg.replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
    }

    protected String getJavacExecutable(CompilerConfiguration config) {
        String executable = config.getExecutable();
        if (StringUtils.isEmpty((String)executable)) {
            try {
                executable = JavacCompiler.getJavacExecutable();
            }
            catch (IOException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn("Unable to autodetect 'javac' path, using 'javac' from the environment.");
                }
                executable = "javac";
            }
        }
        return executable;
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }

    private void releaseJavaccClass(Class<?> javaccClass, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            this.javacClasses.add(javaccClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getJavacClass(CompilerConfiguration compilerConfiguration) throws CompilerException {
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return this.createJavacClass();
            }
            case ReuseCreated: {
                Class<?> c = this.javacClasses.poll();
                if (c == null) {
                    c = this.createJavacClass();
                }
                return c;
            }
        }
        Class<?> c = this.javacClass;
        if (c == null) {
            JavacCompiler javacCompiler = this;
            synchronized (javacCompiler) {
                c = this.javacClass;
                if (c == null) {
                    this.javacClass = c = this.createJavacClass();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> createJavacClass() throws CompilerException {
        try {
            return JavacCompiler.class.getClassLoader().loadClass(JAVAC_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new CompilerException("tools.jar not found: " + toolsJar);
            }
            URL[] originalUrls = ((URLClassLoader)JavacCompiler.class.getClassLoader()).getURLs();
            URL[] urls = new URL[originalUrls.length + 1];
            urls[0] = toolsJar.toURI().toURL();
            System.arraycopy(originalUrls, 0, urls, 1, originalUrls.length);
            URLClassLoader javacClassLoader = new URLClassLoader(urls);
            Thread thread = Thread.currentThread();
            ClassLoader contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(javacClassLoader);
            try {
                Class<?> clazz = javacClassLoader.loadClass(JAVAC_CLASSNAME);
                thread.setContextClassLoader(contextClassLoader);
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    thread.setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.", (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new CompilerException("Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.", (Throwable)ex);
                }
            }
        }
    }

    static enum JavaVersion {
        JAVA_1_3_OR_OLDER("1.3", "1.2", "1.1", "1.0"),
        JAVA_1_4("1.4"),
        JAVA_1_5("1.5"),
        JAVA_1_6("1.6"),
        JAVA_1_7("1.7"),
        JAVA_1_8("1.8"),
        JAVA_9("9");

        final Set<String> versionPrefixes;

        private JavaVersion(String ... versionPrefixes) {
            this.versionPrefixes = new HashSet<String>(Arrays.asList(versionPrefixes));
        }

        boolean isOlderOrEqualTo(String version) {
            JavaVersion[] allJavaVersionPrefixes = JavaVersion.values();
            for (int n = this.ordinal() - 1; n > -1; --n) {
                if (!allJavaVersionPrefixes[n].versionPrefixes.stream().anyMatch(version::startsWith)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class Messages {
        protected static final String[] ERROR_PREFIXES = new String[]{"error: ", "\u30a8\u30e9\u30fc: ", "\u9519\u8bef: ", "Fehler: "};
        protected static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a: ", "Warnung: "};
        protected static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u30ce\u30fc\u30c8: ", "\u6ce8: ", "Hinweis: "};
        protected static final String[] MISC_PREFIXES = new String[]{"["};
        protected static final String[] JAVAC_GENERIC_ERROR_PREFIXES = new String[]{"javac:"};
        protected static final String[] VM_INIT_ERROR_HEADERS = new String[]{"Error occurred during initialization of VM"};
        protected static final String[] BOOT_LAYER_INIT_ERROR_HEADERS = new String[]{"Error occurred during initialization of boot layer"};
        protected static final String[] ANNOTATION_PROCESSING_ERROR_HEADERS = new String[]{"\n\nAn annotation processor threw an uncaught exception.\nConsult the following stack trace for details.\n\n", "\n\n\u6ce8\u91c8\u51e6\u7406\u3067\u6355\u6349\u3055\u308c\u306a\u3044\u4f8b\u5916\u304c\u30b9\u30ed\u30fc\u3055\u308c\u307e\u3057\u305f\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30fb\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\n", "\n\n\u6279\u6ce8\u5904\u7406\u7a0b\u5e8f\u629b\u51fa\u672a\u6355\u83b7\u7684\u5f02\u5e38\u9519\u8bef\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n\n", "\n\nAn annotation processor threw an uncaught exception.\nConsult the following stack trace for details.\n\n", "\n\n\u6ce8\u91c8\u51e6\u7406\u3067\u6355\u6349\u3055\u308c\u306a\u3044\u4f8b\u5916\u304c\u30b9\u30ed\u30fc\u3055\u308c\u307e\u3057\u305f\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\n", "\n\n\u6279\u6ce8\u5904\u7406\u7a0b\u5e8f\u629b\u51fa\u672a\u6355\u83b7\u7684\u5f02\u5e38\u9519\u8bef\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n\n", "\n\nEin Annotationsprozessor hat eine nicht abgefangene Ausnahme ausgel\u00f6st.\nDetails finden Sie im folgenden Stacktrace.\n\n"};
        protected static final String[] FILE_A_BUG_ERROR_HEADERS = new String[]{"An exception has occurred in the compiler ({0}). Please file a bug at the Java Developer Connection (http://java.sun.com/webapps/bugreport)  after checking the Bug Parade for duplicates. Include your program and the following diagnostic in your report.  Thank you.\n", "\u30b3\u30f3\u30d1\u30a4\u30e9\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f({0})\u3002Bug Parade\u3067\u91cd\u8907\u304c\u306a\u3044\u304b\u3092\u3054\u78ba\u8a8d\u306e\u3046\u3048\u3001Java Developer Connection (http://java.sun.com/webapps/bugreport)\u3067bug\u306e\u767b\u9332\u3092\u304a\u9858\u3044\u3044\u305f\u3057\u307e\u3059\u3002\u30ec\u30dd\u30fc\u30c8\u306b\u306f\u3001\u305d\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3068\u4e0b\u8a18\u306e\u8a3a\u65ad\u5185\u5bb9\u3092\u542b\u3081\u3066\u304f\u3060\u3055\u3044\u3002\u3054\u5354\u529b\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\u3002\n", "\u7f16\u8bd1\u5668 ({0}) \u4e2d\u51fa\u73b0\u5f02\u5e38\u9519\u8bef\u3002 \u5982\u679c\u5728 Bug Parade \u4e2d\u6ca1\u6709\u627e\u5230\u8be5\u9519\u8bef, \u8bf7\u5728 Java Developer Connection (http://java.sun.com/webapps/bugreport) \u4e2d\u5efa\u7acb Bug\u3002\u8bf7\u5728\u62a5\u544a\u4e2d\u9644\u4e0a\u60a8\u7684\u7a0b\u5e8f\u548c\u4ee5\u4e0b\u8bca\u65ad\u4fe1\u606f\u3002\u8c22\u8c22\u3002\n", "An exception has occurred in the compiler ({0}). Please file a bug against the Java compiler via the Java bug reporting page (http://bugreport.java.com) after checking the Bug Database (http://bugs.java.com) for duplicates. Include your program and the following diagnostic in your report. Thank you.", "\u30b3\u30f3\u30d1\u30a4\u30e9\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f({0})\u3002Bug Database (http://bugs.java.com)\u3067\u91cd\u8907\u304c\u306a\u3044\u304b\u3092\u3054\u78ba\u8a8d\u306e\u3046\u3048\u3001Java bug\u30ec\u30dd\u30fc\u30c8\u30fb\u30da\u30fc\u30b8(http://bugreport.java.com)\u3067Java\u30b3\u30f3\u30d1\u30a4\u30e9\u306b\u5bfe\u3059\u308bbug\u306e\u767b\u9332\u3092\u304a\u9858\u3044\u3044\u305f\u3057\u307e\u3059\u3002\u30ec\u30dd\u30fc\u30c8\u306b\u306f\u3001\u305d\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3068\u4e0b\u8a18\u306e\u8a3a\u65ad\u5185\u5bb9\u3092\u542b\u3081\u3066\u304f\u3060\u3055\u3044\u3002\u3054\u5354\u529b\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\u3002", "\u7f16\u8bd1\u5668 ({0}) \u4e2d\u51fa\u73b0\u5f02\u5e38\u9519\u8bef\u3002\u5982\u679c\u5728 Bug Database (http://bugs.java.com) \u4e2d\u6ca1\u6709\u627e\u5230\u8be5\u9519\u8bef, \u8bf7\u901a\u8fc7 Java Bug \u62a5\u544a\u9875 (http://bugreport.java.com) \u5efa\u7acb\u8be5 Java \u7f16\u8bd1\u5668 Bug\u3002\u8bf7\u5728\u62a5\u544a\u4e2d\u9644\u4e0a\u60a8\u7684\u7a0b\u5e8f\u548c\u4ee5\u4e0b\u8bca\u65ad\u4fe1\u606f\u3002\u8c22\u8c22\u3002", "An exception has occurred in the compiler ({0}). Please file a bug against the Java compiler via the Java bug reporting page (https://bugreport.java.com) after checking the Bug Database (https://bugs.java.com) for duplicates. Include your program, the following diagnostic, and the parameters passed to the Java compiler in your report. Thank you.\n", "\u30b3\u30f3\u30d1\u30a4\u30e9\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f({0})\u3002\u30d0\u30b0\u30fb\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9(https://bugs.java.com)\u3067\u91cd\u8907\u304c\u306a\u3044\u304b\u3092\u3054\u78ba\u8a8d\u306e\u3046\u3048\u3001Java\u306e\u30d0\u30b0\u30fb\u30ec\u30dd\u30fc\u30c8\u30fb\u30da\u30fc\u30b8(https://bugreport.java.com)\u304b\u3089\u3001Java\u30b3\u30f3\u30d1\u30a4\u30e9\u306b\u5bfe\u3059\u308b\u30d0\u30b0\u306e\u767b\u9332\u3092\u304a\u9858\u3044\u3044\u305f\u3057\u307e\u3059\u3002\u30ec\u30dd\u30fc\u30c8\u306b\u306f\u3001\u8a72\u5f53\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3001\u6b21\u306e\u8a3a\u65ad\u5185\u5bb9\u3001\u304a\u3088\u3073Java\u30b3\u30f3\u30d1\u30a4\u30e9\u306b\u6e21\u3055\u308c\u305f\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u3054\u5165\u529b\u304f\u3060\u3055\u3044\u3002\u3054\u5354\u529b\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\u3002\n", "\u7f16\u8bd1\u5668 ({0}) \u4e2d\u51fa\u73b0\u5f02\u5e38\u9519\u8bef\u3002\u5982\u679c\u5728 Bug Database (https://bugs.java.com) \u4e2d\u6ca1\u6709\u627e\u5230\u6709\u5173\u8be5\u9519\u8bef\u7684 Java \u7f16\u8bd1\u5668 Bug\uff0c\u8bf7\u901a\u8fc7 Java Bug \u62a5\u544a\u9875 (https://bugreport.java.com) \u63d0\u4ea4 Java \u7f16\u8bd1\u5668 Bug\u3002\u8bf7\u5728\u62a5\u544a\u4e2d\u9644\u4e0a\u60a8\u7684\u7a0b\u5e8f\u3001\u4ee5\u4e0b\u8bca\u65ad\u4fe1\u606f\u4ee5\u53ca\u4f20\u9012\u5230 Java \u7f16\u8bd1\u5668\u7684\u53c2\u6570\u3002\u8c22\u8c22\u3002\n", "Im Compiler ({0}) ist eine Ausnahme aufgetreten. Erstellen Sie auf der Java-Seite zum Melden von Bugs (https://bugreport.java.com) einen Bugbericht, nachdem Sie die Bugdatenbank (https://bugs.java.com) auf Duplikate gepr\u00fcft haben. Geben Sie in Ihrem Bericht Ihr Programm, die folgende Diagnose und die Parameter an, die Sie dem Java-Compiler \u00fcbergeben haben. Vielen Dank.\n"};
        protected static final String[] SYSTEM_OUT_OF_RESOURCES_ERROR_HEADERS = new String[]{"\n\nThe system is out of resources.\nConsult the following stack trace for details.\n", "\n\n\u30b7\u30b9\u30c6\u30e0\u30fb\u30ea\u30bd\u30fc\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30fb\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", "\n\n\u7cfb\u7edf\u8d44\u6e90\u4e0d\u8db3\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n", "\n\nThe system is out of resources.\nConsult the following stack trace for details.\n", "\n\n\u30b7\u30b9\u30c6\u30e0\u30fb\u30ea\u30bd\u30fc\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", "\n\n\u7cfb\u7edf\u8d44\u6e90\u4e0d\u8db3\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n", "\n\nDas System hat keine Ressourcen mehr.\nDetails finden Sie im folgenden Stacktrace.\n"};
        protected static final String[] IO_ERROR_HEADERS = new String[]{"\n\nAn input/output error occurred.\nConsult the following stack trace for details.\n", "\n\n\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30fb\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", "\n\n\u53d1\u751f\u8f93\u5165/\u8f93\u51fa\u9519\u8bef\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n", "\n\nAn input/output error occurred.\nConsult the following stack trace for details.\n", "\n\n\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", "\n\n\u53d1\u751f\u8f93\u5165/\u8f93\u51fa\u9519\u8bef\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n", "\n\nEin Eingabe-/Ausgabefehler ist aufgetreten.\nDetails finden Sie im folgenden Stacktrace.\n"};
        protected static final String[] PLUGIN_ERROR_HEADERS = new String[]{"\n\nA plugin threw an uncaught exception.\nConsult the following stack trace for details.\n", "\n\n\u30d7\u30e9\u30b0\u30a4\u30f3\u3067\u6355\u6349\u3055\u308c\u306a\u3044\u4f8b\u5916\u304c\u30b9\u30ed\u30fc\u3055\u308c\u307e\u3057\u305f\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30fb\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", "\n\n\u63d2\u4ef6\u629b\u51fa\u672a\u6355\u83b7\u7684\u5f02\u5e38\u9519\u8bef\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n", "\n\nA plugin threw an uncaught exception.\nConsult the following stack trace for details.\n", "\n\n\u30d7\u30e9\u30b0\u30a4\u30f3\u3067\u6355\u6349\u3055\u308c\u306a\u3044\u4f8b\u5916\u304c\u30b9\u30ed\u30fc\u3055\u308c\u307e\u3057\u305f\u3002\n\u8a73\u7d30\u306f\u6b21\u306e\u30b9\u30bf\u30c3\u30af\u30fb\u30c8\u30ec\u30fc\u30b9\u3067\u8abf\u67fb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", "\n\n\u63d2\u4ef6\u629b\u51fa\u672a\u6355\u83b7\u7684\u5f02\u5e38\u9519\u8bef\u3002\n\u6709\u5173\u8be6\u7ec6\u4fe1\u606f, \u8bf7\u53c2\u9605\u4ee5\u4e0b\u5806\u6808\u8ddf\u8e2a\u3002\n", "\n\nEin Plug-in hat eine nicht abgefangene Ausnahme ausgel\u00f6st.\nDetails finden Sie im folgenden Stacktrace.\n"};

        protected Messages() {
        }
    }
}

