/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.eclipse.EcjFailureException;
import org.codehaus.plexus.compiler.eclipse.EcjResponseParser;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;

@Component(role=Compiler.class, hint="eclipse")
public class EclipseJavaCompiler
extends AbstractCompiler {
    boolean errorsAsWarnings = false;

    public EclipseJavaCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-noExit");
        if (config.isDebug()) {
            args.add("-preserveAllLocals");
            args.add("-g:lines,vars,source");
        } else {
            args.add("-g:lines,source");
        }
        String releaseVersion = this.decodeVersion(config.getReleaseVersion());
        if (releaseVersion != null) {
            args.add("--release");
            args.add(releaseVersion);
        } else {
            String targetVersion;
            String sourceVersion = this.decodeVersion(config.getSourceVersion());
            if (sourceVersion != null) {
                args.add("-source");
                args.add(sourceVersion);
            }
            if ((targetVersion = this.decodeVersion(config.getTargetVersion())) != null) {
                args.add("-target");
                args.add(targetVersion);
            }
        }
        if (StringUtils.isNotEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!config.isShowWarnings()) {
            args.add("-warn:none");
        } else {
            StringBuilder warns;
            String warnings = config.getWarnings();
            StringBuilder stringBuilder = warns = StringUtils.isEmpty((String)warnings) ? new StringBuilder() : new StringBuilder(warnings).append(',');
            if (config.isShowDeprecation()) {
                EclipseJavaCompiler.append(warns, "+deprecation");
            } else {
                EclipseJavaCompiler.append(warns, "-deprecation");
            }
            args.add("-warn:" + warns);
        }
        if (config.isParameters()) {
            args.add("-parameters");
        }
        if (config.isFailOnWarning()) {
            args.add("-failOnWarning");
        }
        this.errorsAsWarnings = EclipseJavaCompiler.processCustomArguments(config, args);
        args.add("-d");
        args.add(config.getOutputLocation());
        ArrayList<String> extraSourceDirs = new ArrayList<String>();
        if (!this.isPreJava1_6(config)) {
            File generatedSourcesDir = config.getGeneratedSourcesDirectory();
            if (generatedSourcesDir != null) {
                generatedSourcesDir.mkdirs();
                extraSourceDirs.add(generatedSourcesDir.getAbsolutePath());
                args.add("-s");
                args.add(generatedSourcesDir.getAbsolutePath());
            }
            String[] annotationProcessors = config.getAnnotationProcessors();
            Iterator processorPathEntries = config.getProcessorPathEntries();
            List processorModulePathEntries = config.getProcessorModulePathEntries();
            if (annotationProcessors != null && annotationProcessors.length > 0 || processorPathEntries != null && processorPathEntries.size() > 0 || processorModulePathEntries != null && processorModulePathEntries.size() > 0) {
                if (annotationProcessors != null && annotationProcessors.length > 0) {
                    args.add("-processor");
                    StringBuilder sb = new StringBuilder();
                    for (String ap : annotationProcessors) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(ap);
                    }
                    args.add(sb.toString());
                }
                if (processorPathEntries != null && processorPathEntries.size() > 0) {
                    args.add("-processorpath");
                    args.add(EclipseJavaCompiler.getPathString((List)((Object)processorPathEntries)));
                }
                if (processorModulePathEntries != null && processorModulePathEntries.size() > 0) {
                    args.add("-processorpath");
                    args.add(EclipseJavaCompiler.getPathString((List)processorModulePathEntries));
                }
                if (config.getProc() != null) {
                    args.add("-proc:" + config.getProc());
                }
            }
        }
        ArrayList<String> classpathEntries = new ArrayList<String>(config.getClasspathEntries());
        classpathEntries.add(config.getOutputLocation());
        args.add("-classpath");
        args.add(EclipseJavaCompiler.getPathString(classpathEntries));
        ArrayList<String> allSources = new ArrayList<String>();
        for (String source : config.getSourceLocations()) {
            File srcFile = new File(source);
            if (!srcFile.exists()) continue;
            Set ss = EclipseJavaCompiler.getSourceFilesForSourceRoot((CompilerConfiguration)config, (String)source);
            allSources.addAll(ss);
        }
        for (String extraSrcDir : extraSourceDirs) {
            File extraDir = new File(extraSrcDir);
            if (!extraDir.isDirectory()) continue;
            this.addExtraSources(extraDir, allSources);
        }
        List<Object> messageList = new ArrayList();
        if (allSources.isEmpty()) {
            return new CompilerResult(true, messageList);
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter devNull = new PrintWriter(sw);
            JavaCompiler compiler = this.getEcj();
            boolean success = false;
            if (compiler != null) {
                this.getLogger().debug("Using JSR-199 EclipseCompiler");
                if (!EclipseJavaCompiler.haveSourceOrReleaseArgument(args)) {
                    this.getLogger().debug("ecj: no source level nor release specified, defaulting to Java 1.3");
                    args.add("-source");
                    args.add("1.3");
                }
                String encoding = null;
                Iterator allArgs = args.iterator();
                while (encoding == null && allArgs.hasNext()) {
                    String string = (String)allArgs.next();
                    if (!"-encoding".equals(string) || !allArgs.hasNext()) continue;
                    encoding = (String)allArgs.next();
                }
                final Locale locale = Locale.getDefault();
                final ArrayList messages = messageList;
                DiagnosticListener<JavaFileObject> messageCollector = new DiagnosticListener<JavaFileObject>(){

                    @Override
                    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                        String fileName = "Unknown source";
                        try {
                            JavaFileObject file = diagnostic.getSource();
                            if (file != null) {
                                fileName = file.getName();
                            }
                        }
                        catch (NullPointerException file) {
                            // empty catch block
                        }
                        long startColumn = diagnostic.getColumnNumber();
                        long endColumn = startColumn + (diagnostic.getEndPosition() - diagnostic.getStartPosition());
                        CompilerMessage message = new CompilerMessage(fileName, EclipseJavaCompiler.this.convert(diagnostic.getKind()), (int)diagnostic.getLineNumber(), (int)startColumn, (int)diagnostic.getLineNumber(), (int)endColumn, diagnostic.getMessage(locale));
                        messages.add(message);
                    }
                };
                Charset charset = null;
                if (encoding != null) {
                    encoding = encoding.trim();
                    try {
                        charset = Charset.forName(encoding);
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                        this.getLogger().warn("ecj: invalid or unsupported character set '" + encoding + "', using default");
                    }
                }
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("ecj: using character set " + charset.displayName());
                    this.getLogger().debug("ecj command line: " + args);
                    this.getLogger().debug("ecj input source files: " + allSources);
                }
                try (StandardJavaFileManager manager = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)messageCollector, locale, charset);){
                    Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromStrings(allSources);
                    success = Boolean.TRUE.equals(compiler.getTask(devNull, manager, (DiagnosticListener<? super JavaFileObject>)messageCollector, args, null, units).call());
                }
                catch (RuntimeException e) {
                    throw new EcjFailureException(e.getLocalizedMessage());
                }
                this.getLogger().debug(sw.toString());
            } else {
                File errorF = null;
                try {
                    errorF = File.createTempFile("ecjerr-", ".xml");
                    this.getLogger().debug("Using legacy BatchCompiler; error file " + errorF);
                    args.add("-log");
                    args.add(errorF.toString());
                    args.addAll(allSources);
                    this.getLogger().debug("ecj command line: " + args);
                    success = BatchCompiler.compile((String[])args.toArray(new String[args.size()]), (PrintWriter)devNull, (PrintWriter)devNull, (CompilationProgress)new CompilationProgress(){

                        public void begin(int i) {
                        }

                        public void done() {
                        }

                        public boolean isCanceled() {
                            return false;
                        }

                        public void setTaskName(String s) {
                        }

                        public void worked(int i, int i1) {
                        }
                    });
                    this.getLogger().debug(sw.toString());
                    if (errorF.length() < 80L) {
                        throw new EcjFailureException(sw.toString());
                    }
                    messageList = new EcjResponseParser().parse(errorF, this.errorsAsWarnings);
                }
                finally {
                    if (null != errorF) {
                        try {
                            errorF.delete();
                        }
                        catch (Exception allArgs) {}
                    }
                }
            }
            boolean hasError = false;
            for (CompilerMessage compilerMessage : messageList) {
                if (!compilerMessage.isError()) continue;
                hasError = true;
                break;
            }
            if (!(hasError || success || this.errorsAsWarnings)) {
                CompilerMessage.Kind kind = this.errorsAsWarnings ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR;
                CompilerMessage compilerMessage = new CompilerMessage("[ecj] The compiler reported an error but has not written it to its logging", kind);
                messageList.add(compilerMessage);
                hasError = true;
                String stdout = this.getLastLines(sw.toString(), 5);
                if (stdout.length() > 0) {
                    CompilerMessage compilerMessage2 = new CompilerMessage("[ecj] The following line(s) might indicate the issue:\n" + stdout, kind);
                    messageList.add(compilerMessage2);
                }
            }
            return new CompilerResult(!hasError || this.errorsAsWarnings, messageList);
        }
        catch (EcjFailureException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    static boolean processCustomArguments(CompilerConfiguration config, List<String> args) {
        boolean result = false;
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            File propFile;
            String opt = (String)entry.getKey();
            String optionValue = (String)entry.getValue();
            if (opt.equals("errorsAsWarnings") || opt.equals("-errorsAsWarnings")) {
                result = true;
                continue;
            }
            if (!(!opt.equals("-properties") || null == optionValue || (propFile = new File(optionValue)).exists() && propFile.isFile())) {
                throw new IllegalArgumentException("Properties file specified by -properties " + propFile + " does not exist");
            }
            if (opt.equals("-proceedOnError")) {
                args.add("-proceedOnError:Fatal");
                continue;
            }
            if (null == optionValue) {
                args.add(opt);
                continue;
            }
            if (!opt.startsWith("-")) {
                opt = "-" + opt;
            }
            args.add(opt);
            args.add(optionValue);
        }
        return result;
    }

    private static boolean haveSourceOrReleaseArgument(List<String> args) {
        Iterator<String> allArgs = args.iterator();
        while (allArgs.hasNext()) {
            String option = allArgs.next();
            if (!"-source".equals(option) && !"--release".equals(option) || !allArgs.hasNext()) continue;
            return true;
        }
        return false;
    }

    private JavaCompiler getEcj() {
        ServiceLoader<JavaCompiler> javaCompilerLoader = ServiceLoader.load(JavaCompiler.class, BatchCompiler.class.getClassLoader());
        Class<?> c = null;
        try {
            c = Class.forName("org.eclipse.jdt.internal.compiler.tool.EclipseCompiler", false, BatchCompiler.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c != null) {
            for (JavaCompiler javaCompiler : javaCompilerLoader) {
                if (!c.isInstance(javaCompiler)) continue;
                return javaCompiler;
            }
        }
        this.getLogger().debug("Cannot find org.eclipse.jdt.internal.compiler.tool.EclipseCompiler");
        return null;
    }

    private void addExtraSources(File dir, List<String> allSources) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir.getAbsolutePath());
        scanner.setIncludes(new String[]{"**/*.java"});
        scanner.scan();
        for (String file : scanner.getIncludedFiles()) {
            allSources.add(new File(dir, file).getAbsolutePath());
        }
    }

    private CompilerMessage.Kind convert(Diagnostic.Kind kind) {
        if (kind == null) {
            return CompilerMessage.Kind.OTHER;
        }
        switch (kind) {
            case ERROR: {
                return this.errorsAsWarnings ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR;
            }
            case WARNING: {
                return CompilerMessage.Kind.WARNING;
            }
            case MANDATORY_WARNING: {
                return CompilerMessage.Kind.MANDATORY_WARNING;
            }
            case NOTE: {
                return CompilerMessage.Kind.NOTE;
            }
        }
        return CompilerMessage.Kind.OTHER;
    }

    private String getLastLines(String text, int lines) {
        ArrayList<String> lineList = new ArrayList<String>();
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        int index = text.length();
        while (index > 0) {
            int before = text.lastIndexOf(10, index - 1);
            if (before + 1 < index) {
                lineList.add(text.substring(before + 1, index));
                if (--lines <= 0) break;
            }
            index = before;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = lineList.size() - 1; i >= 0; --i) {
            String s = (String)lineList.get(i);
            sb.append(s);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private static void append(StringBuilder warns, String s) {
        if (warns.length() > 0) {
            warns.append(',');
        }
        warns.append(s);
    }

    private boolean isPreJava1_6(CompilerConfiguration config) {
        String s = config.getSourceVersion();
        if (s == null) {
            return true;
        }
        return s.startsWith("1.5") || s.startsWith("1.4") || s.startsWith("1.3") || s.startsWith("1.2") || s.startsWith("1.1") || s.startsWith("1.0");
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    public boolean supportsIncrementalCompilation() {
        return true;
    }

    private String decodeVersion(String versionSpec) {
        if (StringUtils.isEmpty((String)versionSpec)) {
            return null;
        }
        if (versionSpec.equals("1.9")) {
            this.getLogger().warn("Version 9 should be specified as 9, not 1.9");
            return "9";
        }
        return versionSpec;
    }
}

