/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.csharp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtil {
    public static void extract(Path destDir, File jarFile) throws IOException {
        Path toPath = destDir.normalize();
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                Path f = destDir.resolve(file.getName()).normalize();
                if (!f.startsWith(toPath)) {
                    throw new IOException("Bad zip entry");
                }
                if (file.isDirectory()) {
                    Files.createDirectories(f, new FileAttribute[0]);
                    continue;
                }
                Path parent = f.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                InputStream is = jar.getInputStream(file);
                try {
                    OutputStream fos = Files.newOutputStream(f, new OpenOption[0]);
                    try {
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }
}

