/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.cdc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.cdc.ComponentDescriptorWriteException;
import org.codehaus.plexus.cdc.ComponentDescriptorWriter;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.cdc.ComponentDescriptor;
import org.codehaus.plexus.component.repository.cdc.ComponentRequirement;
import org.codehaus.plexus.component.repository.cdc.ComponentRequirementList;
import org.codehaus.plexus.component.repository.cdc.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class DefaultComponentDescriptorWriter
implements ComponentDescriptorWriter {
    private static final String LS = System.getProperty("line.separator");

    public void writeDescriptorSet(Writer writer, ComponentSetDescriptor componentSetDescriptor, boolean containerDescriptor) throws ComponentDescriptorWriteException, IOException {
        try {
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(writer);
            w.startElement(containerDescriptor ? "plexus" : "component-set");
            this.writeComponents((XMLWriter)w, componentSetDescriptor.getComponents());
            this.writeDependencies((XMLWriter)w, componentSetDescriptor.getDependencies());
            w.endElement();
            writer.write(LS);
            writer.flush();
        }
        catch (PlexusConfigurationException e) {
            throw new ComponentDescriptorWriteException("Internal error while writing out the configuration", e);
        }
    }

    private void writeComponents(XMLWriter w, List componentDescriptors) throws ComponentDescriptorWriteException, PlexusConfigurationException {
        if (componentDescriptors == null) {
            return;
        }
        w.startElement("components");
        Iterator i = componentDescriptors.iterator();
        while (i.hasNext()) {
            w.startElement("component");
            ComponentDescriptor cd = (ComponentDescriptor)i.next();
            this.element(w, "role", cd.getRole());
            this.element(w, "role-hint", cd.getRoleHint());
            this.element(w, "implementation", cd.getImplementation());
            this.element(w, "version", cd.getVersion());
            this.element(w, "component-type", cd.getComponentType());
            this.element(w, "instantiation-strategy", cd.getInstantiationStrategy());
            this.element(w, "lifecycle-handler", cd.getLifecycleHandler());
            this.element(w, "component-profile", cd.getComponentProfile());
            this.element(w, "component-composer", cd.getComponentComposer());
            this.element(w, "component-configurator", cd.getComponentConfigurator());
            this.element(w, "component-factory", cd.getComponentFactory());
            this.element(w, "description", cd.getDescription());
            this.element(w, "alias", cd.getAlias());
            this.element(w, "isolated-realm", Boolean.toString(cd.isIsolatedRealm()));
            this.writeRequirements(w, cd.getRequirements());
            this.writeConfiguration(w, cd.getConfiguration());
            w.endElement();
        }
        w.endElement();
    }

    public void writeDependencies(XMLWriter w, List deps) {
        if (deps == null || deps.size() == 0) {
            return;
        }
        w.startElement("dependencies");
        for (int i = 0; i < deps.size(); ++i) {
            this.writeDependencyElement((ComponentDependency)deps.get(i), w);
        }
        w.endElement();
    }

    private void writeDependencyElement(ComponentDependency dependency, XMLWriter w) {
        w.startElement("dependency");
        String groupId = dependency.getGroupId();
        this.element(w, "groupId", groupId);
        String artifactId = dependency.getArtifactId();
        this.element(w, "artifactId", artifactId);
        String type = dependency.getType();
        if (type != null) {
            this.element(w, "type", type);
        }
        String version = dependency.getVersion();
        this.element(w, "version", version);
        w.endElement();
    }

    private void writeRequirements(XMLWriter w, List requirements) {
        if (requirements == null || requirements.size() == 0) {
            return;
        }
        w.startElement("requirements");
        Iterator j = requirements.iterator();
        while (j.hasNext()) {
            ComponentRequirement cr = (ComponentRequirement)j.next();
            w.startElement("requirement");
            this.element(w, "role", cr.getRole());
            if (cr instanceof ComponentRequirementList) {
                List hints = ((ComponentRequirementList)cr).getRoleHints();
                if (hints != null) {
                    w.startElement("role-hints");
                    Iterator k = hints.iterator();
                    while (k.hasNext()) {
                        String roleHint = (String)k.next();
                        w.startElement("role-hint");
                        w.writeText(roleHint);
                        w.endElement();
                    }
                    w.endElement();
                }
            } else {
                this.element(w, "role-hint", cr.getRoleHint());
            }
            this.element(w, "field-name", cr.getFieldName());
            w.endElement();
        }
        w.endElement();
    }

    private void writeConfiguration(XMLWriter w, PlexusConfiguration configuration) throws ComponentDescriptorWriteException, PlexusConfigurationException {
        if (configuration == null || configuration.getChildCount() == 0) {
            return;
        }
        if (!configuration.getName().equals("configuration")) {
            throw new ComponentDescriptorWriteException("The root node of the configuration must be 'configuration'.");
        }
        this.writePlexusConfiguration(w, configuration);
    }

    private void writePlexusConfiguration(XMLWriter xmlWriter, PlexusConfiguration c) throws PlexusConfigurationException {
        if (c.getAttributeNames().length == 0 && c.getChildCount() == 0 && c.getValue() == null) {
            return;
        }
        xmlWriter.startElement(c.getName());
        String[] attributeNames = c.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            xmlWriter.addAttribute(attributeName, c.getAttribute(attributeName));
        }
        PlexusConfiguration[] children = c.getChildren();
        if (children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.writePlexusConfiguration(xmlWriter, children[i]);
            }
        } else {
            String value = c.getValue();
            if (value != null) {
                xmlWriter.writeText(value);
            }
        }
        xmlWriter.endElement();
    }

    private void element(XMLWriter w, String name, String value) {
        if (value == null) {
            return;
        }
        w.startElement(name);
        w.writeText(value);
        w.endElement();
    }
}

