/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver {
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";

    public AbstractZipUnArchiver() {
    }

    public AbstractZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }

    @Override
    protected void execute() throws ArchiverException {
        this.getLogger().debug("Expanding: " + this.getSourceFile() + " into " + this.getDestDirectory());
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.getSourceFile(), this.encoding);
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zf, ze);
                if (!this.isSelected(ze.getName(), fileInfo)) continue;
                InputStream in = zf.getInputStream(ze);
                this.extractFileIfIncluded(this.getSourceFile(), this.getDestDirectory(), in, ze.getName(), new Date(ze.getTime()), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zf, ze));
                IOUtil.close((InputStream)in);
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zf);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zf);
    }

    private String resolveSymlink(ZipFile zf, ZipArchiveEntry ze) throws IOException {
        if (ze.isUnixSymlink()) {
            return zf.getUnixSymlink(ze);
        }
        return null;
    }

    private void extractFileIfIncluded(File sourceFile, File destDirectory, InputStream inputStream, String name, Date time, boolean isDirectory, Integer mode, String symlinkDestination) throws IOException, ArchiverException {
        try {
            if (this.include(inputStream, name)) {
                this.extractFile(sourceFile, destDirectory, inputStream, name, time, isDirectory, mode, symlinkDestination);
            }
        }
        catch (ArchiveFilterException e) {
            throw new ArchiverException("Error verifying '" + name + "' for inclusion: " + e.getMessage(), e);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.getSourceFile(), this.encoding);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zipFile, ze);
                if (!this.isSelected(ze.getName(), fileInfo) || !ze.getName().startsWith(path)) continue;
                InputStream inputStream = zipFile.getInputStream(ze);
                this.extractFileIfIncluded(this.getSourceFile(), outputDirectory, inputStream, ze.getName(), new Date(ze.getTime()), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zipFile, ze));
                IOUtil.close((InputStream)inputStream);
            }
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFile);
    }

    private static class ZipEntryFileInfo
    implements PlexusIoResource {
        private final ZipFile zipFile;
        private final ZipArchiveEntry zipEntry;

        ZipEntryFileInfo(ZipFile zipFile, ZipArchiveEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public boolean isFile() {
            return !this.zipEntry.isDirectory() && !this.zipEntry.isUnixSymlink();
        }

        public boolean isSymbolicLink() {
            return this.zipEntry.isUnixSymlink();
        }

        public InputStream getContents() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        public long getLastModified() {
            long l = this.zipEntry.getTime();
            return l == 0L ? 0L : l;
        }

        public long getSize() {
            long l = this.zipEntry.getSize();
            return l == -1L ? -1L : l;
        }

        public URL getURL() throws IOException {
            return null;
        }

        public boolean isExisting() {
            return true;
        }
    }
}

