/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.resources.PlexusIoVirtualSymlinkResource;
import org.codehaus.plexus.archiver.util.ArchiverAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class ArchiveEntry {
    public static final String ROLE = ArchiveEntry.class.getName();
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int SYMLINK = 3;
    @Nonnull
    private PlexusIoResource resource;
    private final String name;
    private final int type;
    private final int mode;
    private PlexusIoResourceAttributes attributes;

    private ArchiveEntry(String name, @Nonnull PlexusIoResource resource, int type, int mode) {
        this.name = name;
        this.resource = resource;
        this.attributes = resource instanceof PlexusIoResourceWithAttributes ? ((PlexusIoResourceWithAttributes)resource).getAttributes() : null;
        this.type = type;
        int permissions = mode;
        if (mode == -1 && this.attributes == null) {
            int n = resource.isFile() ? 33188 : (permissions = resource.isSymbolicLink() ? 41471 : 16877);
        }
        this.mode = permissions == -1 ? permissions : permissions & 0xFFF | (type == 1 ? 32768 : (type == 3 ? 40960 : 16384));
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        if (this.resource instanceof PlexusIoFileResource) {
            return ((PlexusIoFileResource)this.resource).getFile();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getContents();
    }

    public int getType() {
        return this.type;
    }

    public int getMode() {
        if (this.mode != -1) {
            return this.mode;
        }
        if (this.attributes != null && this.attributes.getOctalMode() > -1) {
            return this.attributes.getOctalMode();
        }
        return (this.type == 1 ? 33188 : (this.type == 3 ? 41471 : 16877)) & 0xFFF | (this.type == 1 ? 32768 : (this.type == 3 ? 40960 : 16384));
    }

    public static ArchiveEntry createFileEntry(String target, PlexusIoResource resource, int permissions) throws ArchiverException {
        if (resource.isDirectory()) {
            throw new ArchiverException("Not a file: " + resource.getName());
        }
        int type = resource.isSymbolicLink() ? 3 : 1;
        return new ArchiveEntry(target, resource, type, permissions);
    }

    public static ArchiveEntry createFileEntry(String target, File file, int permissions) throws ArchiverException {
        PlexusIoResourceAttributes attrs;
        if (!file.isFile()) {
            throw new ArchiverException("Not a file: " + file);
        }
        try {
            attrs = PlexusIoResourceAttributeUtils.getFileAttributes((File)file);
        }
        catch (IOException e) {
            throw new ArchiverException("Failed to read filesystem attributes for: " + file, e);
        }
        PlexusIoFileResource res = PlexusIoFileResource.justAFile((File)file, (PlexusIoResourceAttributes)attrs);
        return new ArchiveEntry(target, (PlexusIoResource)res, 1, permissions);
    }

    public static ArchiveEntry createDirectoryEntry(String target, @Nonnull PlexusIoResource resource, int permissions) throws ArchiverException {
        if (!resource.isDirectory()) {
            throw new ArchiverException("Not a directory: " + resource.getName());
        }
        int type = resource.isSymbolicLink() ? 3 : 2;
        return new ArchiveEntry(target, resource, type, permissions);
    }

    public static ArchiveEntry createDirectoryEntry(String target, File file, int permissions) throws ArchiverException {
        if (!file.isDirectory()) {
            throw new ArchiverException("Not a directory: " + file);
        }
        PlexusIoFileResource res = new PlexusIoFileResource(file, ArchiverAttributeUtils.getFileAttributes(file));
        return new ArchiveEntry(target, (PlexusIoResource)res, 2, permissions);
    }

    public static ArchiveEntry createEntry(String target, File file, int filePerm, int dirPerm) throws ArchiverException {
        if (file.isDirectory()) {
            return ArchiveEntry.createDirectoryEntry(target, file, dirPerm);
        }
        if (file.isFile()) {
            return ArchiveEntry.createFileEntry(target, file, filePerm);
        }
        throw new ArchiverException("Neither a file nor a directory: " + file);
    }

    public static ArchiveEntry createSymlinkEntry(String symlinkName, int permissions, String symlinkDestination) {
        File symlinkFile = new File(symlinkName);
        ArchiveEntry archiveEntry = new ArchiveEntry(symlinkName, (PlexusIoResource)new PlexusIoVirtualSymlinkResource(symlinkFile, symlinkDestination), 3, permissions);
        return archiveEntry;
    }

    public PlexusIoResourceAttributes getResourceAttributes() {
        return this.attributes;
    }

    public void setResourceAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    @Nonnull
    public PlexusIoResource getResource() {
        return this.resource;
    }
}

