/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.commonscompress.archivers.zip;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.FileBasedScatterGatherBackingStore;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterGatherBackingStore;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.StreamCompressor;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveEntry;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveOutputStream;
import org.codehaus.plexus.archiver.commonscompress.utils.BoundedInputStream;

public class ScatterZipOutputStream
implements Closeable {
    private final Queue<CompressedEntry> items = new ConcurrentLinkedQueue<CompressedEntry>();
    private final ScatterGatherBackingStore backingStore;
    private final StreamCompressor streamCompressor;

    public ScatterZipOutputStream(ScatterGatherBackingStore backingStore, StreamCompressor streamCompressor) {
        this.backingStore = backingStore;
        this.streamCompressor = streamCompressor;
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStream payload, int method) throws IOException {
        this.streamCompressor.deflate(payload, method);
        this.items.add(new CompressedEntry(zipArchiveEntry, this.streamCompressor.getCrc32(), this.streamCompressor.getBytesWrittenForLastEntry(), method, this.streamCompressor.getBytesRead()));
    }

    public void writeTo(ZipArchiveOutputStream target) throws IOException {
        this.backingStore.closeForWriting();
        InputStream data = this.backingStore.getInputStream();
        for (CompressedEntry compressedEntry : this.items) {
            BoundedInputStream rawStream = new BoundedInputStream(data, compressedEntry.compressedSize);
            target.addRawArchiveEntry(compressedEntry.transferToArchiveEntry(), rawStream);
            rawStream.close();
        }
        data.close();
    }

    public void close() throws IOException {
        this.backingStore.close();
    }

    public static ScatterZipOutputStream fileBased(File file) throws FileNotFoundException {
        return ScatterZipOutputStream.fileBased(file, -1);
    }

    public static ScatterZipOutputStream fileBased(File file, int compressionLevel) throws FileNotFoundException {
        FileBasedScatterGatherBackingStore bs = new FileBasedScatterGatherBackingStore(file);
        StreamCompressor sc = StreamCompressor.create(compressionLevel, bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    private static class CompressedEntry {
        final ZipArchiveEntry entry;
        final long crc;
        final long compressedSize;
        final int method;
        final long size;

        public CompressedEntry(ZipArchiveEntry entry, long crc, long compressedSize, int method, long size) {
            this.entry = entry;
            this.crc = crc;
            this.compressedSize = compressedSize;
            this.method = method;
            this.size = size;
        }

        public ZipArchiveEntry transferToArchiveEntry() {
            this.entry.setCompressedSize(this.compressedSize);
            this.entry.setSize(this.size);
            this.entry.setCrc(this.crc);
            this.entry.setMethod(this.method);
            return this.entry;
        }
    }
}

