package org.codehaus.plexus.archiver;

/**
 *
 * Copyright 2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.File;
import java.io.IOException;

/**
 * @version $Revision: 2436 $ $Date: 2005-09-01 10:20:41 -0700 (Thu, 01 Sep 2005) $
 */
public interface UnArchiver
{
    String ROLE = UnArchiver.class.getName();

    void extract()
        throws ArchiverException, IOException;

    File getDestDirectory();

    void setDestDirectory( File destDirectory );

    File getDestFile();

    void setDestFile( File destFile );

    File getSourceFile();

    void setSourceFile( File sourceFile );

    /**
     * Should we overwrite files in dest, even if they are newer than
     * the corresponding entries in the archive?
     */
    void setOverwrite( boolean b );
}
