/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.xml.AbstractXmlMojo;
import org.codehaus.mojo.xml.Resolver;
import org.codehaus.mojo.xml.validation.ValidationSet;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ValidateMojo
extends AbstractXmlMojo {
    private ValidationSet[] validationSets;

    private Schema getSchema(Resolver pResolver, ValidationSet pValidationSet) throws MojoExecutionException {
        String publicId = pValidationSet.getPublicId();
        String systemId = pValidationSet.getSystemId();
        if ((publicId == null || "".equals(publicId)) && (systemId == null || "".equals(systemId))) {
            return null;
        }
        this.getLog().debug((CharSequence)("Loading schema with public Id " + publicId + ", system Id " + systemId));
        InputSource inputSource = null;
        if (pResolver != null) {
            try {
                inputSource = pResolver.resolveEntity(publicId, systemId);
            }
            catch (SAXException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (inputSource == null) {
            inputSource = new InputSource();
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
        }
        SAXSource saxSource = new SAXSource(inputSource);
        String schemaLanguage = pValidationSet.getSchemaLanguage();
        if (schemaLanguage == null || "".equals(schemaLanguage)) {
            schemaLanguage = "http://www.w3.org/2001/XMLSchema";
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
            if (pResolver != null) {
                schemaFactory.setResourceResolver(pResolver);
            }
            return schemaFactory.newSchema(saxSource);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Failed to load schema with public ID " + publicId + ", system ID " + systemId + ": " + e.getMessage(), (Exception)e);
        }
    }

    private void validate(Resolver pResolver, ValidationSet pValidationSet, Schema pSchema, File pFile) throws MojoExecutionException {
        try {
            if (pSchema == null) {
                this.getLog().debug((CharSequence)("Parsing " + pFile.getPath()));
                this.parse(pResolver, pValidationSet, pFile);
            } else {
                this.getLog().debug((CharSequence)("Validating " + pFile.getPath()));
                Validator validator = pSchema.newValidator();
                if (pResolver != null) {
                    validator.setResourceResolver(pResolver);
                }
                validator.validate(new StreamSource(pFile));
            }
        }
        catch (SAXParseException e) {
            String location;
            String publicId = e.getPublicId();
            String systemId = e.getSystemId();
            int lineNum = e.getLineNumber();
            int colNum = e.getColumnNumber();
            if (publicId == null && systemId == null && lineNum == -1 && colNum == -1) {
                location = "";
            } else {
                StringBuffer loc = new StringBuffer();
                String sep = "";
                if (publicId != null) {
                    loc.append("Public ID ");
                    loc.append(publicId);
                    sep = ", ";
                }
                if (systemId != null) {
                    loc.append(sep);
                    loc.append(systemId);
                    sep = ", ";
                }
                if (lineNum != -1) {
                    loc.append(sep);
                    loc.append("line ");
                    loc.append(lineNum);
                    sep = ", ";
                }
                if (colNum != -1) {
                    loc.append(sep);
                    loc.append(" column ");
                    loc.append(colNum);
                    sep = ", ";
                }
                location = loc.toString();
            }
            String msg = "While parsing " + pFile.getPath() + ("".equals(location) ? "" : ", at " + location) + ": " + e.getMessage();
            throw new MojoExecutionException(msg, (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("While parsing " + pFile + ": " + e.getMessage(), e);
        }
    }

    private SAXParserFactory newSAXParserFactory(ValidationSet pValidationSet) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(pValidationSet.isValidating());
        if (pValidationSet.isValidating()) {
            try {
                spf.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXException e) {
            }
            catch (ParserConfigurationException e) {}
        } else {
            try {
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException e) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        spf.setNamespaceAware(true);
        return spf;
    }

    private void parse(Resolver pResolver, ValidationSet pValidationSet, File pFile) throws IOException, SAXException, ParserConfigurationException {
        XMLReader xr = this.newSAXParserFactory(pValidationSet).newSAXParser().getXMLReader();
        if (pResolver != null) {
            xr.setEntityResolver(pResolver);
        }
        xr.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException pException) throws SAXException {
                throw pException;
            }

            public void fatalError(SAXParseException pException) throws SAXException {
                throw pException;
            }

            public void warning(SAXParseException pException) throws SAXException {
                throw pException;
            }
        });
        xr.parse(pFile.toURI().toURL().toExternalForm());
    }

    private void validate(Resolver pResolver, ValidationSet pValidationSet) throws MojoExecutionException, MojoFailureException {
        Schema schema = this.getSchema(pResolver, pValidationSet);
        File[] files = this.getFiles(pValidationSet.getDir(), pValidationSet.getIncludes(), this.getExcludes(pValidationSet.getExcludes(), pValidationSet.isSkipDefaultExcludes()));
        if (files.length == 0) {
            this.getLog().info((CharSequence)("No matching files found for ValidationSet with public ID " + pValidationSet.getPublicId() + ", system ID " + pValidationSet.getSystemId() + "."));
        }
        for (int i = 0; i < files.length; ++i) {
            this.validate(pResolver, pValidationSet, schema, files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.validationSets == null || this.validationSets.length == 0) {
            throw new MojoFailureException("No ValidationSets configured.");
        }
        Object oldProxySettings = this.activateProxy();
        try {
            Resolver resolver = this.getResolver();
            for (int i = 0; i < this.validationSets.length; ++i) {
                ValidationSet validationSet = this.validationSets[i];
                resolver.setValidating(validationSet.isValidating());
                this.validate(resolver, validationSet);
            }
        }
        finally {
            this.passivateProxy(oldProxySettings);
        }
    }
}

