/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class WebtestEmbeddingUtil {
    static void copyWebTestResources(File targetFolder) throws IOException {
        String resourcesPrefix = "com/canoo/webtest/resources/";
        URL webtestXmlUrl = WebtestEmbeddingUtil.class.getClassLoader().getResource("com/canoo/webtest/resources/webtest.xml");
        if (webtestXmlUrl == null) {
            throw new IllegalStateException("Can't find resource com/canoo/webtest/resources/webtest.xml");
        }
        if (webtestXmlUrl.toString().startsWith("jar:file")) {
            String jarFileName = webtestXmlUrl.toString().replaceFirst("^jar:file:([^\\!]*).*$", "$1");
            JarFile jarFile = new JarFile(jarFileName);
            String urlPrefix = StringUtils.removeEnd((String)webtestXmlUrl.toString(), (String)"webtest.xml");
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().startsWith("com/canoo/webtest/resources/")) continue;
                String relativeName = StringUtils.removeStart((String)jarEntry.getName(), (String)"com/canoo/webtest/resources/");
                URL url = new URL(urlPrefix + relativeName);
                File targetFile = new File(targetFolder, relativeName);
                FileUtils.forceMkdir((File)targetFile.getParentFile());
                FileUtils.copyURLToFile((URL)url, (File)targetFile);
            }
        } else if (webtestXmlUrl.toString().startsWith("file:")) {
            File webtestXmlFile = FileUtils.toFile((URL)webtestXmlUrl);
            File resourceFolder = webtestXmlFile.getParentFile();
            FileUtils.copyDirectory((File)resourceFolder, (File)targetFolder);
        } else {
            throw new IllegalStateException("Resource com/canoo/webtest/resources/webtest.xml is not in a jar file: " + webtestXmlUrl);
        }
    }
}

