/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.task;

import com.canoo.ant.filter.ITableFilter;
import com.canoo.ant.table.APropertyTable;
import com.canoo.ant.table.ExcelPropertyTable;
import com.canoo.ant.table.IPropertyTable;
import com.canoo.ant.table.TableFactory;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;

public class PropertyTableTask
extends Task
implements TaskContainer {
    private static final Logger LOG = Logger.getLogger(PropertyTableTask.class);
    private List fTasks = new LinkedList();
    private Properties fProps = new Properties();
    private String fName;
    private String fValue;
    private boolean fFailASAP = false;
    private File fTableContainer;
    private boolean replaceProperties;

    public void setReplaceProperties(boolean replaceProperties) {
        this.replaceProperties = replaceProperties;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setTableclass(String tableClass) {
        this.fProps.setProperty("tableClass", tableClass);
    }

    public void setFilterclass(String filterClass) {
        this.fProps.setProperty("filterClass", filterClass);
    }

    public void setTable(String table) {
        this.fProps.setProperty("foreignTable", table);
    }

    public void setTableContainer(File container) throws IOException {
        this.fTableContainer = container;
    }

    public void setContainer(File container) throws IOException {
        this.setTableContainer(container);
    }

    public void setFailASAP(boolean newValue) {
        this.fFailASAP = newValue;
    }

    public void addTask(Task task) {
        this.fTasks.add(task);
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        ITableFilter filter;
        IPropertyTable table;
        try {
            table = TableFactory.createTable(this.fProps, ExcelPropertyTable.class.getName());
            filter = TableFactory.createFilter(this.fProps);
        }
        catch (Exception e) {
            throw new BuildException("cannot create container", (Throwable)e, this.getLocation());
        }
        TableFactory.initOrDefault(table, filter, this.fProps, this.fTableContainer, this.fName);
        List propertiesList = table.getPropertiesList(this.fValue, null);
        LOG.debug((Object)("propertiesList.size() = " + propertiesList.size()));
        if (propertiesList.isEmpty()) {
            LOG.warn((Object)("no match found in table " + table.getClass().getName() + " with filter " + table.getFilter().getClass().getName() + " and settings " + this.fProps.toString() + " raw data:" + ((APropertyTable)table).getRawTable()));
        }
        int nbFailures = 0;
        int nbRuns = 0;
        Iterator eachPropSet = propertiesList.iterator();
        while (eachPropSet.hasNext()) {
            ++nbRuns;
            Properties propSet = (Properties)eachPropSet.next();
            for (String string : propSet.keySet()) {
                String value = propSet.getProperty(string);
                if (this.replaceProperties) {
                    value = this.getProject().replaceProperties(value);
                }
                LOG.debug((Object)("setting key/value " + string + "/" + value));
                this.getProject().setInheritedProperty(string, value);
            }
            for (Task task : this.fTasks) {
                if (task instanceof UnknownElement) {
                    UnknownElement unknownElement = this.copy((UnknownElement)task);
                }
                try {
                    void var9_14;
                    var9_14.perform();
                }
                catch (BuildException e) {
                    if (this.fFailASAP) {
                        throw e;
                    }
                    ++nbFailures;
                }
            }
        }
        if (nbFailures > 0) {
            throw new BuildException("" + nbFailures + "/" + nbRuns + " executions of nested tasks failed");
        }
    }

    private UnknownElement copy(UnknownElement ue) {
        UnknownElement ret = new UnknownElement(ue.getTag());
        ret.setNamespace(ue.getNamespace());
        ret.setProject(this.getProject());
        ret.setQName(ue.getQName());
        ret.setTaskType(ue.getTaskType());
        ret.setTaskName(ue.getTaskName());
        ret.setLocation(ue.getLocation());
        if (this.getOwningTarget() == null) {
            Target t = new Target();
            t.setProject(this.getProject());
            ret.setOwningTarget(t);
        } else {
            ret.setOwningTarget(this.getOwningTarget());
        }
        RuntimeConfigurable rc = new RuntimeConfigurable((Object)ret, ue.getTaskName());
        rc.setPolyType(ue.getWrapper().getPolyType());
        Hashtable m = ue.getWrapper().getAttributeMap();
        for (Map.Entry entry : m.entrySet()) {
            rc.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        rc.addText(ue.getWrapper().getText().toString());
        Enumeration e = ue.getWrapper().getChildren();
        while (e.hasMoreElements()) {
            RuntimeConfigurable r = (RuntimeConfigurable)e.nextElement();
            UnknownElement unknownElement = (UnknownElement)r.getProxy();
            String tag = unknownElement.getTaskType();
            if (tag != null) {
                tag = tag.toLowerCase(Locale.US);
            }
            UnknownElement child = this.copy(unknownElement);
            rc.addChild(child.getWrapper());
            ret.addChild(child);
        }
        return ret;
    }
}

