/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.MissingResourceException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jnlp.sample.servlet.JnlpDownloadServlet;

public abstract class DownloadResponse {
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String HEADER_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String JNLP_ERROR_MIMETYPE = "application/x-java-jnlp-error";
    public static final int STS_00_OK = 0;
    public static final int ERR_10_NO_RESOURCE = 10;
    public static final int ERR_11_NO_VERSION = 11;
    public static final int ERR_20_UNSUP_OS = 20;
    public static final int ERR_21_UNSUP_ARCH = 21;
    public static final int ERR_22_UNSUP_LOCALE = 22;
    public static final int ERR_23_UNSUP_JRE = 23;
    public static final int ERR_99_UNKNOWN = 99;
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String GZIP_ENCODING = "gzip";
    public static final String PACK200_GZIP_ENCODING = "pack200-gzip";

    public String toString() {
        return this.getClass().getName();
    }

    abstract void sendRespond(HttpServletResponse var1) throws IOException;

    static DownloadResponse getNotFoundResponse() {
        return new NotFoundResponse();
    }

    static DownloadResponse getNoContentResponse() {
        return new NotFoundResponse();
    }

    static DownloadResponse getJnlpErrorResponse(int jnlpErrorCode) {
        return new JnlpErrorResponse(jnlpErrorCode);
    }

    static DownloadResponse getNotModifiedResponse() {
        return new NotModifiedResponse();
    }

    static DownloadResponse getHeadRequestResponse(String mimeType, String versionId, long lastModified, int contentLength) {
        return new HeadRequestResponse(mimeType, versionId, lastModified, contentLength);
    }

    static DownloadResponse getFileDownloadResponse(byte[] content, String mimeType, long timestamp, String versionId) {
        return new ByteArrayFileDownloadResponse(content, mimeType, versionId, timestamp);
    }

    static DownloadResponse getFileDownloadResponse(URL resource, String mimeType, long timestamp, String versionId) {
        return new ResourceFileDownloadResponse(resource, mimeType, versionId, timestamp);
    }

    static DownloadResponse getFileDownloadResponse(File file, String mimeType, long timestamp, String versionId) {
        return new DiskFileDownloadResponse(file, mimeType, versionId, timestamp);
    }

    private static class DiskFileDownloadResponse
    extends FileDownloadResponse {
        private File _file;

        DiskFileDownloadResponse(File file, String mimeType, String versionId, long lastModified) {
            super(mimeType, versionId, lastModified, file.getName());
            this._file = file;
        }

        @Override
        int getContentLength() throws IOException {
            return (int)this._file.length();
        }

        @Override
        InputStream getContent() throws IOException {
            return new BufferedInputStream(new FileInputStream(this._file));
        }

        @Override
        public String toString() {
            return super.toString() + "[ " + this.getArgString() + "]";
        }
    }

    private static class ResourceFileDownloadResponse
    extends FileDownloadResponse {
        URL _url;

        ResourceFileDownloadResponse(URL url, String mimeType, String versionId, long lastModified) {
            super(mimeType, versionId, lastModified, url.toString());
            this._url = url;
        }

        @Override
        int getContentLength() throws IOException {
            return this._url.openConnection().getContentLength();
        }

        @Override
        InputStream getContent() throws IOException {
            return this._url.openConnection().getInputStream();
        }

        @Override
        public String toString() {
            return super.toString() + "[ " + this.getArgString() + "]";
        }
    }

    private static class ByteArrayFileDownloadResponse
    extends FileDownloadResponse {
        private byte[] _content;

        ByteArrayFileDownloadResponse(byte[] content, String mimeType, String versionId, long lastModified) {
            super(mimeType, versionId, lastModified);
            this._content = content;
        }

        @Override
        int getContentLength() {
            return this._content.length;
        }

        @Override
        InputStream getContent() {
            return new ByteArrayInputStream(this._content);
        }

        @Override
        public String toString() {
            return super.toString() + "[ " + this.getArgString() + "]";
        }
    }

    private static abstract class FileDownloadResponse
    extends DownloadResponse {
        private String _mimeType;
        private String _versionId;
        private long _lastModified;
        private String _fileName;

        FileDownloadResponse(String mimeType, String versionId, long lastModified) {
            this._mimeType = mimeType;
            this._versionId = versionId;
            this._lastModified = lastModified;
            this._fileName = null;
        }

        FileDownloadResponse(String mimeType, String versionId, long lastModified, String fileName) {
            this._mimeType = mimeType;
            this._versionId = versionId;
            this._lastModified = lastModified;
            this._fileName = fileName;
        }

        String getMimeType() {
            return this._mimeType;
        }

        String getVersionId() {
            return this._versionId;
        }

        long getLastModified() {
            return this._lastModified;
        }

        abstract int getContentLength() throws IOException;

        abstract InputStream getContent() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendRespond(HttpServletResponse response) throws IOException {
            response.setContentType(this.getMimeType());
            response.setContentLength(this.getContentLength());
            if (this.getVersionId() != null) {
                response.setHeader(DownloadResponse.HEADER_JNLP_VERSION, this.getVersionId());
            }
            if (this.getLastModified() != 0L) {
                response.setDateHeader(DownloadResponse.HEADER_LASTMOD, this.getLastModified());
            }
            if (this._fileName != null) {
                if (this._fileName.endsWith(".pack.gz")) {
                    response.setHeader(DownloadResponse.CONTENT_ENCODING, DownloadResponse.PACK200_GZIP_ENCODING);
                } else if (this._fileName.endsWith(".gz")) {
                    response.setHeader(DownloadResponse.CONTENT_ENCODING, DownloadResponse.GZIP_ENCODING);
                } else {
                    response.setHeader(DownloadResponse.CONTENT_ENCODING, null);
                }
            }
            ServletOutputStream out = response.getOutputStream();
            try (InputStream in = this.getContent();){
                int read;
                byte[] bytes = new byte[32768];
                while ((read = in.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
            }
        }

        protected String getArgString() {
            long length = 0L;
            try {
                length = this.getContentLength();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "Mimetype=" + this.getMimeType() + " VersionId=" + this.getVersionId() + " Timestamp=" + new Date(this.getLastModified()) + " Length=" + length;
        }
    }

    public static class JnlpErrorResponse
    extends DownloadResponse {
        private String _message;

        public JnlpErrorResponse(int jnlpErrorCode) {
            String msg = Integer.toString(jnlpErrorCode);
            String dsc = "No description";
            try {
                dsc = JnlpDownloadServlet.getResourceBundle().getString("servlet.jnlp.err." + msg);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this._message = msg + " " + dsc;
        }

        @Override
        public void sendRespond(HttpServletResponse response) throws IOException {
            response.setContentType(DownloadResponse.JNLP_ERROR_MIMETYPE);
            PrintWriter pw = response.getWriter();
            pw.println(this._message);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this._message + "]";
        }
    }

    private static class HeadRequestResponse
    extends DownloadResponse {
        private String _mimeType;
        private String _versionId;
        private long _lastModified;
        private int _contentLength;

        HeadRequestResponse(String mimeType, String versionId, long lastModified, int contentLength) {
            this._mimeType = mimeType;
            this._versionId = versionId;
            this._lastModified = lastModified;
            this._contentLength = contentLength;
        }

        @Override
        public void sendRespond(HttpServletResponse response) throws IOException {
            response.setContentType(this._mimeType);
            response.setContentLength(this._contentLength);
            if (this._versionId != null) {
                response.setHeader(DownloadResponse.HEADER_JNLP_VERSION, this._versionId);
            }
            if (this._lastModified != 0L) {
                response.setDateHeader(DownloadResponse.HEADER_LASTMOD, this._lastModified);
            }
            response.sendError(200);
        }
    }

    private static class NoContentResponse
    extends DownloadResponse {
        private NoContentResponse() {
        }

        @Override
        public void sendRespond(HttpServletResponse response) throws IOException {
            response.sendError(204);
        }
    }

    private static class NotFoundResponse
    extends DownloadResponse {
        private NotFoundResponse() {
        }

        @Override
        public void sendRespond(HttpServletResponse response) throws IOException {
            response.sendError(404);
        }
    }

    private static class NotModifiedResponse
    extends DownloadResponse {
        private NotModifiedResponse() {
        }

        @Override
        public void sendRespond(HttpServletResponse response) throws IOException {
            response.sendError(304);
        }
    }
}

