/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class WeblogicMojoUtilities {
    private WeblogicMojoUtilities() {
    }

    public static String getAdminUrl(String inProtocol, String inServerName, String inServerPort) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(inProtocol).append("://");
        buffer.append(inServerName);
        buffer.append(":").append(inServerPort);
        return buffer.toString();
    }

    public static String updateArtifactName(String inName, String inProjectPackaging) {
        String newName = inName;
        if (inProjectPackaging.equalsIgnoreCase("ear")) {
            if (!inName.endsWith(".ear")) {
                newName = inName.concat(".ear");
            }
        } else if (inProjectPackaging.equalsIgnoreCase("war")) {
            if (!inName.endsWith(".war")) {
                newName = inName.concat(".war");
            }
        } else if (inProjectPackaging.equalsIgnoreCase("ejb")) {
            if (inName.endsWith(".ejb")) {
                newName = inName.replaceAll("\\.ejb", ".jar");
            } else if (!inName.endsWith(".jar")) {
                newName = inName.concat(".jar");
            }
        } else {
            throw new IllegalArgumentException("Unsupported project packaging " + inProjectPackaging);
        }
        return newName;
    }

    public static String getDependencies(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            return "";
        }
        Iterator iter = inArtifacts.iterator();
        StringBuffer buffer = new StringBuffer();
        if (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            buffer.append(artifact.getFile());
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        return buffer.toString();
    }

    public static File getEarFileName(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("EAR not found in artifact list.");
        }
        Iterator iter = inArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!"ear".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("EAR not found in artifact list.");
    }

    public static File getWarFileName(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("WAR not found in artifact list.");
        }
        Iterator iter = inArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!"war".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("WAR not found in artifact list.");
    }

    public static File getWarFileName(Set inArtifacts, String fileName) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("WAR not found in artifact list.");
        }
        Iterator iter = inArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!"war".equals(artifact.getType()) || !artifact.getFile().getName().contains(fileName)) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("WAR not found in artifact list.");
    }

    public static File getEjbJarFileName(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("EJB jar not found in artifact list.");
        }
        Iterator iter = inArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!"ejb".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("EJB jar not found in artifact list.");
    }

    public static String getDependencies(Set artifacts, List pluginArtifacts) {
        Iterator pluginIter;
        if (!(artifacts != null && !artifacts.isEmpty() || pluginArtifacts != null && pluginArtifacts.size() != 0)) {
            return "";
        }
        Iterator iter = artifacts.iterator();
        StringBuffer buffer = new StringBuffer(1024);
        if (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            buffer.append(artifact.getFile());
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        if ((pluginIter = pluginArtifacts.iterator()).hasNext()) {
            Artifact artifact = (Artifact)pluginIter.next();
            if (buffer.length() > 0) {
                buffer.append(System.getProperty("path.separator"));
            }
            buffer.append(artifact.getFile());
            while (pluginIter.hasNext()) {
                artifact = (Artifact)pluginIter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        return buffer.toString();
    }
}

