/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.Deployer;

public abstract class DeployMojoBase
extends AbstractWeblogicMojo {
    private String adminServerHostName;
    private String adminServerProtocol;
    private String adminServerPort;
    private String userId;
    private String password;
    private String artifactPath;
    private String projectPackaging;
    private String name;
    private String targetNames;
    private boolean remote;
    private boolean stage;
    private boolean debug;
    private boolean verbose;
    private boolean upload;
    private boolean continueOnFailure;
    private boolean noWait;
    private int timeout;
    private boolean version;
    private boolean noVersion;
    private boolean noExit;
    private boolean exploded;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"Running the Deploy Mojo Base without an implementation");
        }
    }

    public String getAdminServerHostName() {
        return this.adminServerHostName;
    }

    public void setAdminServerHostName(String inAdminServerHostName) {
        this.adminServerHostName = inAdminServerHostName;
    }

    public String getAdminServerPort() {
        return this.adminServerPort;
    }

    public void setAdminServerPort(String inAdminServerPort) {
        this.adminServerPort = inAdminServerPort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String inPassword) {
        this.password = inPassword;
    }

    public String getTargetNames() {
        return this.targetNames;
    }

    public void setTargetNames(String inTargetNames) {
        this.targetNames = inTargetNames;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String inUserId) {
        this.userId = inUserId;
    }

    public List getTargetList() {
        ArrayList<String> targets = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.getTargetNames(), ",");
        while (tokens.hasMoreTokens()) {
            targets.add(tokens.nextToken());
        }
        return targets;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean inRemote) {
        this.remote = inRemote;
    }

    public String getAdminServerProtocol() {
        return this.adminServerProtocol;
    }

    public void setAdminServerProtocol(String inAdminServerProtocol) {
        this.adminServerProtocol = inAdminServerProtocol;
    }

    protected String[] getInputParameters(String inOperation) {
        ArrayList<String> parameterList = new ArrayList<String>();
        String adminURL = WeblogicMojoUtilities.getAdminUrl(this.adminServerProtocol, this.adminServerHostName, this.adminServerPort);
        parameterList.add("-adminurl");
        parameterList.add(adminURL);
        parameterList.add("-username");
        parameterList.add(this.getUserId());
        parameterList.add("-password");
        parameterList.add(this.getPassword());
        if (this.verbose) {
            parameterList.add("-verbose");
        }
        if (this.debug) {
            parameterList.add("-debug");
        }
        if (this.noWait) {
            parameterList.add("-nowait");
        }
        if (this.timeout > 0) {
            parameterList.add("-timeout " + this.timeout);
        }
        if (this.version) {
            parameterList.add("-version");
        }
        if (this.noVersion) {
            parameterList.add("-noVersion");
        }
        if (this.noExit) {
            parameterList.add("-noexit");
        }
        if (!inOperation.equalsIgnoreCase("listapps")) {
            parameterList.add("-name");
            parameterList.add(this.getName());
        }
        if (!inOperation.equalsIgnoreCase("listapps")) {
            parameterList.add("-targets");
            parameterList.add(this.getTargetNames());
        }
        if (inOperation.equalsIgnoreCase("deploy")) {
            if (this.isRemote()) {
                parameterList.add("-upload");
            }
            parameterList.add("-source");
            parameterList.add(this.getArtifactPath());
        }
        String operation = "-" + inOperation;
        parameterList.add(operation);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Weblogic Deployment parameters " + parameterList));
        }
        return parameterList.toArray(new String[parameterList.size()]);
    }

    protected boolean executeDeployer(String[] parameters, String errorMessage) throws MojoExecutionException {
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("continueOnFailure is " + this.continueOnFailure));
            }
            Deployer deployer = new Deployer(parameters);
            deployer.run();
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(errorMessage + ": " + e.getMessage()));
            }
            if (this.continueOnFailure) {
                this.getLog().info((CharSequence)"Continuing on failure.");
                this.getLog().error((Throwable)e);
                return false;
            }
            throw new MojoExecutionException(errorMessage + ": " + e.getMessage(), e);
        }
        return true;
    }

    public String getArtifactPath() {
        String fixedArtifactPath = this.exploded ? this.artifactPath : WeblogicMojoUtilities.updateArtifactName(this.artifactPath, this.projectPackaging);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("fixedArtifactPath=" + fixedArtifactPath));
        }
        return fixedArtifactPath;
    }

    public void setArtifactPath(String inArtifactPath) {
        this.artifactPath = inArtifactPath;
    }

    public String getProjectPackaging() {
        return this.projectPackaging;
    }

    public void setProjectPackaging(String inProjectPackaging) {
        this.projectPackaging = inProjectPackaging;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DeployMojoBase[");
        buffer.append("adminServerHostName = ").append(this.adminServerHostName);
        buffer.append(", adminServerProtocol = ").append(this.adminServerProtocol);
        buffer.append(", adminServerPort = ").append(this.adminServerPort);
        buffer.append(", userId = ").append(this.userId);
        buffer.append(", password = ").append(this.password);
        buffer.append(", artifactPath = ").append(this.artifactPath);
        buffer.append(", projectPackaging = ").append(this.projectPackaging);
        buffer.append(", name = ").append(this.name);
        buffer.append(", targetNames = ").append(this.targetNames);
        buffer.append(", remote = ").append(this.remote);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean isStage() {
        return this.stage;
    }

    public void setStage(boolean stage) {
        this.stage = stage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isUpload() {
        return this.upload;
    }

    public void setUpload(boolean upload) {
        this.upload = upload;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isNoVersion() {
        return this.noVersion;
    }

    public void setNoVersion(boolean noVersion) {
        this.noVersion = noVersion;
    }

    public boolean isNoExit() {
        return this.noExit;
    }

    public void setNoExit(boolean noExit) {
        this.noExit = noExit;
    }

    public boolean isExploded() {
        return this.exploded;
    }

    public void setExploded(boolean exploded) {
        this.exploded = exploded;
    }
}

