/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=WagonUpload.class, hint="default")
public class DefaultWagonUpload
implements WagonUpload {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWagonUpload.class);
    @Requirement
    private ArchiverManager archiverManager;

    public void upload(Wagon wagon, FileSet fileset) throws WagonException {
        FileSetManager fileSetManager = new FileSetManager(LOG, LOG.isDebugEnabled());
        Object[] files = fileSetManager.getIncludedFiles(fileset);
        Arrays.sort(files);
        String url = wagon.getRepository().getUrl() + "/";
        if (files.length == 0) {
            LOG.info("Nothing to upload.");
            return;
        }
        for (Object file : files) {
            String relativeDestPath = StringUtils.replace((String)file, (String)"\\", (String)"/");
            if (!StringUtils.isBlank((String)fileset.getOutputDirectory())) {
                relativeDestPath = fileset.getOutputDirectory() + "/" + relativeDestPath;
            }
            File source = new File(fileset.getDirectory(), (String)file);
            LOG.info("Uploading {} to {}{} ...", new Object[]{source, url, relativeDestPath});
            wagon.put(source, relativeDestPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(Wagon wagon, FileSet fileset, boolean optimize) throws WagonException, IOException {
        if (!optimize) {
            this.upload(wagon, fileset);
            return;
        }
        if (!(wagon instanceof CommandExecutor)) {
            throw new UnsupportedProtocolException("Wagon " + wagon.getRepository().getProtocol() + " does not support optimize upload");
        }
        LOG.info("Uploading {}", (Object)fileset);
        File zipFile = File.createTempFile("wagon", ".zip");
        try {
            FileSetManager fileSetManager = new FileSetManager(LOG, LOG.isDebugEnabled());
            String[] files = fileSetManager.getIncludedFiles(fileset);
            if (files.length == 0) {
                LOG.info("Nothing to upload.");
                return;
            }
            LOG.info("Creating {} ...", (Object)zipFile);
            this.createZip(files, zipFile, fileset.getDirectory());
            String remoteFile = zipFile.getName();
            String remoteDir = fileset.getOutputDirectory();
            if (!StringUtils.isBlank((String)remoteDir)) {
                remoteFile = remoteDir + "/" + remoteFile;
            }
            LOG.info("Uploading {} to {}/{} ...", new Object[]{zipFile, wagon.getRepository().getUrl(), remoteFile});
            wagon.put(zipFile, remoteFile);
            String command = "unzip -o -qq -d " + remoteDir + " " + remoteFile;
            if (StringUtils.isBlank((String)remoteDir)) {
                command = "unzip -o -qq " + remoteFile;
            }
            try {
                LOG.info("Remote: {}", (Object)command);
                ((CommandExecutor)wagon).executeCommand(command);
            }
            finally {
                command = "rm -f " + remoteFile;
                LOG.info("Remote: {}", (Object)command);
                ((CommandExecutor)wagon).executeCommand(command);
            }
        }
        finally {
            zipFile.delete();
        }
    }

    private void createZip(String[] files, File zipFile, String basedir) throws IOException {
        try {
            ZipArchiver archiver = (ZipArchiver)this.archiverManager.getArchiver(zipFile);
            archiver.setDestFile(zipFile);
            for (String file : files) {
                archiver.addFile(new File(basedir, file), file);
            }
            archiver.createArchive();
        }
        catch (NoSuchArchiverException noSuchArchiverException) {
            // empty catch block
        }
    }
}

