/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.MavenRepoMerger;
import org.codehaus.mojo.wagon.shared.WagonDownload;
import org.codehaus.mojo.wagon.shared.WagonFileSet;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=MavenRepoMerger.class, hint="default")
public class DefaultMavenRepoMerger
implements MavenRepoMerger {
    @Requirement
    private WagonDownload downloader;
    @Requirement
    private WagonUpload uploader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Wagon src, Wagon target, boolean optimize, Log logger) throws WagonException, IOException {
        File downloadSrcDir = DefaultMavenRepoMerger.createTempDirectory("wagon-maven-plugin");
        WagonFileSet srcFileSet = new WagonFileSet();
        srcFileSet.setDownloadDirectory(downloadSrcDir);
        String[] excludes = new String[]{".*/**", "archetype-catalog.xml*"};
        srcFileSet.setExcludes(excludes);
        try {
            String[] files;
            this.downloader.download(src, srcFileSet, logger);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(downloadSrcDir);
            String[] includes = new String[]{"**/maven-metadata.xml"};
            scanner.setIncludes(includes);
            scanner.scan();
            for (String file : files = scanner.getIncludedFiles()) {
                File srcMetadaFile = new File(downloadSrcDir, file + ".rip");
                try {
                    target.get(file.replace('\\', '/'), srcMetadaFile);
                }
                catch (ResourceDoesNotExistException e) {
                    continue;
                }
                try {
                    this.mergeMetadata(srcMetadaFile, logger);
                }
                catch (XmlPullParserException e) {
                    throw new IOException("Metadata file is corrupt " + file + " Reason: " + e.getMessage());
                }
            }
            FileSet tobeUploadedFileSet = new FileSet();
            tobeUploadedFileSet.setDirectory(downloadSrcDir.getAbsolutePath());
            this.uploader.upload(target, tobeUploadedFileSet, optimize);
        }
        finally {
            FileUtils.deleteDirectory((File)downloadSrcDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeMetadata(File existingMetadata, Log logger) throws IOException, XmlPullParserException {
        File stagedMetadataFile = new File(existingMetadata.getParentFile(), "maven-metadata.xml");
        try (FileReader existingMetadataReader = new FileReader(existingMetadata);
             FileWriter stagedMetadataWriter = new FileWriter(stagedMetadataFile);
             FileReader reader = new FileReader(stagedMetadataFile);){
            MetadataXpp3Reader xppReader = new MetadataXpp3Reader();
            Metadata existing = xppReader.read((Reader)existingMetadataReader);
            Metadata staged = xppReader.read((Reader)reader);
            existing.merge(staged);
            MetadataXpp3Writer metadataXpp3Writer = new MetadataXpp3Writer();
            metadataXpp3Writer.write((Writer)stagedMetadataWriter, existing);
            logger.info((CharSequence)("Merging metadata file: " + stagedMetadataFile));
        }
        finally {
            existingMetadata.delete();
        }
        try {
            File newMd5 = new File(stagedMetadataFile.getParentFile(), "maven-metadata.xml.md5");
            FileUtils.fileWrite((String)newMd5.getAbsolutePath(), (String)this.checksum(stagedMetadataFile, "md5"));
            File newSha1 = new File(stagedMetadataFile.getParentFile(), "maven-metadata.xml.sha1");
            FileUtils.fileWrite((String)newSha1.getAbsolutePath(), (String)this.checksum(stagedMetadataFile, "sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String checksum(File file, String type) throws IOException, NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance(type);
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int i;
            byte[] buf = new byte[8192];
            while ((i = is.read(buf)) > 0) {
                md5.update(buf, 0, i);
            }
        }
        return this.encode(md5.digest());
    }

    private String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits");
        }
        StringBuilder retValue = new StringBuilder();
        for (byte aBinaryData : binaryData) {
            String t = Integer.toHexString(aBinaryData & 0xFF);
            if (t.length() == 1) {
                retValue.append("0").append(t);
                continue;
            }
            retValue.append(t);
        }
        return retValue.toString().trim();
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

