/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.AbstractSingleWagonMojo;

@Mojo(name="download-single", requiresProject=false)
public class DownloadSingleMojo
extends AbstractSingleWagonMojo {
    @Parameter(property="wagon.fromFile", required=true)
    private String fromFile;
    @Parameter(property="wagon.toDir")
    private File toDir;
    @Parameter(property="wagon.toFile")
    private File toFile;
    @Parameter(property="wagon.skipIfExists")
    private boolean skipIfExists;

    @Override
    protected void execute(Wagon wagon) throws MojoExecutionException, WagonException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution.");
            return;
        }
        if (this.toDir != null) {
            this.toFile = new File(this.toDir, new File(this.fromFile).getName());
        }
        if (this.toFile == null) {
            throw new MojoExecutionException("Either toDir or toFile is required");
        }
        if (this.skipIfExists && this.toFile.exists()) {
            this.getLog().info((CharSequence)("Skip execution - file " + this.toFile + " already exists."));
            return;
        }
        this.getLog().info((CharSequence)("Downloading: " + wagon.getRepository().getUrl() + "/" + this.fromFile + " to " + this.toFile));
        wagon.get(this.fromFile, this.toFile);
    }
}

