/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.mojo.versions.reporting.model.DependencyInfo;
import org.codehaus.mojo.versions.reporting.model.DependencyReportSummary;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.stax.IndentingXMLStreamWriter;

public class DependencyUpdatesReportStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, DependencyUpdatesReport dependencyUpdatesReport) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(dependencyUpdatesReport.getModelEncoding(), "1.0");
        this.writeDependencyUpdatesReport(dependencyUpdatesReport, "DependencyUpdatesReport", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, DependencyUpdatesReport dependencyUpdatesReport) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, dependencyUpdatesReport.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(dependencyUpdatesReport.getModelEncoding(), "1.0");
        this.writeDependencyUpdatesReport(dependencyUpdatesReport, "DependencyUpdatesReport", serializer);
        serializer.writeEndDocument();
    }

    private void writeDependencyInfo(DependencyInfo dependencyInfo, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependencyInfo != null) {
            serializer.writeStartElement(tagName);
            if (dependencyInfo.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(dependencyInfo.getGroupId());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(dependencyInfo.getArtifactId());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getScope() != null) {
                serializer.writeStartElement("scope");
                serializer.writeCharacters(dependencyInfo.getScope());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getClassifier() != null) {
                serializer.writeStartElement("classifier");
                serializer.writeCharacters(dependencyInfo.getClassifier());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getType() != null) {
                serializer.writeStartElement("type");
                serializer.writeCharacters(dependencyInfo.getType());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getCurrentVersion() != null) {
                serializer.writeStartElement("currentVersion");
                serializer.writeCharacters(dependencyInfo.getCurrentVersion());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getLastVersion() != null) {
                serializer.writeStartElement("lastVersion");
                serializer.writeCharacters(dependencyInfo.getLastVersion());
                serializer.writeEndElement();
            }
            if (dependencyInfo.getAny() != null && dependencyInfo.getAny().size() > 0) {
                serializer.writeStartElement("any");
                for (String any : dependencyInfo.getAny()) {
                    serializer.writeStartElement("any");
                    serializer.writeCharacters(any);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (dependencyInfo.getIncrementals() != null && dependencyInfo.getIncrementals().size() > 0) {
                serializer.writeStartElement("incrementals");
                for (String incremental : dependencyInfo.getIncrementals()) {
                    serializer.writeStartElement("incremental");
                    serializer.writeCharacters(incremental);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (dependencyInfo.getMinors() != null && dependencyInfo.getMinors().size() > 0) {
                serializer.writeStartElement("minors");
                for (String minor : dependencyInfo.getMinors()) {
                    serializer.writeStartElement("minor");
                    serializer.writeCharacters(minor);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (dependencyInfo.getMajors() != null && dependencyInfo.getMajors().size() > 0) {
                serializer.writeStartElement("majors");
                for (String major : dependencyInfo.getMajors()) {
                    serializer.writeStartElement("major");
                    serializer.writeCharacters(major);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (dependencyInfo.getStatus() != null) {
                serializer.writeStartElement("status");
                serializer.writeCharacters(dependencyInfo.getStatus());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDependencyReportSummary(DependencyReportSummary dependencyReportSummary, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependencyReportSummary != null) {
            serializer.writeStartElement(tagName);
            if (dependencyReportSummary.getUsingLastVersion() != null) {
                serializer.writeStartElement("usingLastVersion");
                serializer.writeCharacters(dependencyReportSummary.getUsingLastVersion());
                serializer.writeEndElement();
            }
            if (dependencyReportSummary.getNextVersionAvailable() != null) {
                serializer.writeStartElement("nextVersionAvailable");
                serializer.writeCharacters(dependencyReportSummary.getNextVersionAvailable());
                serializer.writeEndElement();
            }
            if (dependencyReportSummary.getNextIncrementalAvailable() != null) {
                serializer.writeStartElement("nextIncrementalAvailable");
                serializer.writeCharacters(dependencyReportSummary.getNextIncrementalAvailable());
                serializer.writeEndElement();
            }
            if (dependencyReportSummary.getNextMinorAvailable() != null) {
                serializer.writeStartElement("nextMinorAvailable");
                serializer.writeCharacters(dependencyReportSummary.getNextMinorAvailable());
                serializer.writeEndElement();
            }
            if (dependencyReportSummary.getNextMajorAvailable() != null) {
                serializer.writeStartElement("nextMajorAvailable");
                serializer.writeCharacters(dependencyReportSummary.getNextMajorAvailable());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDependencyUpdatesReport(DependencyUpdatesReport dependencyUpdatesReport, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependencyUpdatesReport != null) {
            serializer.setDefaultNamespace("https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/2.0.0");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/2.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/2.0.0 https://www.mojohaus.org/versions/versions-model-report/xsd/dependency-updates-report-2.0.0.xsd");
            if (dependencyUpdatesReport.getSummary() != null) {
                this.writeDependencyReportSummary(dependencyUpdatesReport.getSummary(), "summary", serializer);
            }
            if (dependencyUpdatesReport.getDependencyManagements() != null && dependencyUpdatesReport.getDependencyManagements().size() > 0) {
                serializer.writeStartElement("dependencyManagements");
                for (DependencyInfo o : dependencyUpdatesReport.getDependencyManagements()) {
                    this.writeDependencyInfo(o, "dependencyManagement", serializer);
                }
                serializer.writeEndElement();
            }
            if (dependencyUpdatesReport.getDependencies() != null && dependencyUpdatesReport.getDependencies().size() > 0) {
                serializer.writeStartElement("dependencies");
                for (DependencyInfo o : dependencyUpdatesReport.getDependencies()) {
                    this.writeDependencyInfo(o, "dependency", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

