/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.mojo.versions.reporting.model.DependencyInfo;
import org.codehaus.mojo.versions.reporting.model.DependencyReportSummary;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesReport;

public class DependencyUpdatesReportStaxReader {
    public String determineVersion(Reader reader) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            return this.getVersionFromRootNamespace(xmlStreamReader);
        }
        throw new XMLStreamException("Version not found in document", xmlStreamReader.getLocation());
    }

    private String getVersionFromRootNamespace(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String uri = xmlStreamReader.getNamespaceURI("");
        if (uri == null) {
            throw new XMLStreamException("No namespace specified, but versionDefinition requires it", xmlStreamReader.getLocation());
        }
        String uriPrefix = "https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/";
        String uriSuffix = "";
        if (!uri.startsWith(uriPrefix) || !uri.endsWith(uriSuffix)) {
            throw new XMLStreamException("Namespace URI: '" + uri + "' does not match pattern 'https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/${version}'", xmlStreamReader.getLocation());
        }
        return uri.substring(uriPrefix.length(), uri.length() - uriSuffix.length());
    }

    public DependencyUpdatesReport read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        return this.read(xmlStreamReader, strict);
    }

    public DependencyUpdatesReport read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public DependencyUpdatesReport read(InputStream stream, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
        return this.read(xmlStreamReader, strict);
    }

    public DependencyUpdatesReport read(InputStream stream) throws IOException, XMLStreamException {
        return this.read(stream, true);
    }

    public DependencyUpdatesReport read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURI().toURL().toExternalForm(), new FileInputStream(file));
        return this.read(xmlStreamReader, strict);
    }

    public DependencyUpdatesReport read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private boolean checkFieldWithDuplicate(XMLStreamReader xmlStreamReader, String tagName, String alias, Set parsed) throws XMLStreamException {
        if (!xmlStreamReader.getLocalName().equals(tagName) && !xmlStreamReader.getLocalName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation());
        }
        return true;
    }

    private void checkUnknownElement(XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount != 0) {
            xmlStreamReader.next();
            if (xmlStreamReader.getEventType() == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (xmlStreamReader.getEventType() != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
            }
        }
        return null;
    }

    private String getDefaultValue(String s, String v) {
        if (s == null) {
            s = v;
        }
        return s;
    }

    private double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        block4: while (true) {
            int eventType = xmlStreamReader.next();
            switch (eventType) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return eventType;
                }
            }
            break;
        }
        throw new XMLStreamException("expected start or end tag", xmlStreamReader.getLocation());
    }

    private DependencyInfo parseDependencyInfo(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        DependencyInfo dependencyInfo = new DependencyInfo();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "groupId", null, parsed)) {
                dependencyInfo.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "artifactId", null, parsed)) {
                dependencyInfo.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "scope", null, parsed)) {
                dependencyInfo.setScope(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "classifier", null, parsed)) {
                dependencyInfo.setClassifier(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "type", null, parsed)) {
                dependencyInfo.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "currentVersion", null, parsed)) {
                dependencyInfo.setCurrentVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "lastVersion", null, parsed)) {
                dependencyInfo.setLastVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "any", null, parsed)) {
                ArrayList<String> any = new ArrayList<String>();
                dependencyInfo.setAny(any);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("any".equals(xmlStreamReader.getLocalName())) {
                        any.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "incrementals", null, parsed)) {
                ArrayList<String> incrementals = new ArrayList<String>();
                dependencyInfo.setIncrementals(incrementals);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("incremental".equals(xmlStreamReader.getLocalName())) {
                        incrementals.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "minors", null, parsed)) {
                ArrayList<String> minors = new ArrayList<String>();
                dependencyInfo.setMinors(minors);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("minor".equals(xmlStreamReader.getLocalName())) {
                        minors.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "majors", null, parsed)) {
                ArrayList<String> majors = new ArrayList<String>();
                dependencyInfo.setMajors(majors);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("major".equals(xmlStreamReader.getLocalName())) {
                        majors.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "status", null, parsed)) {
                dependencyInfo.setStatus(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return dependencyInfo;
    }

    private DependencyReportSummary parseDependencyReportSummary(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        DependencyReportSummary dependencyReportSummary = new DependencyReportSummary();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "usingLastVersion", null, parsed)) {
                dependencyReportSummary.setUsingLastVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "nextVersionAvailable", null, parsed)) {
                dependencyReportSummary.setNextVersionAvailable(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "nextIncrementalAvailable", null, parsed)) {
                dependencyReportSummary.setNextIncrementalAvailable(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "nextMinorAvailable", null, parsed)) {
                dependencyReportSummary.setNextMinorAvailable(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "nextMajorAvailable", null, parsed)) {
                dependencyReportSummary.setNextMajorAvailable(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return dependencyReportSummary;
    }

    private DependencyUpdatesReport parseDependencyUpdatesReport(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        DependencyUpdatesReport dependencyUpdatesReport = new DependencyUpdatesReport();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "summary", null, parsed)) {
                dependencyUpdatesReport.setSummary(this.parseDependencyReportSummary(xmlStreamReader, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "dependencyManagements", null, parsed)) {
                ArrayList<DependencyInfo> dependencyManagements = new ArrayList<DependencyInfo>();
                dependencyUpdatesReport.setDependencyManagements(dependencyManagements);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("dependencyManagement".equals(xmlStreamReader.getLocalName())) {
                        dependencyUpdatesReport.addDependencyManagement(this.parseDependencyInfo(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "dependencies", null, parsed)) {
                ArrayList<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
                dependencyUpdatesReport.setDependencies(dependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("dependency".equals(xmlStreamReader.getLocalName())) {
                        dependencyUpdatesReport.addDependency(this.parseDependencyInfo(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return dependencyUpdatesReport;
    }

    private DependencyUpdatesReport read(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while (eventType != 8) {
            if (eventType == 7) {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if (eventType == 1) {
                if (strict && !"DependencyUpdatesReport".equals(xmlStreamReader.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'DependencyUpdatesReport' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null);
                }
                String modelVersion = this.getVersionFromRootNamespace(xmlStreamReader);
                if ("3".equals(modelVersion)) {
                    modelVersion = "3.0.0";
                }
                if (!"2.0.0".equals(modelVersion)) {
                    throw new XMLStreamException("Document model version of '" + modelVersion + "' doesn't match reader version of '2.0.0'", xmlStreamReader.getLocation());
                }
                DependencyUpdatesReport dependencyUpdatesReport = this.parseDependencyUpdatesReport(xmlStreamReader, strict);
                dependencyUpdatesReport.setModelEncoding(encoding);
                this.resolveReferences(dependencyUpdatesReport);
                return dependencyUpdatesReport;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException("Expected root element 'DependencyUpdatesReport' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null);
    }

    private void resolveReferences(DependencyUpdatesReport value) {
    }
}

