/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.enforcer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.enforcer.PluginLogWrapper;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.rule.RulesServiceBuilder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.eclipse.aether.RepositorySystem;

@Named(value="maxDependencyUpdates")
public class MaxDependencyUpdates
extends AbstractEnforcerRule {
    private final ArtifactFactory artifactFactory;
    private final ArtifactHandlerManager artifactHandlerManager;
    protected int maxUpdates = 0;
    protected boolean processDependencies = true;
    protected boolean processDependencyManagement = true;
    protected boolean processDependencyManagementTransitive = true;
    protected boolean processPluginDependencies = true;
    protected boolean processPluginDependenciesInPluginManagement = true;
    protected boolean ignoreMinorUpdates = false;
    protected boolean ignoreIncrementalUpdates = false;
    protected boolean ignoreSubIncrementalUpdates = false;
    protected List<String> dependencyIncludes = Collections.singletonList("*");
    protected List<String> dependencyExcludes = Collections.emptyList();
    protected List<String> dependencyManagementIncludes = Collections.singletonList("*");
    protected List<String> dependencyManagementExcludes = Collections.emptyList();
    protected List<String> pluginDependencyIncludes = Collections.singletonList("*");
    protected List<String> pluginDependencyExcludes = Collections.emptyList();
    protected List<String> pluginManagementDependencyIncludes = Collections.singletonList("*");
    protected List<String> pluginManagementDependencyExcludes = Collections.emptyList();
    private String serverId;
    private String rulesUri;
    protected RuleSet ruleSet;
    protected boolean allowSnapshots;
    private final MavenProject project;
    private final RepositorySystem repositorySystem;
    private final Map<String, Wagon> wagonMap;
    private final MavenSession mavenSession;
    private final MojoExecution mojoExecution;

    @Inject
    public MaxDependencyUpdates(MavenProject project, ArtifactFactory artifactFactory, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, MavenSession mavenSession, MojoExecution mojoExecution) {
        this.project = project;
        this.artifactFactory = artifactFactory;
        this.artifactHandlerManager = artifactHandlerManager;
        this.repositorySystem = repositorySystem;
        this.wagonMap = wagonMap;
        this.mavenSession = mavenSession;
        this.mojoExecution = mojoExecution;
    }

    private synchronized VersionsHelper createVersionsHelper(String serverId, String rulesUri, RuleSet ruleSet) throws EnforcerRuleError {
        try {
            PluginLogWrapper log = new PluginLogWrapper(this.getLog());
            RuleService ruleService = new RulesServiceBuilder().withWagonMap(this.wagonMap).withServerId(serverId).withRulesUri(rulesUri).withRuleSet(ruleSet).withIgnoredVersions(null).withLog((Log)log).withMavenSession(this.mavenSession).build();
            PomHelper pomHelper = new PomHelper(this.artifactFactory, (ExpressionEvaluator)new VersionsExpressionEvaluator(this.mavenSession, this.mojoExecution));
            return new DefaultVersionsHelper.Builder().withArtifactFactory(this.artifactFactory).withRepositorySystem(this.repositorySystem).withLog((Log)log).withMavenSession(this.mavenSession).withPomHelper(pomHelper).withRuleService(ruleService).build();
        }
        catch (MojoExecutionException e) {
            throw new EnforcerRuleError("Cannot resolve dependency", (Throwable)e);
        }
    }

    public void execute() throws EnforcerRuleException {
        PluginLogWrapper pluginLog = new PluginLogWrapper(this.getLog());
        VersionsHelper versionsHelper = this.createVersionsHelper(this.serverId != null ? this.serverId : "serverId", this.rulesUri, this.ruleSet);
        TreeSet dependencies = new TreeSet(DependencyComparator.INSTANCE);
        if (this.processDependencyManagement) {
            try {
                dependencies.addAll(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromDependencyManagement((MavenProject)this.project, (boolean)this.processDependencyManagementTransitive, (Log)pluginLog), this.dependencyManagementIncludes, this.dependencyManagementExcludes, (String)"Dependency Management", (Log)pluginLog));
            }
            catch (VersionRetrievalException e) {
                throw new EnforcerRuleError(e.getMessage());
            }
        }
        if (this.processPluginDependencies) {
            dependencies.addAll(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromPlugins((MavenProject)this.project), this.pluginDependencyIncludes, this.pluginDependencyExcludes, (String)"Plugin Dependencies", (Log)pluginLog));
        }
        if (this.processPluginDependenciesInPluginManagement) {
            dependencies.addAll(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractPluginDependenciesFromPluginsInPluginManagement((MavenProject)this.project), this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, (String)"Plugin Management Dependencies", (Log)pluginLog));
        }
        if (this.processDependencies) {
            dependencies.addAll(DependencyFilter.filterDependencies((Collection)this.project.getDependencies(), this.dependencyIncludes, this.dependencyExcludes, (String)"Dependencies", (Log)pluginLog));
        }
        try {
            Optional<Segment> ignoredSegment = this.ignoreSubIncrementalUpdates ? Optional.of(Segment.SUBINCREMENTAL) : (this.ignoreIncrementalUpdates ? Optional.of(Segment.INCREMENTAL) : (this.ignoreMinorUpdates ? Optional.of(Segment.MINOR) : Optional.empty()));
            List upgradable = versionsHelper.lookupDependenciesUpdates(dependencies.stream().filter(d -> d.getVersion() != null), false, this.allowSnapshots).values().stream().filter(v -> v.getVersions(v.restrictionForIgnoreScope(v.getCurrentVersion(), ignoredSegment), true).length > 0).collect(Collectors.toList());
            if (upgradable.size() > this.maxUpdates) {
                throw new EnforcerRuleException("More than " + this.maxUpdates + " upgradable artifacts detected: " + upgradable.stream().map(av -> av.getArtifact() + " -> [" + Arrays.stream(av.getVersions(this.allowSnapshots)).map(ArtifactVersion::toString).collect(Collectors.joining(", ")) + "]").collect(Collectors.joining(", ")));
            }
        }
        catch (VersionRetrievalException e) {
            throw new EnforcerRuleError((Throwable)e);
        }
    }
}

