/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.recording;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Named(value="xml")
public class ChangeRecorderXML
implements ChangeRecorder {
    public static final String CHANGES_NAMESPACE = "http://www.mojohaus.org/versions-maven-plugin/schema/updates/1.0";
    private final Document document;
    private final Element root;

    public ChangeRecorderXML() {
        try {
            DocumentBuilderFactory documentBuilders = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilders.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            this.root = this.document.createElementNS(CHANGES_NAMESPACE, "updates");
            this.document.appendChild(this.root);
        }
        catch (ParserConfigurationException | DOMException e) {
            throw new IllegalStateException(e);
        }
    }

    public final void recordChange(ChangeRecord changeRecord) {
        Element update = this.document.createElementNS(CHANGES_NAMESPACE, "update");
        update.setAttribute("kind", changeRecord.getKind().getLabel());
        update.setAttribute("groupId", changeRecord.getVersionChange().getGroupId());
        update.setAttribute("artifactId", changeRecord.getVersionChange().getArtifactId());
        update.setAttribute("oldVersion", changeRecord.getVersionChange().getOldVersion());
        update.setAttribute("newVersion", changeRecord.getVersionChange().getNewVersion());
        this.root.appendChild(update);
    }

    public final void writeReport(Path outputPath) throws IOException {
        if (outputPath == null) {
            throw new IOException("changeRecorderOutputFile not provided");
        }
        if (this.root.getChildNodes().getLength() == 0) {
            return;
        }
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, new StreamResult(outputStream));
            outputStream.flush();
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }
}

