/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.codehaus.mojo.versions.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.i18n.I18N;

public class PluginUpdatesRenderer
extends AbstractVersionsReportRenderer {
    private final Map<Plugin, PluginUpdatesDetails> pluginUpdates;
    private final Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates;

    public PluginUpdatesRenderer(Sink sink, I18N i18n, String bundleName, Locale locale, Map<Plugin, PluginUpdatesDetails> pluginUpdates, Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates) {
        super(sink, bundleName, i18n, locale);
        this.pluginUpdates = pluginUpdates;
        this.pluginManagementUpdates = pluginManagementUpdates;
    }

    protected void renderBody() {
        TreeMap<Object, PluginUpdatesDetails> allUpdates = new TreeMap<Object, PluginUpdatesDetails>(new PluginComparator());
        allUpdates.putAll(this.pluginManagementUpdates);
        allUpdates.putAll(this.pluginUpdates);
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.renderSummaryTotalsTable(allUpdates);
        this.renderSummaryTable("report.overview.pluginManagement", this.pluginManagementUpdates, "report.overview.noPluginManagement");
        this.renderSummaryTable("report.overview.plugin", this.pluginUpdates, "report.overview.noPlugin");
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.detail.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text"));
        this.sink.paragraph_();
        for (Map.Entry entry : allUpdates.entrySet()) {
            this.renderPluginDetail((Plugin)entry.getKey(), (PluginUpdatesDetails)entry.getValue());
        }
        this.sink.section1_();
    }

    private void renderSummaryTotalsTable(Map<Plugin, PluginUpdatesDetails> allUpdates) {
        int numInc = 0;
        int numMin = 0;
        int numMaj = 0;
        int numAny = 0;
        int numCur = 0;
        int numDep = 0;
        for (PluginUpdatesDetails pluginDetails : allUpdates.values()) {
            ArtifactVersions details = pluginDetails.getArtifactVersions();
            if (details.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
                ++numAny;
            } else if (details.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
                ++numInc;
            } else if (details.getOldestUpdate(UpdateScope.MINOR) != null) {
                ++numMin;
            } else if (details.getOldestUpdate(UpdateScope.MAJOR) != null) {
                ++numMaj;
            } else {
                ++numCur;
            }
            if (!pluginDetails.isDependencyUpdateAvailable()) continue;
            ++numDep;
        }
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderSuccessIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numUpToDate"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numCur));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerVersionAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numAny));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerIncrementalAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numInc));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerMinorAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numMin));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerMajorAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numMaj));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerDependenciesAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numDep));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
    }

    private void renderSummaryTable(String titleKey, Map<Plugin, PluginUpdatesDetails> contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.sink.table();
            this.renderSummaryTableHeader();
            for (Map.Entry<Plugin, PluginUpdatesDetails> entry : contents.entrySet()) {
                this.renderPluginSummary(entry.getKey(), entry.getValue());
            }
            this.renderSummaryTableHeader();
            this.sink.table_();
        }
        this.sink.section2_();
    }

    private void renderSummaryTableHeader() {
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.groupId"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.artifactId"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextIncremental"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextMinor"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextMajor"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.dependencyStatus"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    private void renderPluginSummary(Plugin plugin, PluginUpdatesDetails details) {
        this.sink.tableRow();
        this.sink.tableCell();
        if (!details.isUpdateAvailable()) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(plugin.getGroupId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(plugin.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableCell();
        if (!details.isArtifactUpdateAvailable()) {
            this.safeBold();
        }
        this.sink.text(plugin.getVersion());
        if (!details.isArtifactUpdateAvailable()) {
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getArtifactVersions().getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
            this.safeBold();
            this.sink.text(details.getArtifactVersions().getOldestUpdate(UpdateScope.SUBINCREMENTAL).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getArtifactVersions().getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
            this.safeBold();
            this.sink.text(details.getArtifactVersions().getOldestUpdate(UpdateScope.INCREMENTAL).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getArtifactVersions().getOldestUpdate(UpdateScope.MINOR) != null) {
            this.safeBold();
            this.sink.text(details.getArtifactVersions().getOldestUpdate(UpdateScope.MINOR).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getArtifactVersions().getOldestUpdate(UpdateScope.MAJOR) != null) {
            this.safeBold();
            this.sink.text(details.getArtifactVersions().getOldestUpdate(UpdateScope.MAJOR).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.isDependencyUpdateAvailable()) {
            this.renderWarningIcon();
        } else {
            this.renderSuccessIcon();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderPluginDetail(Plugin plugin, PluginUpdatesDetails details) {
        SinkEventAttributeSet headerAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"20%");
        SinkEventAttributeSet cellAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"80%");
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(MessageFormat.format(this.getText("report.plugin"), ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId())));
        this.sink.sectionTitle2_();
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        ArtifactVersion[] versions = details.getArtifactVersions().getAllUpdates(UpdateScope.ANY);
        if (details.getArtifactVersions().getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (details.getArtifactVersions().getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (details.getArtifactVersions().getOldestUpdate(UpdateScope.MINOR) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (details.getArtifactVersions().getOldestUpdate(UpdateScope.MAJOR) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.groupId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(plugin.getGroupId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.artifactId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(plugin.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(plugin.getVersion());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (versions.length > 0) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.updateVersions"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            for (int i = 0; i < versions.length; ++i) {
                boolean bold;
                if (i > 0) {
                    this.sink.lineBreak();
                }
                boolean bl = bold = this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.SUBINCREMENTAL)) || this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.INCREMENTAL)) || this.equals(versions[i], details.getArtifactVersions().getNewestUpdate(UpdateScope.INCREMENTAL)) || this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.MINOR)) || this.equals(versions[i], details.getArtifactVersions().getNewestUpdate(UpdateScope.MINOR)) || this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.MAJOR)) || this.equals(versions[i], details.getArtifactVersions().getNewestUpdate(UpdateScope.MAJOR));
                if (bold) {
                    this.safeBold();
                }
                this.sink.text(versions[i].toString());
                if (!bold) continue;
                this.safeBold_();
                this.sink.nonBreakingSpace();
                this.safeItalic();
                if (this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.SUBINCREMENTAL))) {
                    this.sink.text(this.getText("report.nextVersion"));
                } else if (this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.INCREMENTAL))) {
                    this.sink.text(this.getText("report.nextIncremental"));
                } else if (this.equals(versions[i], details.getArtifactVersions().getNewestUpdate(UpdateScope.INCREMENTAL))) {
                    this.sink.text(this.getText("report.latestIncremental"));
                } else if (this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.MINOR))) {
                    this.sink.text(this.getText("report.nextMinor"));
                } else if (this.equals(versions[i], details.getArtifactVersions().getNewestUpdate(UpdateScope.MINOR))) {
                    this.sink.text(this.getText("report.latestMinor"));
                } else if (this.equals(versions[i], details.getArtifactVersions().getOldestUpdate(UpdateScope.MAJOR))) {
                    this.sink.text(this.getText("report.nextMajor"));
                } else if (this.equals(versions[i], details.getArtifactVersions().getNewestUpdate(UpdateScope.MAJOR))) {
                    this.sink.text(this.getText("report.latestMajor"));
                }
                this.safeItalic_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRows_();
        this.sink.table_();
        if (!details.getDependencyVersions().isEmpty()) {
            this.sink.section3();
            this.sink.sectionTitle3();
            this.sink.text(MessageFormat.format(this.getText("report.pluginDependencies"), ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId())));
            this.sink.sectionTitle3_();
            this.renderDependencySummaryTable(details.getDependencyVersions(), false, true, true);
            this.sink.section3_();
            for (Map.Entry entry : details.getDependencyVersions().entrySet()) {
                this.renderDependencyDetail((Dependency)entry.getKey(), (ArtifactVersions)entry.getValue());
            }
        }
        this.sink.section2_();
    }

    private void renderDependencyDetail(Dependency dependency, ArtifactVersions details) {
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.text(MessageFormat.format(this.getText("report.pluginDependency"), ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId())));
        this.sink.sectionTitle3_();
        this.renderDependencyDetailTable(dependency, details, false, true, true);
        this.sink.section3_();
    }
}

