/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.utils.DependencyBuilder;

public class DependencyUpdatesLoggingHelper {
    private static boolean dependencyVersionLocalToProject(MavenProject project, Dependency dependency) {
        return dependency.getLocation((Object)DependencyBuilder.Location.VERSION.toString()).getSource().getModelId().equals(project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion());
    }

    public static DependencyUpdatesResult getDependencyUpdates(MavenProject project, Map<Dependency, ArtifactVersions> updates, boolean allowSnapshots, Optional<Segment> unchangedSegment, int maxLineWith, boolean displayManagedBy) {
        final ArrayList<String> withUpdates = new ArrayList<String>();
        final ArrayList usingCurrent = new ArrayList();
        for (Map.Entry<Dependency, ArtifactVersions> entry : updates.entrySet()) {
            ArrayList<String> t;
            Optional<ArtifactVersion> latestVersion;
            String currentVersion;
            Dependency dep = entry.getKey();
            ArtifactVersions versions = entry.getValue();
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.getCurrentVersion() != null) {
                currentVersion = versions.getCurrentVersion() + (!displayManagedBy || DependencyUpdatesLoggingHelper.dependencyVersionLocalToProject(project, dep) ? "" : " (managed by " + dep.getLocation((Object)DependencyBuilder.Location.VERSION.toString()).getSource().getModelId() + ")");
                try {
                    latestVersion = versions.getNewestVersion(currentVersion, unchangedSegment, allowSnapshots, false);
                }
                catch (InvalidSegmentException e) {
                    latestVersion = Optional.empty();
                }
            } else {
                Restriction newVersionRestriction;
                currentVersion = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion actualVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), allowSnapshots);
                try {
                    Restriction segmentRestriction = versions.restrictionForUnchangedSegment(actualVersion, unchangedSegment, false);
                    newVersionRestriction = new Restriction(actualVersion, false, segmentRestriction.getUpperBound(), segmentRestriction.isUpperBoundInclusive());
                }
                catch (InvalidSegmentException e) {
                    throw new RuntimeException(e);
                }
                latestVersion = Optional.of(newVersionRestriction).map(restriction -> versions.getNewestVersion(restriction, allowSnapshots));
            }
            String right = " " + latestVersion.map(v -> currentVersion + " -> " + v).orElse(currentVersion);
            ArrayList<String> arrayList = t = latestVersion.isPresent() ? withUpdates : usingCurrent;
            if (right.length() + left.length() + 3 > maxLineWith) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)maxLineWith));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(maxLineWith - right.length()), (String)".") + right);
        }
        return new DependencyUpdatesResult(){

            @Override
            public List<String> getUsingLatest() {
                return usingCurrent;
            }

            @Override
            public List<String> getWithUpdates() {
                return withUpdates;
            }
        };
    }

    public static interface DependencyUpdatesResult {
        public List<String> getUsingLatest();

        public List<String> getWithUpdates();
    }
}

