/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractVersionsReport<T>
extends AbstractMavenReport {
    protected I18N i18n;
    protected RepositorySystem repositorySystem;
    @Parameter(property="versions.skip")
    private boolean skip;
    protected org.eclipse.aether.RepositorySystem aetherRepositorySystem;
    @Parameter(property="maven.version.rules.serverId", defaultValue="serverId")
    private String serverId;
    @Parameter(property="maven.version.rules")
    private String rulesUri;
    @Parameter(property="comparisonMethod")
    protected String comparisonMethod;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    private VersionsHelper helper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter
    protected RuleSet ruleSet;
    @Parameter(property="maven.version.ignore")
    protected Set<String> ignoredVersions;
    protected ReportRendererFactory rendererFactory;
    protected Map<String, Wagon> wagonMap;

    protected AbstractVersionsReport(I18N i18n, RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        this.i18n = i18n;
        this.repositorySystem = repositorySystem;
        this.aetherRepositorySystem = aetherRepositorySystem;
        this.wagonMap = wagonMap;
        this.rendererFactory = rendererFactory;
    }

    public VersionsHelper getHelper() throws MavenReportException {
        if (this.helper == null) {
            try {
                this.helper = new DefaultVersionsHelper.Builder().withRepositorySystem(this.repositorySystem).withAetherRepositorySystem(this.aetherRepositorySystem).withWagonMap(this.wagonMap).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions(this.ignoredVersions).withLog(this.getLog()).withMavenSession(this.session).withMojoExecution(this.mojoExecution).build();
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.helper;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.skip) {
            try {
                this.doGenerateReport(locale, this.getSink());
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    protected abstract void doGenerateReport(Locale var1, Sink var2) throws MavenReportException, MojoExecutionException;

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getText(locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.getText(locale, "report.title");
    }

    public String getText(Locale locale, String key) {
        return this.i18n.getString(this.getOutputName(), locale, key);
    }

    public Boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    public String getComparisonMethod() {
        return this.comparisonMethod;
    }

    public I18N getI18n() {
        return this.i18n;
    }
}

