/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.mojo.versions.api.PomHelper;

@Mojo(name="revert", threadSafe=true)
public class RevertMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="processFromLocalAggregationRoot", defaultValue="true")
    private boolean processFromLocalAggregationRoot;
    protected MavenProjectBuilder projectBuilder;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;

    @Inject
    protected RevertMojo(MavenProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject projectToProcess = !this.processFromLocalAggregationRoot ? PomHelper.getLocalRoot(this.projectBuilder, this.project, this.localRepository, null, this.getLog()) : this.project;
        this.getLog().info((CharSequence)("Local aggregation root: " + projectToProcess.getBasedir()));
        Set<String> reactor = PomHelper.getAllChildModules(projectToProcess, this.getLog());
        reactor.add(".");
        reactor.forEach(entry -> {
            Path pomFile = projectToProcess.getBasedir().toPath().resolve((String)entry).resolve("pom.xml").normalize();
            this.getLog().debug((CharSequence)("Processing:" + pomFile));
            Path backupFile = Paths.get(pomFile + ".versionsBackup", new String[0]);
            if (Files.exists(backupFile, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Restoring " + pomFile + " from " + backupFile));
                try {
                    Files.copy(backupFile, pomFile, StandardCopyOption.REPLACE_EXISTING);
                    try {
                        Files.delete(backupFile);
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Error deleting " + backupFile));
                    }
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Error copying " + backupFile + " onto " + pomFile));
                }
            }
        });
    }
}

