/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="force-releases", threadSafe=true)
public class ForceReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    @Inject
    public ForceReleasesMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useReleases(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useReleases(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useReleases(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (!versionMatcher.matches()) continue;
            String releaseVersion = versionMatcher.group(1);
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Looking for a release of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            if (versions.containsVersion(releaseVersion)) {
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, releaseVersion, this.getProject().getModel())) continue;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + releaseVersion));
                continue;
            }
            ArtifactVersion[] v = versions.getVersions(false);
            if (v.length == 0) {
                this.getLog().info((CharSequence)("No release of " + this.toString(dep) + " to force."));
                continue;
            }
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, v[v.length - 1].toString(), this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Reverted " + this.toString(dep) + " to version " + v[v.length - 1].toString()));
        }
    }
}

