/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.model.io.xpp3.RuleXpp3Reader;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.mojo.versions.utils.WagonUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultVersionsHelper
implements VersionsHelper {
    private static final String CLASSPATH_PROTOCOL = "classpath";
    private static final String TYPE_EXACT = "exact";
    private static final String TYPE_REGEX = "regex";
    private static final int LOOKUP_PARALLEL_THREADS = 5;
    private final RuleSet ruleSet;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteArtifactRepositories;
    private final List<ArtifactRepository> remotePluginRepositories;
    private final RepositorySystem repositorySystem;
    private final Log log;
    private final MavenSession mavenSession;
    private final ArtifactResolver artifactResolver;
    private final MojoExecution mojoExecution;
    private final Map<String, Rule> artifactBestFitRule = new HashMap<String, Rule>();

    public DefaultVersionsHelper(RepositorySystem repositorySystem, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, List<ArtifactRepository> remoteArtifactRepositories, List<ArtifactRepository> remotePluginRepositories, ArtifactRepository localRepository, WagonManager wagonManager, Settings settings, String serverId, String rulesUri, Log log, MavenSession mavenSession, MojoExecution mojoExecution) throws MojoExecutionException {
        this.repositorySystem = repositorySystem;
        this.artifactResolver = artifactResolver;
        this.mavenSession = mavenSession;
        this.mojoExecution = mojoExecution;
        this.ruleSet = DefaultVersionsHelper.loadRuleSet(serverId, settings, wagonManager, rulesUri, log);
        this.artifactMetadataSource = artifactMetadataSource;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.remotePluginRepositories = remotePluginRepositories;
        this.log = log;
    }

    /*
     * Loose catch block
     */
    @Deprecated
    private static RuleSet getRuleSet(Wagon wagon, String remoteURI) throws IOException, AuthorizationException, TransferFailedException, ResourceDoesNotExistException {
        File tempFile = File.createTempFile("ruleset", ".xml");
        try {
            wagon.get(remoteURI, tempFile);
            try (FileInputStream is = new FileInputStream(tempFile);){
                RuleSet ruleSet = DefaultVersionsHelper.readRulesFromStream(is);
                return ruleSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RuleSet readRulesFromStream(InputStream stream) throws IOException {
        RuleXpp3Reader reader = new RuleXpp3Reader();
        try (BufferedInputStream bis = new BufferedInputStream(stream);){
            RuleSet ruleSet = reader.read(bis);
            return ruleSet;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }

    private static RuleSet loadRuleSet(String serverId, Settings settings, WagonManager wagonManager, String rulesUri, Log logger) throws MojoExecutionException {
        RuleSet ruleSet = new RuleSet();
        boolean rulesUriGiven = DefaultVersionsHelper.isRulesUriNotBlank(rulesUri);
        if (rulesUriGiven) {
            RuleSet loadedRules = DefaultVersionsHelper.isClasspathUri(rulesUri) ? DefaultVersionsHelper.getRulesFromClasspath(rulesUri, logger) : DefaultVersionsHelper.getRulesViaWagon(rulesUri, logger, serverId, serverId, wagonManager, settings);
            ruleSet.setIgnoreVersions(loadedRules.getIgnoreVersions());
            ruleSet.setRules(loadedRules.getRules());
        }
        return ruleSet;
    }

    private static RuleSet getRulesFromClasspath(String uri, Log logger) throws MojoExecutionException {
        logger.debug((CharSequence)("Going to load rules from \"" + uri + "\""));
        String choppedUrl = uri.substring(CLASSPATH_PROTOCOL.length() + 3);
        URL url = DefaultVersionsHelper.class.getResource(choppedUrl);
        if (null == url) {
            String message = "Resource \"" + uri + "\" not found in classpath.";
            throw new MojoExecutionException(message);
        }
        try {
            RuleSet rules = DefaultVersionsHelper.readRulesFromStream(url.openStream());
            logger.debug((CharSequence)("Loaded rules from \"" + uri + "\" successfully"));
            return rules;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load specified rules from " + uri, (Exception)e);
        }
    }

    private static boolean isRulesUriNotBlank(String rulesUri) {
        return rulesUri != null && rulesUri.trim().length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuleSet getRulesViaWagon(String rulesUri, Log logger, String serverId, String id, WagonManager wagonManager, Settings settings) throws MojoExecutionException {
        RuleSet loadedRules = new RuleSet();
        int split = rulesUri.lastIndexOf(47);
        String baseUri = rulesUri;
        String fileUri = "";
        if (split != -1) {
            baseUri = rulesUri.substring(0, split) + '/';
            fileUri = split + 1 < rulesUri.length() ? rulesUri.substring(split + 1) : "";
        }
        try {
            Wagon wagon = WagonUtils.createWagon(serverId, baseUri, wagonManager, settings, logger);
            try {
                logger.debug((CharSequence)("Trying to load ruleset from file \"" + fileUri + "\" in " + baseUri));
                loadedRules = DefaultVersionsHelper.getRuleSet(wagon, fileUri);
            }
            finally {
                logger.debug((CharSequence)"Rule set loaded");
                if (wagon != null) {
                    try {
                        wagon.disconnect();
                    }
                    catch (ConnectionException e) {
                        logger.warn((CharSequence)"Could not disconnect wagon!", (Throwable)e);
                    }
                }
            }
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Could not transfer rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Authorization failure trying to load rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Authentication failure trying to load rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol for " + rulesUri, (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Could not establish connection to " + rulesUri, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)e);
        }
        return loadedRules;
    }

    static boolean isClasspathUri(String uri) {
        return uri != null && uri.startsWith("classpath:");
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        List<ArtifactRepository> remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, remoteRepositories);
        List<IgnoreVersion> ignoredVersions = this.getIgnoredVersions(artifact);
        if (!ignoredVersions.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found ignored versions: " + this.showIgnoredVersions(ignoredVersions)));
            }
            Iterator i = versions.iterator();
            block0: while (i.hasNext()) {
                String version = ((ArtifactVersion)i.next()).toString();
                for (IgnoreVersion ignoreVersion : ignoredVersions) {
                    if (TYPE_REGEX.equals(ignoreVersion.getType())) {
                        Pattern p = Pattern.compile(ignoreVersion.getVersion());
                        if (!p.matcher(version).matches()) continue;
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Version " + version + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + ignoreVersion));
                        }
                        i.remove();
                        continue block0;
                    }
                    if (!TYPE_EXACT.equals(ignoreVersion.getType()) || !version.equals(ignoreVersion.getVersion())) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Version " + version + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + ignoreVersion));
                    }
                    i.remove();
                    continue block0;
                }
            }
        }
        return new ArtifactVersions(artifact, versions, this.getVersionComparator(artifact));
    }

    private List<IgnoreVersion> getIgnoredVersions(Artifact artifact) {
        ArrayList<IgnoreVersion> ret = new ArrayList<IgnoreVersion>();
        for (IgnoreVersion ignoreVersion : this.ruleSet.getIgnoreVersions()) {
            if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for global ignoreVersion[" + ignoreVersion + "] is not valid. Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                continue;
            }
            ret.add(ignoreVersion);
        }
        Rule rule = this.getBestFitRule(artifact.getGroupId(), artifact.getArtifactId());
        if (rule != null) {
            for (IgnoreVersion ignoreVersion : rule.getIgnoreVersions()) {
                if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                    this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for " + rule + " is not valid. Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                    continue;
                }
                ret.add(ignoreVersion);
            }
        }
        return ret;
    }

    private String showIgnoredVersions(List<IgnoreVersion> ignoredVersions) {
        StringBuilder buf = new StringBuilder();
        Iterator<IgnoreVersion> iterator = ignoredVersions.iterator();
        while (iterator.hasNext()) {
            IgnoreVersion ignoreVersion = iterator.next();
            buf.append(ignoreVersion);
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public void resolveArtifact(Artifact artifact, boolean usePluginRepositories) throws ArtifactResolutionException, ArtifactNotFoundException {
        List<ArtifactRepository> remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        this.artifactResolver.resolve(artifact, remoteRepositories, this.localRepository);
    }

    @Override
    public VersionComparator getVersionComparator(Artifact artifact) {
        return this.getVersionComparator(artifact.getGroupId(), artifact.getArtifactId());
    }

    @Override
    public VersionComparator getVersionComparator(String groupId, String artifactId) {
        Rule rule = this.getBestFitRule(groupId, artifactId);
        String comparisonMethod = rule == null ? this.ruleSet.getComparisonMethod() : rule.getComparisonMethod();
        return VersionComparators.getVersionComparator(comparisonMethod);
    }

    protected Rule getBestFitRule(String groupId, String artifactId) {
        String groupArtifactId = groupId + ':' + artifactId;
        if (this.artifactBestFitRule.containsKey(groupArtifactId)) {
            return this.artifactBestFitRule.get(groupArtifactId);
        }
        Rule bestFit = null;
        List<Rule> rules = this.ruleSet.getRules();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        for (Rule rule : rules) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getGroupId(), groupId)) || DefaultVersionsHelper.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getArtifactId(), artifactId)) || DefaultVersionsHelper.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            bestFit = rule;
        }
        this.artifactBestFitRule.put(groupArtifactId, bestFit);
        return bestFit;
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, String version) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(groupId);
        plugin.setArtifactId(artifactId);
        plugin.setVersion(StringUtils.isNotBlank((String)version) ? version : "[0,]");
        return this.repositorySystem.createPluginArtifact(plugin);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope, boolean optional) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        dependency.setScope(scope);
        dependency.setOptional(optional);
        dependency.setVersion(StringUtils.isNotBlank((String)version) ? version : "[0,]");
        return this.repositorySystem.createDependencyArtifact(dependency);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope) {
        return this.createDependencyArtifact(groupId, artifactId, version, type, classifier, scope, false);
    }

    @Override
    public Artifact createDependencyArtifact(Dependency dependency) {
        if (StringUtils.isBlank((String)dependency.getVersion())) {
            dependency = dependency.clone();
            dependency.setVersion("[,0]");
        }
        return this.repositorySystem.createDependencyArtifact(dependency);
    }

    @Override
    public Set<Artifact> extractArtifacts(Collection<MavenProject> mavenProjects) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (MavenProject project : mavenProjects) {
            result.add(project.getArtifact());
        }
        return result;
    }

    @Override
    public ArtifactVersion createArtifactVersion(String version) {
        return new DefaultArtifactVersion(version);
    }

    @Override
    public ArtifactVersions lookupArtifactUpdates(Artifact artifact, boolean allowSnapshots, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        ArtifactVersions artifactVersions = this.lookupArtifactVersions(artifact, usePluginRepositories);
        artifactVersions.setIncludeSnapshots(allowSnapshots);
        return artifactVersions;
    }

    @Override
    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Set<Dependency> dependencies, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        ArrayList<DependencyLookup> requestsForDetails = new ArrayList<DependencyLookup>(dependencies.size());
        for (Dependency dependency : dependencies) {
            requestsForDetails.add(new DependencyLookup(dependency, usePluginRepositories));
        }
        TreeMap<Dependency, ArtifactVersions> dependencyUpdates = new TreeMap<Dependency, ArtifactVersions>(new DependencyComparator());
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List responseForDetails = executor.invokeAll(requestsForDetails);
            for (Future details : responseForDetails) {
                DependencyArtifactVersions dav = (DependencyArtifactVersions)details.get();
                dependencyUpdates.put(dav.getDependency(), dav.getArtifactVersions());
            }
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new ArtifactMetadataRetrievalException("Unable to acquire metadata for dependencies " + dependencies + ": " + ie.getMessage(), (Throwable)ie, null);
        }
        finally {
            executor.shutdownNow();
        }
        return dependencyUpdates;
    }

    @Override
    public ArtifactVersions lookupDependencyUpdates(Dependency dependency, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        this.getLog().debug((CharSequence)("Checking " + ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId()) + " for updates newer than " + dependency.getVersion()));
        return this.lookupArtifactVersions(this.createDependencyArtifact(dependency), usePluginRepositories);
    }

    @Override
    public Map<Plugin, PluginUpdatesDetails> lookupPluginsUpdates(Set<Plugin> plugins, boolean allowSnapshots) throws ArtifactMetadataRetrievalException {
        ArrayList<PluginLookup> requestsForDetails = new ArrayList<PluginLookup>(plugins.size());
        for (Plugin plugin : plugins) {
            requestsForDetails.add(new PluginLookup(plugin, allowSnapshots));
        }
        TreeMap<Object, PluginUpdatesDetails> pluginUpdates = new TreeMap<Object, PluginUpdatesDetails>(new PluginComparator());
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List responseForDetails = executor.invokeAll(requestsForDetails);
            for (Future details : responseForDetails) {
                PluginPluginUpdatesDetails pud = (PluginPluginUpdatesDetails)details.get();
                pluginUpdates.put(pud.getPlugin(), pud.getPluginUpdatesDetails());
            }
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new ArtifactMetadataRetrievalException("Unable to acquire metadata for plugins " + plugins + ": " + ie.getMessage(), (Throwable)ie, null);
        }
        finally {
            executor.shutdownNow();
        }
        return pluginUpdates;
    }

    @Override
    public PluginUpdatesDetails lookupPluginUpdates(Plugin plugin, boolean allowSnapshots) throws ArtifactMetadataRetrievalException {
        String version = plugin.getVersion();
        version = version == null ? "LATEST" : version;
        this.getLog().debug((CharSequence)("Checking " + ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId()) + " for updates newer than " + version));
        boolean includeSnapshots = allowSnapshots;
        ArtifactVersions pluginArtifactVersions = this.lookupArtifactVersions(this.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), version), true);
        TreeSet<Dependency> pluginDependencies = new TreeSet<Dependency>(new DependencyComparator());
        if (plugin.getDependencies() != null) {
            pluginDependencies.addAll(plugin.getDependencies());
        }
        Map<Dependency, ArtifactVersions> pluginDependencyDetails = this.lookupDependenciesUpdates(pluginDependencies, false);
        return new PluginUpdatesDetails(pluginArtifactVersions, pluginDependencyDetails, includeSnapshots);
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator(MavenProject project) {
        return new VersionsExpressionEvaluator(this.mavenSession, this.mojoExecution);
    }

    @Override
    public Map<Property, PropertyVersions> getVersionPropertiesMap(MavenProject project, Property[] propertyDefinitions, String includeProperties, String excludeProperties, boolean autoLinkItems) throws MojoExecutionException {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (propertyDefinitions != null) {
            for (Property propertyDefinition : propertyDefinitions) {
                properties.put(propertyDefinition.getName(), propertyDefinition);
            }
        }
        HashMap<String, PropertyVersionsBuilder> builders = new HashMap<String, PropertyVersionsBuilder>();
        if (autoLinkItems) {
            PropertyVersionsBuilder[] propertyVersionsBuilders;
            try {
                propertyVersionsBuilders = PomHelper.getPropertyVersionsBuilders(this, project);
            }
            catch (IOException | ExpressionEvaluationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            for (PropertyVersionsBuilder propertyVersionsBuilder : propertyVersionsBuilders) {
                String name = propertyVersionsBuilder.getName();
                builders.put(name, propertyVersionsBuilder);
                if (properties.containsKey(name)) continue;
                Property value = new Property(name);
                this.getLog().debug((CharSequence)("Property ${" + name + "}: Adding inferred version range of " + propertyVersionsBuilder.getVersionRange()));
                value.setVersion(propertyVersionsBuilder.getVersionRange());
                properties.put(name, value);
            }
        }
        List<String> includePropertiesList = this.getSplittedProperties(includeProperties);
        List<String> excludePropertiesList = this.getSplittedProperties(excludeProperties);
        this.getLog().debug((CharSequence)"Searching for properties associated with builders");
        Iterator i = properties.values().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("includePropertiesList:" + includePropertiesList + " property: " + property.getName()));
            this.getLog().debug((CharSequence)("excludePropertiesList:" + excludePropertiesList + " property: " + property.getName()));
            if (!includePropertiesList.isEmpty() && !includePropertiesList.contains(property.getName())) {
                this.getLog().debug((CharSequence)("Skipping property ${" + property.getName() + "}"));
                i.remove();
                continue;
            }
            if (excludePropertiesList.isEmpty() || !excludePropertiesList.contains(property.getName())) continue;
            this.getLog().debug((CharSequence)("Ignoring property ${" + property.getName() + "}"));
            i.remove();
        }
        i = properties.values().iterator();
        LinkedHashMap<Property, PropertyVersions> propertyVersions = new LinkedHashMap<Property, PropertyVersions>(properties.size());
        while (i.hasNext()) {
            Dependency[] dependencies;
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}"));
            PropertyVersionsBuilder builder = (PropertyVersionsBuilder)builders.get(property.getName());
            if (builder == null || !builder.isAssociated()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Looks like this property is not associated with any dependency..."));
                builder = new PropertyVersionsBuilder(null, property.getName(), this);
            }
            if (!property.isAutoLinkDependencies()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Removing any autoLinkDependencies"));
                builder.clearAssociations();
            }
            if ((dependencies = property.getDependencies()) != null) {
                for (Dependency dependency : dependencies) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding association to " + dependency));
                    builder.addAssociation(this.createDependencyArtifact(dependency), false);
                }
            }
            try {
                PropertyVersions versions = builder.newPropertyVersions();
                if (property.isAutoLinkDependencies() && StringUtils.isEmpty((String)property.getVersion()) && !StringUtils.isEmpty((String)builder.getVersionRange())) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding inferred version range of " + builder.getVersionRange()));
                    property.setVersion(builder.getVersionRange());
                }
                versions.setCurrentVersion(project.getProperties().getProperty(property.getName()));
                propertyVersions.put(property, versions);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return propertyVersions;
    }

    private List<String> getSplittedProperties(String commaSeparatedProperties) {
        List<String> propertiesList = Collections.emptyList();
        if (StringUtils.isNotEmpty((String)commaSeparatedProperties)) {
            String[] splittedProps = StringUtils.split((String)commaSeparatedProperties, (String)",");
            propertiesList = Arrays.asList(StringUtils.stripAll((String[])splittedProps));
        }
        return propertiesList;
    }

    private class PluginLookup
    implements Callable<PluginPluginUpdatesDetails> {
        private final Plugin plugin;
        private final boolean allowSnapshots;

        PluginLookup(Plugin plugin, Boolean allowSnapshots) {
            this.plugin = plugin;
            this.allowSnapshots = allowSnapshots;
        }

        @Override
        public PluginPluginUpdatesDetails call() throws Exception {
            return new PluginPluginUpdatesDetails(this.plugin, DefaultVersionsHelper.this.lookupPluginUpdates(this.plugin, this.allowSnapshots));
        }
    }

    private class DependencyLookup
    implements Callable<DependencyArtifactVersions> {
        private final Dependency dependency;
        private final boolean usePluginRepositories;

        DependencyLookup(Dependency dependency, boolean usePluginRepositories) {
            this.dependency = dependency;
            this.usePluginRepositories = usePluginRepositories;
        }

        @Override
        public DependencyArtifactVersions call() throws Exception {
            return new DependencyArtifactVersions(this.dependency, DefaultVersionsHelper.this.lookupDependencyUpdates(this.dependency, this.usePluginRepositories));
        }
    }

    private static class PluginPluginUpdatesDetails {
        private final Plugin plugin;
        private final PluginUpdatesDetails pluginUpdatesDetails;

        PluginPluginUpdatesDetails(Plugin plugin, PluginUpdatesDetails pluginUpdatesDetails) {
            this.plugin = plugin;
            this.pluginUpdatesDetails = pluginUpdatesDetails;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public PluginUpdatesDetails getPluginUpdatesDetails() {
            return this.pluginUpdatesDetails;
        }
    }

    private static class DependencyArtifactVersions {
        private final Dependency dependency;
        private final ArtifactVersions artifactVersions;

        DependencyArtifactVersions(Dependency dependency, ArtifactVersions artifactVersions) {
            this.dependency = dependency;
            this.artifactVersions = artifactVersions;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public ArtifactVersions getArtifactVersions() {
            return this.artifactVersions;
        }
    }
}

