/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomHelper {
    public static final String APACHE_MAVEN_PLUGINS_GROUPID = "org.apache.maven.plugins";

    public static Model getRawModel(MavenProject project) throws IOException {
        return PomHelper.getRawModel(project.getFile());
    }

    public static Model getRawModel(File moduleProjectFile) throws IOException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(moduleProjectFile);
            bufferedReader = new BufferedReader(fileReader);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)bufferedReader);
            return model;
        }
        catch (XmlPullParserException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    public static Model getRawModel(ModifiedPomXMLEventReader modifiedPomXMLEventReader) throws IOException {
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(modifiedPomXMLEventReader.asStringBuilder().toString());
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)stringReader);
            return model;
        }
        catch (XmlPullParserException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (stringReader != null) {
                stringReader.close();
            }
        }
    }

    public static boolean setPropertyVersion(ModifiedPomXMLEventReader pom, String profileId, String property, String value) throws XMLStreamException {
        Pattern projectProfileId;
        Pattern matchScopeRegex;
        Pattern propertyRegex;
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        if (profileId == null) {
            propertyRegex = Pattern.compile("/project/properties/" + RegexUtils.quote(property));
            matchScopeRegex = Pattern.compile("/project/properties");
            projectProfileId = null;
        } else {
            propertyRegex = Pattern.compile("/project/profiles/profile/properties/" + RegexUtils.quote(property));
            matchScopeRegex = Pattern.compile("/project/profiles/profile");
            projectProfileId = Pattern.compile("/project/profiles/profile/id");
        }
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (propertyRegex.matcher(path).matches()) {
                    pom.mark(0);
                } else if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = profileId == null;
                    pom.clearMark(0);
                    pom.clearMark(1);
                } else if (profileId != null && projectProfileId.matcher(path).matches()) {
                    String candidateId = pom.getElementText();
                    path = (String)stack.pop();
                    inMatchScope = profileId.trim().equals(candidateId.trim());
                }
            }
            if (!event.isEndElement()) continue;
            if (propertyRegex.matcher(path).matches()) {
                pom.mark(1);
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static boolean setProjectVersion(ModifiedPomXMLEventReader pom, String value) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean madeReplacement = false;
        Pattern matchScopeRegex = Pattern.compile("/project/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static String getProjectVersion(ModifiedPomXMLEventReader pom) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        Pattern matchScopeRegex = Pattern.compile("/project/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    return pom.getBetween(0, 1).trim();
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return null;
    }

    public static boolean setProjectParentVersion(ModifiedPomXMLEventReader pom, String value) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean madeReplacement = false;
        Pattern matchScopeRegex = Pattern.compile("/project/parent/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static Artifact getProjectParent(ModifiedPomXMLEventReader pom, VersionsHelper helper) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        Pattern matchScopeRegex = Pattern.compile("/project/parent((/groupId)|(/artifactId)|(/version))");
        String groupId = null;
        String artifactId = null;
        String version = null;
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        groupId = pom.getElementText().trim();
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        artifactId = pom.getElementText().trim();
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        version = pom.getElementText().trim();
                        path = (String)stack.pop();
                    }
                }
            }
            if (!event.isEndElement()) continue;
            path = (String)stack.pop();
        }
        if (groupId == null || artifactId == null || version == null) {
            return null;
        }
        return helper.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion(version), "pom", null, null, false);
    }

    public static boolean setDependencyVersion(ModifiedPomXMLEventReader pom, String groupId, String artifactId, String oldVersion, String newVersion) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        HashSet<String> implicitPaths = new HashSet<String>(Arrays.asList("/project/parent/groupId", "/project/parent/artifactId", "/project/parent/version", "/project/groupId", "/project/artifactId", "/project/version"));
        HashMap<String, String> implicitProperties = new HashMap<String, String>();
        pom.rewind();
        while (pom.hasNext()) {
            while (pom.hasNext()) {
                XMLEvent event = pom.nextEvent();
                if (event.isStartElement()) {
                    stack.push(path);
                    String elementName = event.asStartElement().getName().getLocalPart();
                    path = path + "/" + (String)elementName;
                    if (implicitPaths.contains(path)) {
                        String elementText = pom.getElementText().trim();
                        implicitProperties.put(path.substring(1).replace('/', '.'), elementText);
                        path = (String)stack.pop();
                    }
                }
                if (!event.isEndElement()) continue;
                path = (String)stack.pop();
            }
        }
        boolean modified = true;
        block4: while (modified) {
            modified = false;
            for (Map.Entry entry : implicitProperties.entrySet()) {
                String child;
                if (!((String)entry.getKey()).contains(".parent") || implicitProperties.containsKey(child = ((String)entry.getKey()).replace(".parent", ""))) continue;
                implicitProperties.put(child, (String)entry.getValue());
                modified = true;
                continue block4;
            }
        }
        System.out.println("Props: " + implicitProperties);
        stack = new Stack();
        path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        Pattern matchScopeRegex = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency");
        Pattern matchTargetRegex = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency((/groupId)|(/artifactId)|(/version))");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = groupId.equals(PomHelper.evaluate(pom.getElementText().trim(), implicitProperties));
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(PomHelper.evaluate(pom.getElementText().trim(), implicitProperties));
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        pom.mark(0);
                    }
                }
            }
            if (!event.isEndElement()) continue;
            if (matchTargetRegex.matcher(path).matches() && "version".equals(event.asEndElement().getName().getLocalPart())) {
                pom.mark(1);
                String compressedPomVersion = StringUtils.deleteWhitespace((String)pom.getBetween(0, 1).trim());
                String compressedOldVersion = StringUtils.deleteWhitespace((String)oldVersion);
                try {
                    haveOldVersion = PomHelper.isVersionOverlap(compressedOldVersion, compressedPomVersion);
                }
                catch (InvalidVersionSpecificationException e) {
                    haveOldVersion = compressedOldVersion.equals(compressedPomVersion);
                }
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1) && haveGroupId && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween(0, 1, newVersion);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
                haveArtifactId = false;
                haveGroupId = false;
                haveOldVersion = false;
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static String evaluate(String expr, Map<String, String> properties) {
        if (expr == null) {
            return null;
        }
        String expression = PomHelper.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : retVal + PomHelper.evaluate(expr.substring(index, lastIndex + 1), properties);
                retVal = retVal + PomHelper.evaluate(expr.substring(lastIndex + 1), properties);
                return retVal;
            }
            if (expression.contains("$$")) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        String value = properties.get(expression);
        if (value != null) {
            int exprStartDelimiter = value.indexOf("${");
            if (exprStartDelimiter >= 0) {
                value = exprStartDelimiter > 0 ? value.substring(0, exprStartDelimiter) + PomHelper.evaluate(value.substring(exprStartDelimiter), properties) : PomHelper.evaluate(value.substring(exprStartDelimiter), properties);
            }
        } else {
            System.out.println("expression: " + expression + " no value ");
        }
        return value == null ? expr : value;
    }

    private static String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public static boolean isVersionOverlap(String leftVersionOrRange, String rightVersionOrRange) throws InvalidVersionSpecificationException {
        VersionRange pomVersionRange = PomHelper.createVersionRange(leftVersionOrRange);
        if (!pomVersionRange.hasRestrictions()) {
            return true;
        }
        VersionRange oldVersionRange = PomHelper.createVersionRange(rightVersionOrRange);
        if (!oldVersionRange.hasRestrictions()) {
            return true;
        }
        VersionRange result = oldVersionRange.restrict(pomVersionRange);
        return result.hasRestrictions();
    }

    private static VersionRange createVersionRange(String versionOrRange) throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)versionOrRange);
        if (versionRange.getRecommendedVersion() != null) {
            versionRange = VersionRange.createFromVersionSpec((String)("[" + versionOrRange + "]"));
        }
        return versionRange;
    }

    public static boolean setPluginVersion(ModifiedPomXMLEventReader pom, String groupId, String artifactId, String oldVersion, String newVersion) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean needGroupId = groupId != null && !APACHE_MAVEN_PLUGINS_GROUPID.equals(groupId);
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        Pattern matchScopeRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Pattern matchTargetRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin((/groupId)|(/artifactId)|(/version))");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = groupId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        pom.mark(0);
                    }
                }
            }
            if (!event.isEndElement()) continue;
            if (matchTargetRegex.matcher(path).matches() && "version".equals(event.asEndElement().getName().getLocalPart())) {
                pom.mark(1);
                try {
                    haveOldVersion = PomHelper.isVersionOverlap(oldVersion, pom.getBetween(0, 1).trim());
                }
                catch (InvalidVersionSpecificationException e) {
                    haveOldVersion = oldVersion.equals(pom.getBetween(0, 1).trim());
                }
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1) && (haveGroupId || !needGroupId) && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween(0, 1, newVersion);
                    madeReplacement = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveArtifactId = false;
                    haveGroupId = false;
                    haveOldVersion = false;
                }
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static PropertyVersionsBuilder[] getPropertyVersionsBuilders(VersionsHelper helper, MavenProject project) throws ExpressionEvaluationException, IOException {
        ExpressionEvaluator expressionEvaluator = helper.getExpressionEvaluator(project);
        Model model = PomHelper.getRawModel(project);
        TreeMap<String, PropertyVersionsBuilder> result = new TreeMap<String, PropertyVersionsBuilder>();
        TreeSet<String> activeProfiles = new TreeSet<String>();
        for (Profile profile : project.getActiveProfiles()) {
            activeProfiles.add(profile.getId());
        }
        for (Profile profile : model.getProfiles()) {
            if (!activeProfiles.contains(profile.getId())) continue;
            PomHelper.addProperties(helper, result, profile.getId(), profile.getProperties());
            if (profile.getDependencyManagement() != null) {
                PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, profile.getDependencyManagement().getDependencies(), false);
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, profile.getDependencies(), false);
            if (profile.getBuild() != null) {
                if (profile.getBuild().getPluginManagement() != null) {
                    PomHelper.addPluginAssociations(helper, expressionEvaluator, result, profile.getBuild().getPluginManagement().getPlugins());
                }
                PomHelper.addPluginAssociations(helper, expressionEvaluator, result, profile.getBuild().getPlugins());
            }
            if (profile.getReporting() == null) continue;
            PomHelper.addReportPluginAssociations(helper, expressionEvaluator, result, profile.getReporting().getPlugins());
        }
        PomHelper.addProperties(helper, result, null, model.getProperties());
        if (model.getDependencyManagement() != null) {
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, model.getDependencyManagement().getDependencies(), false);
        }
        PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, model.getDependencies(), false);
        if (model.getBuild() != null) {
            if (model.getBuild().getPluginManagement() != null) {
                PomHelper.addPluginAssociations(helper, expressionEvaluator, result, model.getBuild().getPluginManagement().getPlugins());
            }
            PomHelper.addPluginAssociations(helper, expressionEvaluator, result, model.getBuild().getPlugins());
        }
        if (model.getReporting() != null) {
            PomHelper.addReportPluginAssociations(helper, expressionEvaluator, result, model.getReporting().getPlugins());
        }
        for (Profile profile : model.getProfiles()) {
            if (!activeProfiles.contains(profile.getId())) continue;
            if (profile.getDependencyManagement() != null) {
                PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, profile.getDependencyManagement().getDependencies(), false);
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, profile.getDependencies(), false);
            if (profile.getBuild() != null) {
                if (profile.getBuild().getPluginManagement() != null) {
                    PomHelper.addPluginAssociations(helper, expressionEvaluator, result, profile.getBuild().getPluginManagement().getPlugins());
                }
                PomHelper.addPluginAssociations(helper, expressionEvaluator, result, profile.getBuild().getPlugins());
            }
            if (profile.getReporting() == null) continue;
            PomHelper.addReportPluginAssociations(helper, expressionEvaluator, result, profile.getReporting().getPlugins());
        }
        PomHelper.purgeProperties(result);
        return result.values().toArray(new PropertyVersionsBuilder[result.values().size()]);
    }

    private static void addPluginAssociations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map<String, PropertyVersionsBuilder> result, List<Plugin> plugins) throws ExpressionEvaluationException {
        if (plugins == null) {
            return;
        }
        for (Plugin plugin : plugins) {
            String version = plugin.getVersion();
            if (version != null && version.contains("${") && version.indexOf(125) != -1) {
                version = StringUtils.deleteWhitespace((String)version);
                for (PropertyVersionsBuilder property : result.values()) {
                    String propertyRef = "${" + property.getName() + "}";
                    if (!version.contains(propertyRef)) continue;
                    String groupId = plugin.getGroupId();
                    groupId = groupId == null || groupId.trim().length() == 0 ? APACHE_MAVEN_PLUGINS_GROUPID : (String)expressionEvaluator.evaluate(groupId);
                    String artifactId = plugin.getArtifactId();
                    if (artifactId == null || artifactId.trim().length() == 0) continue;
                    artifactId = (String)expressionEvaluator.evaluate(artifactId);
                    VersionRange versionRange = VersionRange.createFromVersion((String)((String)expressionEvaluator.evaluate(plugin.getVersion())));
                    property.addAssociation(helper.createPluginArtifact(groupId, artifactId, versionRange), true);
                    if (propertyRef.equals(version)) continue;
                    PomHelper.addBounds(property, version, propertyRef, versionRange.toString());
                }
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, plugin.getDependencies(), true);
        }
    }

    private static void addReportPluginAssociations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map<String, PropertyVersionsBuilder> result, List<ReportPlugin> reportPlugins) throws ExpressionEvaluationException {
        if (reportPlugins == null) {
            return;
        }
        for (ReportPlugin plugin : reportPlugins) {
            String version = plugin.getVersion();
            if (version == null || !version.contains("${") || version.indexOf(125) == -1) continue;
            version = StringUtils.deleteWhitespace((String)version);
            for (PropertyVersionsBuilder property : result.values()) {
                String propertyRef = "${" + property.getName() + "}";
                if (!version.contains(propertyRef)) continue;
                String groupId = plugin.getGroupId();
                groupId = groupId == null || groupId.trim().length() == 0 ? APACHE_MAVEN_PLUGINS_GROUPID : (String)expressionEvaluator.evaluate(groupId);
                String artifactId = plugin.getArtifactId();
                if (artifactId == null || artifactId.trim().length() == 0) continue;
                artifactId = (String)expressionEvaluator.evaluate(artifactId);
                VersionRange versionRange = VersionRange.createFromVersion((String)((String)expressionEvaluator.evaluate(plugin.getVersion())));
                property.addAssociation(helper.createPluginArtifact(groupId, artifactId, versionRange), true);
                if (propertyRef.equals(version)) continue;
                PomHelper.addBounds(property, version, propertyRef, versionRange.toString());
            }
        }
    }

    private static void addDependencyAssocations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map<String, PropertyVersionsBuilder> result, List<Dependency> dependencies, boolean usePluginRepositories) throws ExpressionEvaluationException {
        if (dependencies == null) {
            return;
        }
        for (Dependency dependency : dependencies) {
            String version = dependency.getVersion();
            if (version == null || !version.contains("${") || version.indexOf(125) == -1) continue;
            version = StringUtils.deleteWhitespace((String)version);
            for (PropertyVersionsBuilder property : result.values()) {
                String groupId;
                String propertyRef = "${" + property.getName() + "}";
                if (!version.contains(propertyRef) || (groupId = dependency.getGroupId()) == null || groupId.trim().length() == 0) continue;
                groupId = (String)expressionEvaluator.evaluate(groupId);
                String artifactId = dependency.getArtifactId();
                if (artifactId == null || artifactId.trim().length() == 0) continue;
                artifactId = (String)expressionEvaluator.evaluate(artifactId);
                VersionRange versionRange = VersionRange.createFromVersion((String)((String)expressionEvaluator.evaluate(dependency.getVersion())));
                property.addAssociation(helper.createDependencyArtifact(groupId, artifactId, versionRange, dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional()), usePluginRepositories);
                if (propertyRef.equals(version)) continue;
                PomHelper.addBounds(property, version, propertyRef, versionRange.toString());
            }
        }
    }

    private static void addBounds(PropertyVersionsBuilder builder, String rawVersionRange, String propertyRef, String evaluatedVersionRange) {
        Pattern lowerBound = Pattern.compile("([(\\[])([^,]*)," + RegexUtils.quote(propertyRef) + "([)\\]])");
        Pattern upperBound = Pattern.compile("([(\\[])" + RegexUtils.quote(propertyRef) + ",([^,]*)([)\\]])");
        Matcher m = lowerBound.matcher(rawVersionRange);
        if (m.find()) {
            boolean includeLower = "[".equals(m.group(1));
            String lowerLimit = m.group(2);
            if (StringUtils.isNotEmpty((String)lowerLimit)) {
                builder.addLowerBound(lowerLimit, includeLower);
            }
        }
        if ((m = upperBound.matcher(rawVersionRange)).find()) {
            boolean includeUpper = "[".equals(m.group(3));
            String upperLimit = m.group(2);
            if (StringUtils.isNotEmpty((String)upperLimit)) {
                builder.addUpperBound(upperLimit, includeUpper);
            }
        }
    }

    private static void addProperties(VersionsHelper helper, Map<String, PropertyVersionsBuilder> result, String profileId, Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> j = properties.propertyNames();
        while (j.hasMoreElements()) {
            String propertyName = (String)j.nextElement();
            if (result.containsKey(propertyName)) continue;
            result.put(propertyName, new PropertyVersionsBuilder(profileId, propertyName, helper));
        }
    }

    private static void purgeProperties(Map<String, PropertyVersionsBuilder> result) {
        Iterator<PropertyVersionsBuilder> i = result.values().iterator();
        while (i.hasNext()) {
            PropertyVersionsBuilder versions = i.next();
            if (versions.getAssociations().length != 0) continue;
            i.remove();
        }
    }

    public static Set getAllChildModules(MavenProject project, Log logger) {
        return PomHelper.getAllChildModules(project.getOriginalModel(), logger);
    }

    public static Set<String> getAllChildModules(Model model, Log logger) {
        logger.debug((CharSequence)"Finding child modules...");
        TreeSet<String> childModules = new TreeSet<String>();
        childModules.addAll(model.getModules());
        for (Profile profile : model.getProfiles()) {
            childModules.addAll(profile.getModules());
        }
        PomHelper.debugModules(logger, "Child modules:", childModules);
        return childModules;
    }

    public static void debugModules(Log logger, String message, Collection modules) {
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)message);
            if (modules.isEmpty()) {
                logger.debug((CharSequence)"None.");
            } else {
                Iterator i = modules.iterator();
                while (i.hasNext()) {
                    logger.debug((CharSequence)("  " + i.next()));
                }
            }
        }
    }

    public static void removeMissingChildModules(Log logger, MavenProject project, Collection<String> childModules) {
        PomHelper.removeMissingChildModules(logger, project.getBasedir(), childModules);
    }

    public static void removeMissingChildModules(Log logger, File basedir, Collection<String> childModules) {
        logger.debug((CharSequence)"Removing child modules which are missing...");
        Iterator<String> i = childModules.iterator();
        while (i.hasNext()) {
            String modulePath = i.next();
            File moduleFile = new File(basedir, modulePath);
            if (moduleFile.isDirectory() && new File(moduleFile, "pom.xml").isFile() || moduleFile.isFile()) continue;
            logger.debug((CharSequence)("Removing missing child module " + modulePath));
            i.remove();
        }
        PomHelper.debugModules(logger, "After removing missing", childModules);
    }

    public static String getVersion(Model model) {
        String targetVersion = model.getVersion();
        if (targetVersion == null && model.getParent() != null) {
            targetVersion = model.getParent().getVersion();
        }
        return targetVersion;
    }

    public static boolean isExplicitVersion(Model model) {
        return model.getVersion() != null;
    }

    public static String getArtifactId(Model model) {
        String sourceArtifactId = model.getArtifactId();
        if (sourceArtifactId == null && model.getParent() != null) {
            sourceArtifactId = model.getParent().getArtifactId();
        }
        return sourceArtifactId;
    }

    public static String getGroupId(Model model) {
        String targetGroupId = model.getGroupId();
        if (targetGroupId == null && model.getParent() != null) {
            targetGroupId = model.getParent().getGroupId();
        }
        return targetGroupId;
    }

    public static MavenProject getLocalRoot(MavenProjectBuilder builder, MavenProject project, ArtifactRepository localRepository, ProfileManager globalProfileManager, Log logger) {
        File parentDir;
        logger.info((CharSequence)"Searching for local aggregator root...");
        while ((parentDir = project.getBasedir().getParentFile()).isDirectory()) {
            logger.debug((CharSequence)("Checking to see if " + parentDir + " is an aggregator parent"));
            File parent = new File(parentDir, "pom.xml");
            if (!parent.isFile()) break;
            try {
                MavenProject parentProject = builder.build(parent, localRepository, globalProfileManager);
                if (PomHelper.getAllChildModules(parentProject, logger).contains(project.getBasedir().getName())) {
                    logger.debug((CharSequence)(parentDir + " is an aggregator parent"));
                    project = parentProject;
                    continue;
                }
                logger.debug((CharSequence)(parentDir + " is not an aggregator parent"));
                break;
            }
            catch (ProjectBuildingException e) {
                logger.warn((Throwable)e);
                break;
            }
        }
        logger.debug((CharSequence)("Local aggregation root is " + project.getBasedir()));
        return project;
    }

    public static Map<String, Model> getReactorModels(MavenProject project, Log logger) throws IOException {
        LinkedHashMap<String, Model> result = new LinkedHashMap<String, Model>();
        Model model = PomHelper.getRawModel(project);
        String path = "";
        result.put("", model);
        result.putAll(PomHelper.getReactorModels("", model, project, logger));
        return result;
    }

    private static Map<String, Model> getReactorModels(String path, Model model, MavenProject project, Log logger) throws IOException {
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + '/';
        }
        LinkedHashMap<String, Model> result = new LinkedHashMap<String, Model>();
        LinkedHashMap<String, Model> childResults = new LinkedHashMap<String, Model>();
        File baseDir = path.length() > 0 ? new File(project.getBasedir(), path) : project.getBasedir();
        Set<String> childModules = PomHelper.getAllChildModules(model, logger);
        PomHelper.removeMissingChildModules(logger, baseDir, childModules);
        for (String moduleName : childModules) {
            String modulePath = path + moduleName;
            File moduleDir = new File(baseDir, moduleName);
            File moduleProjectFile = moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir;
            try {
                Model moduleModel = PomHelper.getRawModel(moduleProjectFile);
                result.put(modulePath, moduleModel);
                childResults.putAll(PomHelper.getReactorModels(modulePath, moduleModel, project, logger));
            }
            catch (IOException e) {
                logger.debug((CharSequence)("Could not parse " + moduleProjectFile.getPath()), (Throwable)e);
            }
        }
        result.putAll(childResults);
        return result;
    }

    public static Map<String, Model> getChildModels(Map<String, Model> reactor, String groupId, String artifactId) {
        LinkedHashMap<String, Model> result = new LinkedHashMap<String, Model>();
        for (Map.Entry<String, Model> entry : reactor.entrySet()) {
            String path = entry.getKey();
            Model model = entry.getValue();
            Parent parent = model.getParent();
            if (parent == null || !groupId.equals(parent.getGroupId()) || !artifactId.equals(parent.getArtifactId())) continue;
            result.put(path, model);
        }
        return result;
    }

    public static Model getModel(Map<String, Model> reactor, String groupId, String artifactId) {
        for (Model model : reactor.values()) {
            if (!groupId.equals(PomHelper.getGroupId(model)) || !artifactId.equals(PomHelper.getArtifactId(model))) continue;
            return model;
        }
        return null;
    }

    public static int getReactorParentCount(Map<String, Model> reactor, Model model) {
        if (model.getParent() == null) {
            return 0;
        }
        Model parentModel = PomHelper.getModel(reactor, model.getParent().getGroupId(), model.getParent().getArtifactId());
        if (parentModel != null) {
            return PomHelper.getReactorParentCount(reactor, parentModel) + 1;
        }
        return 0;
    }

    public static StringBuilder readXmlFile(File outFile) throws IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)outFile);
        try {
            StringBuilder stringBuilder = new StringBuilder(IOUtil.toString((Reader)reader));
            return stringBuilder;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }
}

