/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PomHelper {
    public static final String POM_ENCODING = "UTF-8";
    public static final String APACHE_MAVEN_PLUGINS_GROUPID = "org.apache.maven.plugins";

    public static Model getRawModel(MavenProject project) throws IOException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(project.getFile());
            bufferedReader = new BufferedReader(fileReader);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)bufferedReader);
            return model;
        }
        catch (XmlPullParserException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    public static boolean setPropertyVersion(ModifiedPomXMLEventReader pom, String profileId, String property, String value) throws XMLStreamException {
        Pattern projectProfileId;
        Pattern matchScopeRegex;
        Pattern propertyRegex;
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        if (profileId == null) {
            propertyRegex = Pattern.compile("/project/properties/" + RegexUtils.quote(property));
            matchScopeRegex = Pattern.compile("/project/properties");
            projectProfileId = null;
        } else {
            propertyRegex = Pattern.compile("/project/profiles/profile/properties/" + RegexUtils.quote(property));
            matchScopeRegex = Pattern.compile("/project/profiles/profile");
            projectProfileId = Pattern.compile("/project/profiles/profile/id");
        }
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (propertyRegex.matcher(path).matches()) {
                    pom.mark(0);
                } else if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = profileId == null;
                    pom.clearMark(0);
                    pom.clearMark(1);
                } else if (profileId != null && projectProfileId.matcher(path).matches()) {
                    String candidateId = pom.getElementText();
                    path = (String)stack.pop();
                    inMatchScope = profileId.trim().equals(candidateId.trim());
                }
            }
            if (!event.isEndElement()) continue;
            if (propertyRegex.matcher(path).matches()) {
                pom.mark(1);
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static boolean setProjectVersion(ModifiedPomXMLEventReader pom, String value) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean madeReplacement = false;
        Pattern matchScopeRegex = Pattern.compile("/project/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static String getProjectVersion(ModifiedPomXMLEventReader pom) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        Pattern matchScopeRegex = Pattern.compile("/project/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    return pom.getBetween(0, 1).trim();
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return null;
    }

    public static boolean setProjectParentVersion(ModifiedPomXMLEventReader pom, String value) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean madeReplacement = false;
        Pattern matchScopeRegex = Pattern.compile("/project/parent/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static Artifact getProjectParent(ModifiedPomXMLEventReader pom, VersionsHelper helper) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        Pattern matchScopeRegex = Pattern.compile("/project/parent((/groupId)|(/artifactId)|(/version))");
        String groupId = null;
        String artifactId = null;
        String version = null;
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        groupId = pom.getElementText().trim();
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        artifactId = pom.getElementText().trim();
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        version = pom.getElementText().trim();
                        path = (String)stack.pop();
                    }
                }
            }
            if (!event.isEndElement()) continue;
            path = (String)stack.pop();
        }
        if (groupId == null || artifactId == null || version == null) {
            return null;
        }
        return helper.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion(version), "pom", null, null, false);
    }

    public static boolean setDependencyVersion(ModifiedPomXMLEventReader pom, String groupId, String artifactId, String oldVersion, String newVersion) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        Pattern matchScopeRegex = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency");
        Pattern matchTargetRegex = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency((/groupId)|(/artifactId)|(/version))");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = groupId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        pom.mark(0);
                    }
                }
            }
            if (!event.isEndElement()) continue;
            if (matchTargetRegex.matcher(path).matches() && "version".equals(event.asEndElement().getName().getLocalPart())) {
                pom.mark(1);
                String compressedPomVersion = StringUtils.deleteWhitespace((String)pom.getBetween(0, 1).trim());
                String compressedOldVersion = StringUtils.deleteWhitespace((String)oldVersion);
                haveOldVersion = compressedOldVersion.equals(compressedPomVersion);
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1) && haveGroupId && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween(0, 1, newVersion);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
                haveArtifactId = false;
                haveGroupId = false;
                haveOldVersion = false;
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static boolean setPluginVersion(ModifiedPomXMLEventReader pom, String groupId, String artifactId, String oldVersion, String newVersion) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean needGroupId = groupId != null && !APACHE_MAVEN_PLUGINS_GROUPID.equals(groupId);
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        Pattern matchScopeRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Pattern matchTargetRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin((/groupId)|(/artifactId)|(/version))");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = groupId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        pom.mark(0);
                    }
                }
            }
            if (!event.isEndElement()) continue;
            if (matchTargetRegex.matcher(path).matches() && "version".equals(event.asEndElement().getName().getLocalPart())) {
                pom.mark(1);
                haveOldVersion = oldVersion.equals(pom.getBetween(0, 1).trim());
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1) && (haveGroupId || !needGroupId) && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween(0, 1, newVersion);
                    madeReplacement = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveArtifactId = false;
                    haveGroupId = false;
                    haveOldVersion = false;
                }
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static PropertyVersions[] getPropertyVersions(VersionsHelper helper, MavenProject project, ExpressionEvaluator expressionEvaluator) throws ExpressionEvaluationException, IOException {
        Profile profile;
        Model model = PomHelper.getRawModel(project);
        TreeMap result = new TreeMap();
        TreeSet<String> activeProfiles = new TreeSet<String>();
        Iterator i = project.getActiveProfiles().iterator();
        while (i.hasNext()) {
            profile = (Profile)i.next();
            activeProfiles.add(profile.getId());
        }
        i = model.getProfiles().iterator();
        while (i.hasNext()) {
            profile = (Profile)i.next();
            if (!activeProfiles.contains(profile.getId())) continue;
            PomHelper.addProperties(helper, result, profile.getId(), profile.getProperties());
            if (profile.getDependencyManagement() != null) {
                PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, profile.getDependencyManagement().getDependencies(), false);
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, profile.getDependencies(), false);
            if (profile.getBuild() != null) {
                if (profile.getBuild().getPluginManagement() != null) {
                    PomHelper.addPluginAssociations(helper, expressionEvaluator, result, profile.getBuild().getPluginManagement().getPlugins());
                }
                PomHelper.addPluginAssociations(helper, expressionEvaluator, result, profile.getBuild().getPlugins());
            }
            if (profile.getReporting() == null) continue;
            PomHelper.addReportPluginAssociations(helper, expressionEvaluator, result, profile.getReporting().getPlugins());
        }
        PomHelper.addProperties(helper, result, null, model.getProperties());
        if (model.getDependencyManagement() != null) {
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, model.getDependencyManagement().getDependencies(), false);
        }
        PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, model.getDependencies(), false);
        if (model.getBuild() != null) {
            if (model.getBuild().getPluginManagement() != null) {
                PomHelper.addPluginAssociations(helper, expressionEvaluator, result, model.getBuild().getPluginManagement().getPlugins());
            }
            PomHelper.addPluginAssociations(helper, expressionEvaluator, result, model.getBuild().getPlugins());
        }
        if (model.getReporting() != null) {
            PomHelper.addReportPluginAssociations(helper, expressionEvaluator, result, model.getReporting().getPlugins());
        }
        PomHelper.purgeProperties(result);
        return result.values().toArray(new PropertyVersions[result.values().size()]);
    }

    private static void addPluginAssociations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map result, List plugins) throws ExpressionEvaluationException {
        if (plugins == null) {
            return;
        }
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            String version = plugin.getVersion();
            if (version != null && version.indexOf("${") != -1 && version.indexOf(125) != -1) {
                Iterator j = result.values().iterator();
                while (j.hasNext()) {
                    PropertyVersions property = (PropertyVersions)j.next();
                    if (version.indexOf("${" + property.getName() + "}") == -1) continue;
                    String groupId = plugin.getGroupId();
                    groupId = groupId == null || groupId.trim().length() == 0 ? APACHE_MAVEN_PLUGINS_GROUPID : (String)expressionEvaluator.evaluate(groupId);
                    String artifactId = plugin.getArtifactId();
                    if (artifactId == null || artifactId.trim().length() == 0) continue;
                    artifactId = (String)expressionEvaluator.evaluate(artifactId);
                    VersionRange versionRange = VersionRange.createFromVersion((String)((String)expressionEvaluator.evaluate(plugin.getVersion())));
                    property.addAssociation(helper.createPluginArtifact(groupId, artifactId, versionRange), true);
                }
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, plugin.getDependencies(), true);
        }
    }

    private static void addReportPluginAssociations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map result, List reportPlugins) throws ExpressionEvaluationException {
        if (reportPlugins == null) {
            return;
        }
        Iterator i = reportPlugins.iterator();
        while (i.hasNext()) {
            ReportPlugin plugin = (ReportPlugin)i.next();
            String version = plugin.getVersion();
            if (version == null || version.indexOf("${") == -1 || version.indexOf(125) == -1) continue;
            Iterator j = result.values().iterator();
            while (j.hasNext()) {
                PropertyVersions property = (PropertyVersions)j.next();
                if (version.indexOf("${" + property.getName() + "}") == -1) continue;
                String groupId = plugin.getGroupId();
                groupId = groupId == null || groupId.trim().length() == 0 ? APACHE_MAVEN_PLUGINS_GROUPID : (String)expressionEvaluator.evaluate(groupId);
                String artifactId = plugin.getArtifactId();
                if (artifactId == null || artifactId.trim().length() == 0) continue;
                artifactId = (String)expressionEvaluator.evaluate(artifactId);
                VersionRange versionRange = VersionRange.createFromVersion((String)((String)expressionEvaluator.evaluate(plugin.getVersion())));
                property.addAssociation(helper.createPluginArtifact(groupId, artifactId, versionRange), true);
            }
        }
    }

    private static void addDependencyAssocations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map result, List dependencies, boolean usePluginRepositories) throws ExpressionEvaluationException {
        if (dependencies == null) {
            return;
        }
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            String version = dependency.getVersion();
            if (version == null || version.indexOf("${") == -1 || version.indexOf(125) == -1) continue;
            Iterator j = result.values().iterator();
            while (j.hasNext()) {
                String groupId;
                PropertyVersions property = (PropertyVersions)j.next();
                if (version.indexOf("${" + property.getName() + "}") == -1 || (groupId = dependency.getGroupId()) == null || groupId.trim().length() == 0) continue;
                groupId = (String)expressionEvaluator.evaluate(groupId);
                String artifactId = dependency.getArtifactId();
                if (artifactId == null || artifactId.trim().length() == 0) continue;
                artifactId = (String)expressionEvaluator.evaluate(artifactId);
                VersionRange versionRange = VersionRange.createFromVersion((String)((String)expressionEvaluator.evaluate(dependency.getVersion())));
                property.addAssociation(helper.createDependencyArtifact(groupId, artifactId, versionRange, dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional()), usePluginRepositories);
            }
        }
    }

    private static void addProperties(VersionsHelper helper, Map result, String profileId, Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> j = properties.propertyNames();
        while (j.hasMoreElements()) {
            String propertyName = (String)j.nextElement();
            if (result.containsKey(propertyName)) continue;
            result.put(propertyName, new PropertyVersions(profileId, propertyName, helper));
        }
    }

    private static void purgeProperties(Map result) {
        Iterator i = result.values().iterator();
        while (i.hasNext()) {
            PropertyVersions versions = (PropertyVersions)i.next();
            if (versions.getAssociations().length != 0) continue;
            i.remove();
        }
    }

    public static Set getAllChildModules(MavenProject project, Log logger) {
        logger.debug((CharSequence)"Finding child modules...");
        TreeSet childModules = new TreeSet();
        childModules.addAll(project.getOriginalModel().getModules());
        Iterator i = project.getOriginalModel().getProfiles().iterator();
        while (i.hasNext()) {
            Profile profile = (Profile)i.next();
            childModules.addAll(profile.getModules());
        }
        PomHelper.debugModules(logger, "Child modules:", childModules);
        return childModules;
    }

    public static void debugModules(Log logger, String message, Collection modules) {
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)message);
            if (modules.isEmpty()) {
                logger.debug((CharSequence)"None.");
            } else {
                Iterator i = modules.iterator();
                while (i.hasNext()) {
                    logger.debug((CharSequence)("  " + i.next()));
                }
            }
        }
    }

    public static void removeMissingChildModules(Log logger, MavenProject project, Collection childModules) {
        logger.debug((CharSequence)"Removing child modules which are missing...");
        Iterator i = childModules.iterator();
        while (i.hasNext()) {
            String modulePath = (String)i.next();
            File moduleFile = new File(project.getBasedir(), modulePath);
            if (moduleFile.isDirectory() && new File(moduleFile, "pom.xml").isFile() || moduleFile.isFile()) continue;
            logger.debug((CharSequence)("Removing missing child module " + modulePath));
            i.remove();
        }
        PomHelper.debugModules(logger, "After removing missing", childModules);
    }
}

