/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.mojo.versions.utils.WagonUtils;

public class DefaultVersionsHelper
implements VersionsHelper {
    private final RuleSet ruleSet;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactRepository localRepository;
    private final List remoteArtifactRepositories;
    private final List remotePluginRepositories;
    private final ArtifactFactory artifactFactory;
    private final Log log;

    public DefaultVersionsHelper(ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, List remoteArtifactRepositories, List remotePluginRepositories, ArtifactRepository localRepository, WagonManager wagonManager, Settings settings, String serverId, String rulesUri, String comparisonMethod, Log log) throws MojoExecutionException {
        this.artifactFactory = artifactFactory;
        this.ruleSet = DefaultVersionsHelper.loadRuleSet(serverId, settings, wagonManager, rulesUri, comparisonMethod, log);
        this.artifactMetadataSource = artifactMetadataSource;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.remotePluginRepositories = remotePluginRepositories;
        this.log = log;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public Log getLog() {
        return this.log;
    }

    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws MojoExecutionException {
        return this.lookupVersions(artifact, usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories);
    }

    private ArtifactVersions lookupVersions(Artifact artifact, List remoteRepositories) throws MojoExecutionException {
        List versions;
        try {
            versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, remoteRepositories);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException("Could not retrieve metadata for " + artifact, (Exception)((Object)e));
        }
        return new ArtifactVersions(artifact, versions, this.getVersionComparator(artifact));
    }

    public Comparator getVersionComparator(Artifact artifact) {
        return this.getVersionComparator(artifact.getGroupId(), artifact.getArtifactId());
    }

    public Comparator getVersionComparator(String groupId, String artifactId) {
        List rules = this.ruleSet.getRules();
        String comparisonMethod = this.ruleSet.getComparisonMethod();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            Rule rule = (Rule)i.next();
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getGroupId(), groupId)) || DefaultVersionsHelper.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getArtifactId(), artifactId)) || DefaultVersionsHelper.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            comparisonMethod = rule.getComparisonMethod();
        }
        return VersionComparators.getVersionComparator(comparisonMethod);
    }

    /*
     * Exception decompiling
     */
    private static RuleSet getRuleSet(Wagon wagon, String remoteURI) throws IOException, AuthorizationException, TransferFailedException, ResourceDoesNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuleSet loadRuleSet(String serverId, Settings settings, WagonManager wagonManager, String rulesUri, String comparisonMethod, Log logger) throws MojoExecutionException {
        RuleSet ruleSet = new RuleSet();
        if (comparisonMethod != null) {
            ruleSet.setComparisonMethod(comparisonMethod);
        }
        if (rulesUri != null && rulesUri.trim().length() != 0) {
            try {
                try {
                    Wagon wagon = WagonUtils.createWagon(serverId, rulesUri, wagonManager, settings, logger);
                    try {
                        ruleSet.setRules(DefaultVersionsHelper.getRuleSet(wagon, "").getRules());
                    }
                    finally {
                        if (wagon != null) {
                            try {
                                wagon.disconnect();
                            }
                            catch (ConnectionException e) {
                                logger.warn((CharSequence)"Could not disconnect wagon!", (Throwable)e);
                            }
                        }
                    }
                }
                catch (TransferFailedException e) {
                    throw new MojoExecutionException("Could not transfer rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (AuthorizationException e) {
                    throw new MojoExecutionException("Authorization failure trying to load rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (ResourceDoesNotExistException e) {
                    throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (AuthenticationException e) {
                    throw new MojoExecutionException("Authentication failure trying to load rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (UnsupportedProtocolException e) {
                    throw new MojoExecutionException("Unsupported protocol for " + rulesUri, (Exception)((Object)e));
                }
                catch (ConnectionException e) {
                    throw new MojoExecutionException("Could not establish connection to " + rulesUri, (Exception)((Object)e));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)e);
            }
        }
        return ruleSet;
    }

    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
    }

    public Artifact createDependencyArtifact(Dependency dependency) throws InvalidVersionSpecificationException {
        return this.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion() == null ? VersionRange.createFromVersionSpec((String)"[0,]") : VersionRange.createFromVersionSpec((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional());
    }

    public Set extractArtifacts(Collection mavenProjects) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator i = mavenProjects.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof MavenProject)) continue;
            MavenProject project = (MavenProject)next;
            result.add(project.getArtifact());
        }
        return result;
    }
}

