/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdateChildModulesMojo
extends AbstractVersionsUpdaterMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set childModules = this.getAllChildModules(this.getProject());
        this.removeMissingChildModules(this.getProject(), childModules);
        Iterator i = childModules.iterator();
        MojoExecutionException pbe = null;
        while (i.hasNext()) {
            String modulePath = (String)i.next();
            File moduleDir = new File(this.getProject().getBasedir(), modulePath);
            File moduleProjectFile = moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir;
            try {
                StringBuffer childPom = this.readFile(moduleProjectFile);
                ModifiedPomXMLEventReader pom = this.newModifiedPomXER(childPom);
                Stack<String> stack = new Stack<String>();
                String path = "";
                String groupId = null;
                String artifactId = null;
                String version = null;
                Pattern pattern = Pattern.compile("/project/parent/(groupId|artifactId|version)");
                while (pom.hasNext()) {
                    XMLEvent event = pom.nextEvent();
                    if (event.isStartDocument()) {
                        path = "";
                        stack.clear();
                        continue;
                    }
                    if (event.isStartElement()) {
                        stack.push(path);
                        if (!pattern.matcher(path = path + "/" + event.asStartElement().getName().getLocalPart()).matches()) continue;
                        String text = pom.getElementText().trim();
                        if (path.endsWith("groupId")) {
                            groupId = text;
                        } else if (path.endsWith("artifactId")) {
                            artifactId = text;
                        } else if (path.endsWith("version")) {
                            version = text;
                        }
                        path = (String)stack.pop();
                        continue;
                    }
                    if (!event.isEndElement()) continue;
                    if ("/project/parent".equals(path)) {
                        this.getLog().info((CharSequence)("Module: " + modulePath));
                        if (this.getProject().getGroupId().equals(groupId) && this.getProject().getArtifactId().equals(artifactId)) {
                            if (this.getProject().getVersion().equals(version)) {
                                this.getLog().info((CharSequence)("  Parent is " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + ":" + this.getProject().getVersion()));
                            } else {
                                this.getLog().info((CharSequence)("  Parent was " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + ":" + version + ", now " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + ":" + this.getProject().getVersion()));
                                this.process(moduleProjectFile);
                            }
                        } else {
                            this.getLog().info((CharSequence)("  does not use " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + " as its parent"));
                        }
                    }
                    path = (String)stack.pop();
                }
            }
            catch (XMLStreamException e) {
                this.getLog().debug((CharSequence)("Could not parse " + moduleProjectFile.getPath()), (Throwable)e);
                if (pbe != null) continue;
                pbe = new MojoExecutionException("Could not parse " + moduleProjectFile.getPath(), (Exception)e);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Could not parse " + moduleProjectFile.getPath()), (Throwable)e);
                if (pbe != null) continue;
                pbe = new MojoExecutionException("Could not parse " + moduleProjectFile.getPath(), (Exception)e);
            }
        }
        if (pbe != null) {
            throw pbe;
        }
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        this.getLog().debug((CharSequence)("Updating parent to " + this.getProject().getVersion()));
        Stack<String> stack = new Stack<String>();
        String path = "";
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if ("/project/parent/version".equals(path)) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if ("/project/parent/version".equals(path)) {
                pom.mark(1);
                if (pom.hasMark(0)) {
                    pom.replaceBetween(0, 1, this.getProject().getVersion());
                    this.getLog().debug((CharSequence)("Made an update to " + this.getProject().getVersion()));
                    return;
                }
            }
            path = (String)stack.pop();
        }
    }

    private Set getAllChildModules(MavenProject project) {
        this.getLog().debug((CharSequence)"Finding child modules...");
        TreeSet childModules = new TreeSet();
        childModules.addAll(project.getOriginalModel().getModules());
        Iterator i = project.getOriginalModel().getProfiles().iterator();
        while (i.hasNext()) {
            Profile profile = (Profile)i.next();
            childModules.addAll(profile.getModules());
        }
        this.debugModules("Child modules:", childModules);
        return childModules;
    }

    private void debugModules(String message, Collection modules) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)message);
            if (modules.isEmpty()) {
                this.getLog().debug((CharSequence)"None.");
            } else {
                Iterator i = modules.iterator();
                while (i.hasNext()) {
                    this.getLog().debug((CharSequence)("  " + i.next()));
                }
            }
        }
    }

    private void removeMissingChildModules(MavenProject project, Collection childModules) {
        this.getLog().debug((CharSequence)"Removing child modules which are missing...");
        Iterator i = childModules.iterator();
        while (i.hasNext()) {
            String modulePath = (String)i.next();
            File moduleFile = new File(project.getBasedir(), modulePath);
            if (moduleFile.isDirectory() && new File(moduleFile, "pom.xml").isFile() || moduleFile.isFile()) continue;
            this.getLog().debug((CharSequence)("Removing missing child module " + modulePath));
            i.remove();
        }
        this.debugModules("After removing missing", childModules);
    }
}

