/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;

public class DisplayPluginUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int WARN_PAD_SIZE = 65;
    private static final int INFO_PAD_SIZE = 68;
    private static final String FROM_SUPER_POM = "(from super-pom) ";
    private LifecycleExecutor lifecycleExecutor;
    private MavenSession session;
    private PluginManager pluginManager;

    private Map getSuperPomPluginManagement() throws MojoExecutionException {
        HashMap superPomPluginManagement = new HashMap();
        try {
            superPomPluginManagement.putAll(this.getPluginManagement(this.projectBuilder.buildStandaloneSuperProject(this.localRepository)));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not determine the super pom.xml", (Exception)((Object)e));
        }
        return superPomPluginManagement;
    }

    private Map getPluginManagement(MavenProject project) {
        HashMap<String, String> pluginManagement = new HashMap<String, String>();
        try {
            Iterator j = project.getOriginalModel().getBuild().getPluginManagement().getPlugins().iterator();
            while (j.hasNext()) {
                Plugin plugin = (Plugin)j.next();
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null) continue;
                pluginManagement.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Iterator i = project.getOriginalModel().getProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                try {
                    Iterator j = profile.getBuild().getPluginManagement().getPlugins().iterator();
                    while (j.hasNext()) {
                        Plugin plugin = (Plugin)j.next();
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null) continue;
                        pluginManagement.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return pluginManagement;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List parents = this.getParentProjects(this.getProject());
        Map superPomPluginManagement = this.getSuperPomPluginManagement();
        HashMap parentPluginManagement = new HashMap();
        HashMap parentBuildPlugins = new HashMap();
        HashMap parentReportPlugins = new HashMap();
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            MavenProject parentProject = (MavenProject)i.next();
            parentPluginManagement.putAll(this.getPluginManagement(parentProject));
            parentBuildPlugins.putAll(this.getBuildPlugins(parentProject, true));
            parentReportPlugins.putAll(this.getReportPlugins(parentProject, true));
        }
        Set plugins = this.getProjectPlugins(superPomPluginManagement, parentPluginManagement, parentBuildPlugins, parentReportPlugins);
        ArrayList<String> updates = new ArrayList<String>();
        ArrayList<String> lockdown = new ArrayList<String>();
        i = plugins.iterator();
        while (i.hasNext()) {
            int padding;
            StringBuffer buf;
            String newVersion;
            VersionRange versionRange;
            Object plugin = i.next();
            String groupId = DisplayPluginUpdatesMojo.getPluginGroupId(plugin);
            String artifactId = DisplayPluginUpdatesMojo.getPluginArtifactId(plugin);
            String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
            String coords = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
            if (version == null) {
                version = (String)parentPluginManagement.get(coords);
            }
            this.getLog().debug((CharSequence)("Checking " + coords + " for updates newer than " + version));
            try {
                versionRange = VersionRange.createFromVersionSpec((String)(version == null ? "LATEST" : version));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
            }
            Artifact artifact = this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
            ArtifactVersion artifactVersion = this.findLatestVersion(artifact, versionRange, null);
            if (version == null && artifactVersion != null) {
                version = (String)superPomPluginManagement.get(ArtifactUtils.versionlessKey((Artifact)artifact));
                newVersion = version != null ? version : artifactVersion.toString();
                buf = new StringBuffer();
                if (!"org.apache.maven.plugins".equals(groupId)) {
                    buf.append(groupId).append(':');
                }
                buf.append(artifactId);
                buf.append(' ');
                padding = 65 - newVersion.length() - (version != null ? FROM_SUPER_POM.length() : 0);
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                if (version != null) {
                    buf.append(FROM_SUPER_POM);
                }
                buf.append(newVersion);
                lockdown.add(buf.toString());
            } else {
                newVersion = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (version == null || artifactVersion == null || version.compareTo(newVersion) >= 0) continue;
            buf = new StringBuffer();
            if (!"org.apache.maven.plugins".equals(groupId)) {
                buf.append(groupId).append(':');
            }
            buf.append(artifactId);
            buf.append(' ');
            padding = 68 - version.length() - newVersion.length() - 4;
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(version);
            buf.append(" -> ");
            buf.append(newVersion);
            updates.add(buf.toString());
        }
        this.getLog().info((CharSequence)"");
        if (updates.isEmpty()) {
            this.getLog().info((CharSequence)"All plugins are using the latest versions.");
        } else {
            this.getLog().info((CharSequence)"The following plugin updates are available:");
            i = updates.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)("  " + i.next()));
            }
        }
        this.getLog().info((CharSequence)"");
        if (lockdown.isEmpty()) {
            this.getLog().info((CharSequence)"All plugins have a version specified.");
        } else {
            this.getLog().warn((CharSequence)"The following plugins do not have their version specified:");
            i = lockdown.iterator();
            while (i.hasNext()) {
                this.getLog().warn((CharSequence)("  " + i.next()));
            }
        }
        this.getLog().info((CharSequence)"");
    }

    private Map getBuildPlugins(MavenProject project, boolean onlyIncludeInherited) {
        HashMap<String, String> buildPlugins = new HashMap<String, String>();
        try {
            Iterator j = project.getOriginalModel().getBuild().getPlugins().iterator();
            while (j.hasNext()) {
                Object plugin = j.next();
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                buildPlugins.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Iterator i = project.getOriginalModel().getProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                try {
                    Iterator j = profile.getBuild().getPlugins().iterator();
                    while (j.hasNext()) {
                        Object plugin = j.next();
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        buildPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return buildPlugins;
    }

    private static boolean getPluginInherited(Object plugin) {
        return "true".equalsIgnoreCase(plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getInherited() : ((Plugin)plugin).getInherited());
    }

    private Map getLifecyclePlugins(MavenProject project) throws MojoExecutionException {
        HashMap<String, Plugin> lifecyclePlugins = new HashMap<String, Plugin>();
        try {
            Set plugins = this.getBoundPlugins(project, "clean,deploy,site");
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                lifecyclePlugins.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), plugin);
            }
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException("Could not find plugin", (Exception)((Object)e));
        }
        catch (LifecycleExecutionException e) {
            throw new MojoExecutionException("Could not determine lifecycle", (Exception)((Object)e));
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not determine lifecycles", (Exception)e);
        }
        return lifecyclePlugins;
    }

    private Set getBoundPlugins(MavenProject project, String thePhases) throws PluginNotFoundException, LifecycleExecutionException, IllegalAccessException {
        List lifecycles = (List)ReflectionUtils.getValueIncludingSuperclasses((String)"lifecycles", (Object)this.lifecycleExecutor);
        HashSet allPlugins = new HashSet();
        String[] lifecyclePhases = thePhases.split(",");
        for (int i = 0; i < lifecyclePhases.length; ++i) {
            String lifecyclePhase = lifecyclePhases[i];
            if (!StringUtils.isNotEmpty((String)lifecyclePhase)) continue;
            try {
                Lifecycle lifecycle = this.getLifecycleForPhase(lifecycles, lifecyclePhase);
                allPlugins.addAll(this.getAllPlugins(project, lifecycle));
                continue;
            }
            catch (BuildFailureException e) {
                // empty catch block
            }
        }
        return allPlugins;
    }

    private Lifecycle getLifecycleForPhase(List lifecycles, String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = (Lifecycle)this.getPhaseToLifecycleMap(lifecycles).get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private Set getAllPlugins(MavenProject project, Lifecycle lifecycle) throws PluginNotFoundException, LifecycleExecutionException {
        Plugin plugin;
        String[] tokens;
        String value;
        HashSet<Object> plugins = new HashSet<Object>();
        Map mappings = this.findMappingsForLifecycle(project, lifecycle);
        Iterator iter = mappings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            value = (String)entry.getValue();
            tokens = value.split(":");
            plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        List mojos = this.findOptionalMojosForLifecycle(project, lifecycle);
        iter = mojos.iterator();
        while (iter.hasNext()) {
            value = (String)((Object)iter.next());
            tokens = value.split(":");
            plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext()) {
            plugins.add(i.next());
        }
        return plugins;
    }

    private Map findMappingsForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", (Throwable)e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List findOptionalMojosForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
        if (m != null) {
            optionalMojos = m.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                optionalMojos = m.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e.getMessage()), (Throwable)e);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.EMPTY_LIST;
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext() && pluginComponent == null) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.verifyPlugin(plugin, project, settings, localRepository);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)"Unable to find the lifecycle component in the extension", (Throwable)e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return pluginComponent;
    }

    private PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.verifyPlugin(plugin, project, settings, localRepository);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        return pluginDescriptor;
    }

    private List getParentProjects(MavenProject project) throws MojoExecutionException {
        ArrayList<MavenProject> parents = new ArrayList<MavenProject>();
        while (project.getParent() != null) {
            project = project.getParent();
            parents.add(0, project);
        }
        return parents;
    }

    public Map getPhaseToLifecycleMap(List lifecycles) throws LifecycleExecutionException {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        Iterator i = lifecycles.iterator();
        while (i.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)i.next();
            Iterator p = lifecycle.getPhases().iterator();
            while (p.hasNext()) {
                String phase = (String)p.next();
                if (phaseToLifecycleMap.containsKey(phase)) {
                    Lifecycle prevLifecycle = (Lifecycle)phaseToLifecycleMap.get(phase);
                    throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                }
                phaseToLifecycleMap.put(phase, lifecycle);
            }
        }
        return phaseToLifecycleMap;
    }

    private Set getProjectPlugins(Map superPomPluginManagement, Map parentPluginManagement, Map parentBuildPlugins, Map parentReportPlugins) throws MojoExecutionException {
        HashMap plugins = new HashMap();
        this.getLog().debug((CharSequence)"Building list of project plugins...");
        if (this.getLog().isDebugEnabled()) {
            StringWriter origModel = new StringWriter();
            try {
                origModel.write("Original model:\n");
                this.getProject().writeOriginalModel((Writer)origModel);
                this.getLog().debug((CharSequence)origModel.toString());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.debugVersionMap("super-pom version map", superPomPluginManagement);
        this.debugVersionMap("parent version map", parentPluginManagement);
        HashMap excludePluginManagement = new HashMap(superPomPluginManagement);
        excludePluginManagement.putAll(parentPluginManagement);
        this.debugVersionMap("aggregate version map", excludePluginManagement);
        try {
            this.addProjectPlugins(plugins, this.getProject().getOriginalModel().getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding local pluginManagement", plugins);
        this.addProjectPlugins(plugins, this.getLifecyclePlugins(this.getProject()).values(), parentPluginManagement);
        this.debugPluginMap("after adding lifecycle plugins", plugins);
        try {
            this.addProjectPlugins(plugins, this.getProject().getOriginalModel().getBuild().getPlugins(), parentBuildPlugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding build plugins", plugins);
        try {
            this.addProjectPlugins(plugins, this.getProject().getOriginalModel().getReporting().getPlugins(), parentReportPlugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Iterator i = this.getProject().getOriginalModel().getProfiles().iterator();
        while (i.hasNext()) {
            Profile profile = (Profile)i.next();
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding build pluginManagement for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPlugins(), parentBuildPlugins);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding build plugins for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getReporting().getPlugins(), parentReportPlugins);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding reporting plugins for profile " + profile.getId(), plugins);
        }
        TreeSet result = new TreeSet(new PluginComparator());
        result.addAll(plugins.values());
        return result;
    }

    private void addProjectPlugins(Map plugins, Collection projectPlugins, Map parentDefinitions) {
        Iterator j = projectPlugins.iterator();
        while (j.hasNext()) {
            Object plugin = j.next();
            String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
            String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
            String parentVersion = (String)parentDefinitions.get(coord);
            if (parentVersion != null && parentVersion.equals(version) || plugins.containsKey(coord) && DisplayPluginUpdatesMojo.getPluginVersion(plugins.get(coord)) != null) continue;
            plugins.put(coord, plugin);
        }
    }

    private void debugPluginMap(String description, Map plugins) {
        if (this.getLog().isDebugEnabled()) {
            TreeSet sorted = new TreeSet(new PluginComparator());
            sorted.addAll(plugins.values());
            StringBuffer buf = new StringBuffer(description);
            Iterator i = sorted.iterator();
            while (i.hasNext()) {
                Object plugin = i.next();
                buf.append("\n    ");
                buf.append(DisplayPluginUpdatesMojo.getPluginCoords(plugin));
                buf.append(":");
                buf.append(DisplayPluginUpdatesMojo.getPluginVersion(plugin));
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private void debugVersionMap(String description, Map plugins) {
        if (this.getLog().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(description);
            Iterator i = plugins.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry plugin = i.next();
                buf.append("\n    ");
                buf.append(plugin.getKey());
                buf.append(":");
                buf.append(plugin.getValue());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private static String getPluginCoords(Object plugin) {
        return DisplayPluginUpdatesMojo.getPluginGroupId(plugin) + ":" + DisplayPluginUpdatesMojo.getPluginArtifactId(plugin);
    }

    private static String getPluginArtifactId(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getArtifactId() : ((Plugin)plugin).getArtifactId();
    }

    private static String getPluginGroupId(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getGroupId() : ((Plugin)plugin).getGroupId();
    }

    private static String getPluginVersion(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getVersion() : ((Plugin)plugin).getVersion();
    }

    private Map getReportPlugins(MavenProject project, boolean onlyIncludeInherited) {
        HashMap<String, String> reportPlugins = new HashMap<String, String>();
        try {
            Iterator j = project.getOriginalModel().getReporting().getPlugins().iterator();
            while (j.hasNext()) {
                Object plugin = j.next();
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                reportPlugins.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Iterator i = project.getOriginalModel().getProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                try {
                    Iterator j = profile.getReporting().getPlugins().iterator();
                    while (j.hasNext()) {
                        Object plugin = j.next();
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        reportPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return reportPlugins;
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }

    private static class PluginComparator
    implements Comparator {
        private PluginComparator() {
        }

        public int compare(Object o1, Object o2) {
            int r = DisplayPluginUpdatesMojo.getPluginGroupId(o1).compareTo(DisplayPluginUpdatesMojo.getPluginGroupId(o2));
            if (r == 0) {
                r = DisplayPluginUpdatesMojo.getPluginArtifactId(o1).compareTo(DisplayPluginUpdatesMojo.getPluginArtifactId(o2));
            }
            if (r == 0) {
                String v1 = DisplayPluginUpdatesMojo.getPluginVersion(o1);
                String v2 = DisplayPluginUpdatesMojo.getPluginVersion(o2);
                if (v1 == null) {
                    return v2 == null ? 0 : -1;
                }
                if (v2 == null) {
                    return 1;
                }
                r = v1.compareTo(v2);
            }
            return r;
        }
    }
}

