/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.stax2.XMLInputFactory2;

public abstract class AbstractVersionsUpdaterMojo
extends AbstractMojo {
    private static final String POM_ENCODING = "UTF-8";
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver resolver;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected String comparisonMethod;
    protected Boolean allowSnapshots;
    protected List reactorProjects;
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outFile = this.project.getFile();
        this.process(outFile);
    }

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots) throws MojoExecutionException {
        List versions;
        boolean snapshotsExcluded = Boolean.FALSE.equals(this.allowSnapshots);
        if (Boolean.TRUE.equals(allowingSnapshots)) {
            snapshotsExcluded = false;
        }
        if (Boolean.FALSE.equals(allowingSnapshots)) {
            snapshotsExcluded = true;
        }
        try {
            versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, this.remoteRepositories);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException("Could not retrieve metadata for " + artifact, (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)(artifact.toString() + " has versions " + versions.toString()));
        Comparator versionComparator = this.getVersionComparator();
        ArtifactVersion artifactVersion = null;
        Iterator j = versions.iterator();
        while (j.hasNext()) {
            ArtifactVersion ver = (ArtifactVersion)j.next();
            if (snapshotsExcluded && ArtifactUtils.isSnapshot((String)ver.toString()) || !versionRange.containsVersion(ver) || artifactVersion != null && versionComparator.compare(ver, artifactVersion) <= 0) continue;
            artifactVersion = ver;
        }
        if (artifactVersion == null) {
            this.getLog().warn((CharSequence)("Could not find any version of " + artifact + " matching " + versionRange));
        }
        return artifactVersion;
    }

    protected Comparator getVersionComparator() {
        if ("numeric".equalsIgnoreCase(this.comparisonMethod)) {
            return new NumericVersionComparator();
        }
        return new MavenVersionComparator();
    }

    protected String getPropertyValue(StringBuffer pom, String property) {
        return this.project.getProperties().getProperty(property);
    }

    protected void process(File outFile) throws MojoExecutionException, MojoFailureException {
        try {
            StringBuffer input = this.readFile(outFile);
            ModifiedPomXMLEventReader newPom = this.newModifiedPomXER(input);
            this.update(newPom);
            if (newPom.isModified()) {
                this.writeFile(outFile, input);
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected final ModifiedPomXMLEventReader newModifiedPomXER(StringBuffer input) {
        ModifiedPomXMLEventReader newPom = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            newPom = new ModifiedPomXMLEventReader(input, inputFactory);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        return newPom;
    }

    protected final void writeFile(File outFile, StringBuffer input) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        ((OutputStream)out).write(input.toString().getBytes(POM_ENCODING));
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final StringBuffer readFile(File outFile) throws IOException {
        BufferedInputStream reader = new BufferedInputStream(new FileInputStream(outFile));
        byte[] content = new byte[(int)outFile.length()];
        StringBuffer input = new StringBuffer(content.length);
        try {
            int length = reader.read(content, 0, content.length);
            input.append(new String(content, 0, length, POM_ENCODING));
            StringBuffer stringBuffer = input;
            return stringBuffer;
        }
        finally {
            reader.close();
        }
    }

    protected abstract void update(ModifiedPomXMLEventReader var1) throws MojoExecutionException, MojoFailureException, XMLStreamException;

    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion) {
        this.getLog().debug((CharSequence)("Proposal is to update from " + currentVersion + " to " + updateVersion));
        if (updateVersion == null) {
            this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
            return false;
        }
        artifact.setVersion(updateVersion.toString());
        try {
            this.resolver.resolveAlways(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not resolve " + artifact.toString()), (Throwable)e);
            return false;
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not find " + artifact.toString()), (Throwable)e);
            return false;
        }
        if (currentVersion.equals(updateVersion.toString())) {
            this.getLog().info((CharSequence)("Current version of " + artifact.toString() + " is the latest."));
            return false;
        }
        return true;
    }

    private static class MavenVersionComparator
    implements Comparator {
        private MavenVersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((ArtifactVersion)o1).compareTo((Object)((ArtifactVersion)o2));
        }
    }

    static class NumericVersionComparator
    implements Comparator {
        NumericVersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            String v1 = o1.toString();
            String v2 = o2.toString();
            StringTokenizer tok1 = new StringTokenizer(v1, ".");
            StringTokenizer tok2 = new StringTokenizer(v2, ".");
            while (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                String q2;
                String q1;
                block16: {
                    int index;
                    String p1 = tok1.nextToken();
                    String p2 = tok2.nextToken();
                    q1 = null;
                    q2 = null;
                    if (p1.indexOf(45) >= 0) {
                        index = p1.indexOf(45);
                        p1 = p1.substring(0, index);
                        q1 = p1.substring(index);
                    }
                    if (p2.indexOf(45) >= 0) {
                        index = p2.indexOf(45);
                        p2 = p2.substring(0, index);
                        q2 = p2.substring(index);
                    }
                    try {
                        Integer n1 = Integer.valueOf(p1);
                        Integer n2 = Integer.valueOf(p2);
                        int result = n1.compareTo(n2);
                        if (result != 0) {
                            return result;
                        }
                    }
                    catch (NumberFormatException e) {
                        int result = p1.compareTo(p2);
                        if (result == 0) break block16;
                        return result;
                    }
                }
                if (q1 != null && q2 != null) {
                    return q1.compareTo(q2);
                }
                if (q1 != null) {
                    return -1;
                }
                if (q2 == null) continue;
                return 1;
            }
            if (tok1.hasMoreTokens()) {
                Integer n2 = new Integer(0);
                while (tok1.hasMoreTokens()) {
                    try {
                        Integer n1 = Integer.valueOf(tok1.nextToken());
                        int result = n1.compareTo(n2);
                        if (result == 0) continue;
                        return result;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                return -1;
            }
            if (tok2.hasMoreTokens()) {
                Integer n1 = new Integer(0);
                while (tok2.hasMoreTokens()) {
                    try {
                        Integer n2 = Integer.valueOf(tok2.nextToken());
                        int result = n1.compareTo(n2);
                        if (result == 0) continue;
                        return result;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                return 1;
            }
            return 0;
        }
    }
}

