/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.LinkItem;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdatePropertiesMojo
extends AbstractVersionsUpdaterMojo {
    private static final String REGEX_QUOTE_END = "\\E";
    private static final String REGEX_QUOTE_START = "\\Q";
    private static final String REGEX_QUOTE_END_ESCAPED = "\\E\\\\E\\Q";
    protected LinkItem[] linkItems;
    protected String includeProperties = null;
    protected String excludeProperties = null;

    private static String quote(String s) {
        int i = s.indexOf(REGEX_QUOTE_END);
        if (i == -1) {
            return REGEX_QUOTE_START + s + REGEX_QUOTE_END;
        }
        StringBuffer sb = new StringBuffer(s.length() + 32);
        sb.append(REGEX_QUOTE_START);
        int pos = 0;
        do {
            sb.append(s.substring(pos, i));
            sb.append(REGEX_QUOTE_END_ESCAPED);
        } while ((i = s.indexOf(REGEX_QUOTE_END, pos = i + REGEX_QUOTE_END.length())) != -1);
        sb.append(s.substring(pos, s.length()));
        sb.append(REGEX_QUOTE_END);
        return sb.toString();
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.linkItems == null || this.linkItems.length == 0) {
            this.getLog().info((CharSequence)"Nothing to link");
            return;
        }
        for (int i = 0; i < this.linkItems.length; ++i) {
            VersionRange versionRange;
            LinkItem item = this.linkItems[i];
            if (this.includeProperties != null && this.includeProperties.indexOf(item.getProperty()) < 0) {
                this.getLog().debug((CharSequence)("Skipping update of property \"" + item.getProperty() + "\""));
                continue;
            }
            if (this.excludeProperties != null && this.excludeProperties.indexOf(item.getProperty()) >= 0) {
                this.getLog().debug((CharSequence)("Ignoring update of property \"" + item.getProperty() + "\""));
                continue;
            }
            String itemCoords = ArtifactUtils.versionlessKey((String)item.getGroupId(), (String)item.getArtifactId());
            String curVer = this.getPropertyValue(pom.asStringBuffer(), item.getProperty());
            String version = curVer;
            if (version == null) {
                this.getLog().warn((CharSequence)("This project does not define the property \"" + item.getProperty() + "\""));
                continue;
            }
            if (item.getVersion() != null) {
                version = item.getVersion();
            }
            try {
                versionRange = VersionRange.createFromVersionSpec((String)version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Invalid version range specification for " + item.toString(), (Exception)((Object)e));
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(item.getGroupId(), item.getArtifactId(), versionRange, "pom", null, null);
            ArtifactVersion newVer = this.findLatestVersion(artifact, versionRange, item.getAllowSnapshots());
            if (!this.shouldApplyUpdate(artifact, curVer, newVer)) continue;
            Stack<String> stack = new Stack<String>();
            String path = "";
            Pattern pathRegex = Pattern.compile("/project/properties(?:/profiles/profile)?/" + UpdatePropertiesMojo.quote(item.getProperty()));
            while (pom.hasNext()) {
                XMLEvent event = pom.nextEvent();
                if (event.isStartElement()) {
                    stack.push(path);
                    path = path + "/" + event.asStartElement().getName().getLocalPart();
                    if (pathRegex.matcher(path).matches()) {
                        pom.mark(0);
                    }
                }
                if (!event.isEndElement()) continue;
                if (pathRegex.matcher(path).matches()) {
                    pom.mark(1);
                    if (pom.hasMark(0)) {
                        pom.replaceBetween(0, 1, newVer.toString());
                        this.getLog().info((CharSequence)("Updating " + itemCoords + " from version " + curVer + " to " + newVer));
                        pom.clearMark(0);
                        pom.clearMark(1);
                    }
                }
                path = (String)stack.pop();
            }
        }
    }
}

