/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.plugin;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.core.AssemblyOperation;
import org.codehaus.mojo.unix.maven.plugin.UnknownArtifactException;
import org.codehaus.mojo.unix.util.RelativePath;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssemblyOp {
    private final Map<String, Artifact> mutableArtifactMap = new HashMap<String, Artifact>();
    protected final Map<String, Artifact> artifactMap = Collections.unmodifiableMap(this.mutableArtifactMap);
    protected final String operationType;

    protected AssemblyOp(String operationType) {
        this.operationType = operationType;
    }

    public abstract AssemblyOperation createOperation(FileObject var1, FileAttributes var2, FileAttributes var3) throws MojoFailureException, FileSystemException, UnknownArtifactException;

    public void setArtifactMap(Map<String, Artifact> artifactMap) {
        this.mutableArtifactMap.putAll(artifactMap);
    }

    protected FileObject resolve(FileSystem basedir, File file) throws FileSystemException {
        return basedir.resolveFile(file.getAbsolutePath());
    }

    protected static String nullifEmpty(String artifact) {
        return StringUtils.clean((String)artifact).length() == 0 ? null : artifact;
    }

    protected void validateIsSet(Object valueA, String fieldA) throws MojoFailureException {
        if (valueA == null) {
            throw new MojoFailureException("Field '" + fieldA + "' has to be specified on a " + this.operationType + " operation.");
        }
    }

    protected void validateEitherIsSet(Object valueA, Object valueB, String fieldA, String fieldB) throws MojoFailureException {
        if (valueA != null && valueB != null) {
            throw new MojoFailureException("Only one of '" + fieldA + "' and '" + fieldB + "' can be specified on a " + this.operationType + " operation.");
        }
        if (valueA == null && valueB == null) {
            throw new MojoFailureException("One of '" + fieldA + "' and '" + fieldB + "' has to be specified on a " + this.operationType + " operation.");
        }
    }

    protected RelativePath validateAndResolveOutputFile(File artifactFile, RelativePath toDir, RelativePath toFile) throws MojoFailureException {
        if (toFile != null) {
            if (toDir != null) {
                throw new MojoFailureException("Can't specify both 'toDir' and 'toFile' on a " + this.operationType + " operation.");
            }
            return toFile;
        }
        if (toDir == null) {
            toDir = RelativePath.BASE;
        }
        return toDir.add(artifactFile.getName());
    }

    protected File validateFileIsReadableFile(File file, String fieldName) throws MojoFailureException {
        if (!file.isFile()) {
            throw new MojoFailureException("The path specified in field '" + fieldName + "' on an " + this.operationType + " operation is not a file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new MojoFailureException("The path specified in field '" + fieldName + " on an " + this.operationType + " operation is not readable " + file.getAbsolutePath());
        }
        return file;
    }

    protected File validateFileIsDirectory(File file, String fieldName) throws MojoFailureException {
        if (!file.isDirectory()) {
            throw new MojoFailureException("The path specified in field '" + fieldName + "' on an " + this.operationType + " is not a directory: " + file.getAbsolutePath());
        }
        return file;
    }

    protected File validateArtifact(String artifact) throws UnknownArtifactException {
        Artifact a = this.artifactMap.get(artifact);
        if (a != null) {
            return a.getFile();
        }
        a = this.artifactMap.get(artifact + ":jar");
        if (a != null) {
            return a.getFile();
        }
        throw new UnknownArtifactException(artifact, this.artifactMap);
    }
}

