/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip.internal;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.shared.model.fileset.Mapper;
import org.apache.maven.shared.model.fileset.mappers.FileNameMapper;
import org.apache.maven.shared.model.fileset.mappers.MapperException;
import org.apache.maven.shared.model.fileset.mappers.MapperUtil;
import org.codehaus.mojo.truezip.TrueZipFileSet;
import org.codehaus.mojo.truezip.internal.TrueZipDirectoryScanner;

public class TrueZipFileSetManager {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public Map mapIncludedFiles(TrueZipFileSet fileSet) throws MapperException {
        String[] sourcePaths = this.getIncludedFiles(fileSet);
        LinkedHashMap<String, String> mappedPaths = new LinkedHashMap<String, String>();
        FileNameMapper fileMapper = MapperUtil.getFileNameMapper((Mapper)fileSet.getMapper());
        for (int i = 0; i < sourcePaths.length; ++i) {
            String sourcePath = sourcePaths[i];
            String destPath = fileMapper != null ? fileMapper.mapFileName(sourcePath) : sourcePath;
            mappedPaths.put(sourcePath, destPath);
        }
        return mappedPaths;
    }

    public String[] getIncludedFiles(TrueZipFileSet fileSet) {
        TrueZipDirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getIncludedDirectories(TrueZipFileSet fileSet) {
        TrueZipDirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedFiles(TrueZipFileSet fileSet) {
        TrueZipDirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedDirectories(TrueZipFileSet fileSet) {
        TrueZipDirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public void delete(TrueZipFileSet fileSet) throws IOException {
        this.delete(fileSet, true);
    }

    public void delete(TrueZipFileSet fileSet, boolean throwsError) throws IOException {
        Set deletablePaths = this.findDeletablePaths(fileSet);
        LinkedList warnMessages = new LinkedList();
        for (String path : deletablePaths) {
            String message;
            TFile file = new TFile(fileSet.getDirectory(), path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                if (fileSet.isFollowSymlinks() || !this.isSymlink(file)) {
                    this.removeDir(file, fileSet.isFollowSymlinks(), throwsError, warnMessages);
                    continue;
                }
                if (file.delete()) continue;
                message = "Unable to delete symlink " + file.getAbsolutePath();
                if (!throwsError) continue;
                throw new IOException(message);
            }
            if (this.delete(file)) continue;
            message = "Failed to delete file " + file.getAbsolutePath() + ". Reason is unknown.";
            if (!throwsError) continue;
            throw new IOException(message);
        }
    }

    private boolean isSymlink(TFile file) throws IOException {
        TFile fileInCanonicalParent = null;
        TFile parentDir = file.getParentFile();
        fileInCanonicalParent = parentDir == null ? file : new TFile(parentDir.getCanonicalPath(), file.getName());
        return !fileInCanonicalParent.getCanonicalFile().equals((Object)fileInCanonicalParent.getAbsoluteFile());
    }

    private Set findDeletablePaths(TrueZipFileSet fileSet) {
        Set includes = this.findDeletableDirectories(fileSet);
        includes.addAll(this.findDeletableFiles(fileSet, includes));
        return includes;
    }

    private Set findDeletableDirectories(TrueZipFileSet fileSet) {
        TrueZipDirectoryScanner scanner = this.scan(fileSet);
        if (scanner == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> includes = new HashSet<String>(Arrays.asList(scanner.getIncludedDirectories()));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(scanner.getExcludedDirectories()));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            scanner.setFollowSymlinks(true);
            scanner.scan();
            List<String> includedDirsAndSymlinks = Arrays.asList(scanner.getIncludedDirectories());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(includedDirsAndSymlinks);
            excludes.removeAll(includedDirsAndSymlinks);
        }
        this.excludeParentDirectoriesOfExcludedPaths(excludes, includes);
        includes.addAll(linksForDeletion);
        return includes;
    }

    private Set findDeletableFiles(TrueZipFileSet fileSet, Set deletableDirectories) {
        TrueZipDirectoryScanner scanner = this.scan(fileSet);
        if (scanner == null) {
            return deletableDirectories;
        }
        Set includes = deletableDirectories;
        includes.addAll(Arrays.asList(scanner.getIncludedFiles()));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(scanner.getExcludedFiles()));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            scanner.setFollowSymlinks(true);
            scanner.scan();
            List<String> includedFilesAndSymlinks = Arrays.asList(scanner.getIncludedFiles());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(includedFilesAndSymlinks);
            excludes.removeAll(includedFilesAndSymlinks);
        }
        this.excludeParentDirectoriesOfExcludedPaths(excludes, includes);
        includes.addAll(linksForDeletion);
        return includes;
    }

    private void excludeParentDirectoriesOfExcludedPaths(Collection excludedPaths, Set deletablePaths) {
        for (String path : excludedPaths) {
            String parentPath = new TFile(path).getParent();
            while (parentPath != null) {
                boolean removed = deletablePaths.remove(parentPath);
                parentPath = new TFile(parentPath).getParent();
            }
        }
        if (!excludedPaths.isEmpty()) {
            boolean bl = deletablePaths.remove("");
        }
    }

    private void removeDir(TFile dir, boolean followSymlinks, boolean throwsError, List warnMessages) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            TFile f = new TFile((File)dir, s);
            if (f.isDirectory() && (followSymlinks || !this.isSymlink(f))) {
                this.removeDir(f, followSymlinks, throwsError, warnMessages);
                continue;
            }
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            if (throwsError) {
                throw new IOException(message);
            }
            if (warnMessages.contains(message)) continue;
            warnMessages.add(message);
        }
        if (!this.delete(dir)) {
            String message = "Unable to delete directory " + dir.getAbsolutePath();
            if (throwsError) {
                throw new IOException(message);
            }
        }
    }

    private boolean delete(TFile f) {
        try {
            FileUtils.forceDelete((File)f);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private TrueZipDirectoryScanner scan(TrueZipFileSet fileSet) {
        TFile basedir = new TFile(fileSet.getDirectory());
        if (!basedir.exists() || !basedir.isDirectory()) {
            return null;
        }
        TrueZipDirectoryScanner scanner = new TrueZipDirectoryScanner();
        String[] includesArray = fileSet.getIncludesArray();
        String[] excludesArray = fileSet.getExcludesArray();
        if (includesArray.length > 0) {
            scanner.setIncludes(includesArray);
        }
        if (excludesArray.length > 0) {
            scanner.setExcludes(excludesArray);
        }
        if (fileSet.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        scanner.setBasedir(basedir);
        scanner.setFollowSymlinks(fileSet.isFollowSymlinks());
        scanner.setFollowArchive(fileSet.isFollowArchive());
        scanner.scan();
        return scanner;
    }
}

