/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class MavenLog
implements Log {
    private static final String MAVEN_LOG_ATTRIBUTE = "maven.log";
    private final LogFactory logFactory;

    public MavenLog(LogFactory logFactory) {
        if (logFactory == null) {
            throw new IllegalArgumentException("Log factory cannot be null");
        }
        this.logFactory = logFactory;
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public boolean isDebugEnabled() {
        return this.getMavenLog().isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getMavenLog().isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getMavenLog().isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.getMavenLog().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.isErrorEnabled();
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.debug(message);
        }
    }

    public void trace(Object message, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.debug(message, throwable);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.getMavenLog().debug((CharSequence)String.valueOf(message));
        }
    }

    public void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.getMavenLog().debug((CharSequence)String.valueOf(message), throwable);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.getMavenLog().info((CharSequence)String.valueOf(message));
        }
    }

    public void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.getMavenLog().info((CharSequence)String.valueOf(message), throwable);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.getMavenLog().warn((CharSequence)String.valueOf(message));
        }
    }

    public void warn(Object message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.getMavenLog().warn((CharSequence)String.valueOf(message), throwable);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.getMavenLog().error((CharSequence)String.valueOf(message));
        }
    }

    public void error(Object message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.getMavenLog().error((CharSequence)String.valueOf(message), throwable);
        }
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.error(message);
        }
    }

    public void fatal(Object message, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.error(message, throwable);
        }
    }

    protected org.apache.maven.plugin.logging.Log getMavenLog() {
        org.apache.maven.plugin.logging.Log mavenLog = (org.apache.maven.plugin.logging.Log)this.logFactory.getAttribute(MAVEN_LOG_ATTRIBUTE);
        if (mavenLog == null) {
            throw new LogConfigurationException("The LogFactory attribute maven.log must be set.");
        }
        return mavenLog;
    }
}

