/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.tomcat.AbstractI18NMojo;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractRunMojo
extends AbstractI18NMojo {
    private String packaging;
    private String path;
    private String configurationDir;
    private int port;
    private Embedded container;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isWar()) {
            this.getLog().info((CharSequence)this.getMessage("RunMojo.nonWar"));
            return;
        }
        LogFactory.getFactory().setAttribute("maven.log", (Object)this.getLog());
        try {
            this.initConfiguration();
            this.startContainer();
            this.waitIndefinitely();
        }
        catch (LifecycleException exception) {
            throw new MojoExecutionException(this.getMessage("RunMojo.cannotStart"), (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.getMessage("RunMojo.cannotCreateConfiguration"), (Exception)exception);
        }
    }

    protected String getPath() {
        return this.path;
    }

    protected abstract Context createContext(Embedded var1) throws IOException;

    protected boolean isWar() {
        return "war".equals(this.packaging);
    }

    private void initConfiguration() throws IOException {
        File configurationDirFile = new File(this.configurationDir);
        if (configurationDirFile.exists()) {
            this.getLog().info((CharSequence)this.getMessage("RunMojo.usingConfiguration", this.configurationDir));
        } else {
            this.getLog().info((CharSequence)this.getMessage("RunMojo.creatingConfiguration", this.configurationDir));
            configurationDirFile.mkdirs();
            File confDir = new File(configurationDirFile, "conf");
            confDir.mkdir();
            this.copyFile("/conf/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
            this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            File webappsDir = new File(configurationDirFile, "webapps");
            webappsDir.mkdir();
        }
    }

    private void copyFile(String fromPath, File toFile) throws IOException {
        URL fromURL = ((Object)((Object)this)).getClass().getResource(fromPath);
        if (fromURL == null) {
            throw new FileNotFoundException(fromPath);
        }
        FileUtils.copyURLToFile((URL)fromURL, (File)toFile);
    }

    private void startContainer() throws IOException, LifecycleException {
        this.container = new Embedded();
        this.container.setCatalinaHome(this.configurationDir);
        this.container.setRealm((Realm)new MemoryRealm());
        Context context = this.createContext(this.container);
        String appBase = new File(this.configurationDir, "webapps").getAbsolutePath();
        Host host = this.container.createHost("localHost", appBase);
        host.addChild((Container)context);
        Engine engine = this.container.createEngine();
        engine.setName("localEngine");
        engine.addChild((Container)host);
        engine.setDefaultHost(host.getName());
        this.container.addEngine(engine);
        Connector httpConnector = this.container.createConnector((InetAddress)null, this.port, false);
        this.container.addConnector(httpConnector);
        this.container.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractRunMojo.this.stopContainer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                this.getLog().warn((CharSequence)this.getMessage("RunMojo.interrupted"), (Throwable)exception);
            }
        }
    }

    private void stopContainer() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (LifecycleException exception) {
            this.getLog().warn((CharSequence)this.getMessage("RunMojo.cannotStop"), (Throwable)exception);
        }
    }
}

