/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.codehaus.mojo.tomcat.AbstractI18NMojo;
import org.codehaus.mojo.tomcat.TomcatManager;
import org.codehaus.mojo.tomcat.TomcatManagerException;

public abstract class AbstractCatalinaMojo
extends AbstractI18NMojo {
    private static final String NAME = "Tomcat Maven Plugin";
    private static final String VERSION = "1.0-SNAPSHOT";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private WagonManager wagonManager;
    private URL url;
    private String server;
    private String charset;
    private String path;
    private TomcatManager manager;

    public void execute() throws MojoExecutionException {
        try {
            this.invokeManager();
        }
        catch (TomcatManagerException exception) {
            throw new MojoExecutionException(this.getMessage("AbstractCatalinaMojo.managerError", exception.getMessage()));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.getMessage("AbstractCatalinaMojo.managerIOError"), (Exception)exception);
        }
    }

    protected abstract void invokeManager() throws MojoExecutionException, TomcatManagerException, IOException;

    protected TomcatManager getManager() throws MojoExecutionException {
        if (this.manager == null) {
            String password;
            String userName;
            if (this.server == null) {
                this.getLog().debug((CharSequence)this.getMessage("AbstractCatalinaMojo.defaultAuth"));
                userName = DEFAULT_USERNAME;
                password = DEFAULT_PASSWORD;
            } else {
                AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.server);
                if (info == null) {
                    throw new MojoExecutionException(this.getMessage("AbstractCatalinaMojo.unknownServer", this.server));
                }
                userName = info.getUserName();
                if (userName == null) {
                    this.getLog().debug((CharSequence)this.getMessage("AbstractCatalinaMojo.defaultUserName"));
                    userName = DEFAULT_USERNAME;
                }
                if ((password = info.getPassword()) == null) {
                    this.getLog().debug((CharSequence)this.getMessage("AbstractCatalinaMojo.defaultPassword"));
                    password = DEFAULT_PASSWORD;
                }
            }
            this.manager = new TomcatManager(this.url, userName, password, this.charset);
            this.manager.setUserAgent("Tomcat Maven Plugin/1.0-SNAPSHOT");
        }
        return this.manager;
    }

    protected URL getURL() {
        return this.url;
    }

    protected String getPath() {
        return this.path;
    }

    protected URL getDeployedURL() throws MalformedURLException {
        return new URL(this.getURL(), this.getPath());
    }

    protected void log(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            this.getLog().info((CharSequence)tokenizer.nextToken());
        }
    }
}

