/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenPlugin {
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private Plugin plugin;
    private Xpp3Dom configuration;

    public MavenPlugin(Plugin plugin) {
        this.plugin = plugin;
        this.configuration = (Xpp3Dom)plugin.getConfiguration();
        if (this.configuration == null) {
            this.configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
            plugin.setConfiguration((Object)this.configuration);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getParameter(String key) {
        Xpp3Dom node = this.findNodeWith(key);
        return node == null ? null : node.getValue();
    }

    private static int getIndex(String key) {
        if (key.matches(".*?\\[\\d+\\]")) {
            return Integer.parseInt(StringUtils.substringBetween((String)key, (String)"[", (String)"]"));
        }
        return 0;
    }

    private static String removeIndexSnippet(String key) {
        return StringUtils.substringBefore((String)key, (String)"[");
    }

    private Xpp3Dom findNodeWith(String key) {
        MavenPlugin.checkKeyArgument(key);
        String[] keyParts = key.split("/");
        Xpp3Dom node = this.configuration;
        for (String keyPart : keyParts) {
            if (node.getChildren(MavenPlugin.removeIndexSnippet(keyPart)).length <= MavenPlugin.getIndex(keyPart)) {
                return null;
            }
            if ((node = node.getChildren(MavenPlugin.removeIndexSnippet(keyPart))[MavenPlugin.getIndex(keyPart)]) != null) continue;
            return null;
        }
        return node;
    }

    private static void checkKeyArgument(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 'key' should not be null.");
        }
    }

    public static MavenPlugin getPlugin(MavenProject pom, String groupId, String artifactId) {
        if (pom == null) {
            return null;
        }
        Plugin plugin = null;
        if (pom.getBuildPlugins() != null) {
            plugin = MavenPlugin.getPlugin(pom.getBuildPlugins(), groupId, artifactId);
        }
        if (pom.getPluginManagement() != null) {
            Plugin pluginManagement = MavenPlugin.getPlugin(pom.getPluginManagement().getPlugins(), groupId, artifactId);
            if (plugin == null) {
                plugin = pluginManagement;
            } else if (pluginManagement != null) {
                if (pluginManagement.getConfiguration() != null) {
                    if (plugin.getConfiguration() == null) {
                        plugin.setConfiguration(pluginManagement.getConfiguration());
                    } else {
                        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Xpp3Dom)((Xpp3Dom)pluginManagement.getConfiguration()));
                    }
                }
                if (plugin.getDependencies() == null && pluginManagement.getDependencies() != null) {
                    plugin.setDependencies(pluginManagement.getDependencies());
                }
                if (plugin.getVersion() == null) {
                    plugin.setVersion(pluginManagement.getVersion());
                }
            }
        }
        if (plugin != null) {
            return new MavenPlugin(plugin);
        }
        return null;
    }

    private static Plugin getPlugin(Collection<Plugin> plugins, String groupId, String artifactId) {
        if (plugins == null) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!MavenPlugin.isEqual(plugin, groupId, artifactId)) continue;
            return plugin;
        }
        return null;
    }

    private static boolean isEqual(Plugin plugin, String groupId, String artifactId) {
        if (plugin != null && plugin.getArtifactId().equals(artifactId)) {
            if (plugin.getGroupId() == null) {
                return groupId == null || groupId.equals("org.apache.maven.plugins") || groupId.equals("org.codehaus.mojo");
            }
            return plugin.getGroupId().equals(groupId);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupId", (Object)this.plugin.getGroupId()).append("artifactId", (Object)this.plugin.getArtifactId()).append("version", (Object)this.plugin.getVersion()).toString();
    }
}

