/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.solaris;

import org.codehaus.mojo.solaris.AbstractPrototypeEntry;
import org.codehaus.mojo.solaris.Defaults;

public abstract class AbstractEntryCollection
extends AbstractPrototypeEntry {
    private String[] includes;
    private String[] excludes;

    public AbstractEntryCollection() {
    }

    public AbstractEntryCollection(String pkgClass, String mode, String user, String group, String[] includes, String[] excludes) {
        super(pkgClass, mode, user, group);
        this.includes = includes;
        this.excludes = excludes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void validate(Defaults defaults) {
        super.validate(defaults);
        if (this.includes == null) {
            this.includes = defaults.getIncludes();
        }
        if (this.excludes == null) {
            this.excludes = defaults.getExcludes();
        }
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append(this.getClass().getName()).append(": [").append(EOL).append("includes: ").append(AbstractEntryCollection.toString(this.includes)).append(EOL).append("excludes: ").append(AbstractEntryCollection.toString(this.excludes)).append(EOL).append("pkgClass: ").append(this.getPkgClass()).append(EOL).append("mode: ").append(this.getMode()).append(EOL).append("user: ").append(this.getUser()).append(EOL).append("group: ").append(this.getGroup()).append(EOL).append("]");
        return builder.toString();
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int max = a.length - 1;
        if (max == -1) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == max) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

