/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.mojo.servicedocgen.descriptor.AbstractDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.OperationDescriptor;
import org.codehaus.mojo.servicedocgen.introspection.JType;

public class ServiceDescriptor
extends AbstractDescriptor {
    private String id;
    private String name;
    private String description;
    private String basePath;
    private List<OperationDescriptor> operations;
    private Set<String> consumes;
    private Set<String> produces;
    private JType javaType;

    public String getId() {
        if (this.id == null && this.javaType != null) {
            return this.javaType.getByteType().getRetrievalClass().getName().replaceAll("[.$]", "_");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<OperationDescriptor> getOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationDescriptor>();
        }
        return this.operations;
    }

    public Map<String, List<OperationDescriptor>> getOperationsGroupedByHttpMethod() {
        HashMap<String, List<OperationDescriptor>> map = new HashMap<String, List<OperationDescriptor>>();
        for (OperationDescriptor path : this.getOperations()) {
            ArrayList<OperationDescriptor> pathList = (ArrayList<OperationDescriptor>)map.get(path.getHttpMethod());
            if (pathList == null) {
                pathList = new ArrayList<OperationDescriptor>();
                map.put(path.getHttpMethod(), pathList);
            }
            pathList.add(path);
        }
        return map;
    }

    public void setOperations(List<OperationDescriptor> paths) {
        this.operations = paths;
    }

    public Set<String> getConsumes() {
        if (this.consumes == null) {
            this.consumes = new HashSet<String>();
        }
        return this.consumes;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public Set<String> getProduces() {
        if (this.produces == null) {
            this.produces = new HashSet<String>();
        }
        return this.produces;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    public JType getJavaType() {
        return this.javaType;
    }

    public void setJavaType(JType javaType) {
        this.javaType = javaType;
    }
}

