/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageRmiMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}")
    private File target;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="client")
    private String classifier;
    @Parameter(defaultValue="${project.build.directory}/rmi-classes")
    private File outputDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.includes == null) {
            this.includes = new String[]{"**/*_Stub.class"};
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        File stubJar = new File(this.target, this.finalName + "-" + this.classifier + ".jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.setDestFile(stubJar);
        try {
            jarArchiver.addDirectory(this.outputDirectory, this.includes, this.excludes);
            this.getLog().info((CharSequence)("Building RMI stub jar: " + stubJar.getAbsolutePath()));
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not create the RMI stub jar", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create the RMI stub jar", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "jar", this.classifier, stubJar);
    }
}

